/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.regarima;

import java.util.Formatter;
import java.util.Locale;
import jdplus.sa.base.core.regarima.DemetraUtility;
import jdplus.sa.base.core.regarima.OutliersDetectionModule;
import jdplus.toolkit.base.api.modelling.TransformationType;
import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.regression.IOutlier;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.AdditiveOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.IOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.LevelShiftFactory;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regsarima.regular.ILogLevelModule;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.regsarima.regular.RobustOutliersDetector;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import lombok.Generated;

public class LogLevelModule
implements ILogLevelModule {
    private static final String LL = "log-level test";
    private static final String NEG = "negative values, levels are chosen";
    private static final String FAILED = "log/level failed";
    private static final String LOGS = "logs are chosen";
    private static final String LEVELS = "levels are chosen";
    private final double aiccDiff;
    private final double precision;
    private final LengthOfPeriodType preadjust;
    private final boolean outliersCorrection;
    private RegArimaEstimation<SarimaModel> level;
    private RegArimaEstimation<SarimaModel> log;
    private double aiccLevel;
    private double aiccLog;
    private static final IOutlierFactory[] FAC = new IOutlierFactory[]{AdditiveOutlierFactory.FACTORY, LevelShiftFactory.FACTORY_ZEROENDED};

    public static Builder builder() {
        return new Builder();
    }

    private LogLevelModule(double aiccdiff, double precision, LengthOfPeriodType preadjust, boolean outliersCorrection) {
        this.aiccDiff = aiccdiff;
        this.precision = precision;
        this.preadjust = preadjust;
        this.outliersCorrection = outliersCorrection;
    }

    public double getEpsilon() {
        return this.precision;
    }

    public boolean isChoosingLog() {
        if (this.log == null) {
            return false;
        }
        if (this.level == null) {
            return true;
        }
        return this.aiccLevel > this.aiccLog + this.aiccDiff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult process(RegSarimaModelling modelling) {
        this.clear();
        ProcessingLog logs = modelling.getLog();
        logs.push(LL);
        boolean toClean = false;
        try {
            ModelDescription model = modelling.getDescription();
            if (model.getSeries().getValues().anyMatch(z -> z <= 0.0)) {
                logs.remark(NEG);
                ProcessingResult processingResult = ProcessingResult.Unchanged;
                return processingResult;
            }
            if (this.outliersCorrection) {
                toClean = this.outliers(modelling);
            }
            IRegArimaComputer<SarimaModel> processor = DemetraUtility.processor(true, this.precision);
            this.level = model.estimate(processor);
            ModelDescription logmodel = ModelDescription.copyOf((ModelDescription)model);
            logmodel.setLogTransformation(true);
            if (this.preadjust != LengthOfPeriodType.None && logmodel.remove("lp")) {
                logmodel.setPreadjustment(this.preadjust);
            }
            this.log = logmodel.estimate(processor);
            if (this.level != null) {
                this.aiccLevel = this.level.statistics().getAICC();
            }
            if (this.log != null) {
                this.aiccLog = this.log.statistics().getAICC();
            }
            if (this.level == null && this.log == null) {
                logs.warning(FAILED);
                ProcessingResult processingResult = ProcessingResult.Failed;
                return processingResult;
            }
            Info info = new Info(this.aiccLog, this.aiccLevel, this.aiccDiff);
            if (this.isChoosingLog()) {
                modelling.set(logmodel, this.log);
                logs.info(LOGS, (Object)info);
                ProcessingResult processingResult = ProcessingResult.Changed;
                return processingResult;
            }
            logs.info(LEVELS, (Object)info);
            ProcessingResult processingResult = ProcessingResult.Unchanged;
            return processingResult;
        }
        finally {
            if (toClean) {
                modelling.getDescription().removeVariable(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true));
                modelling.clearEstimation();
            }
            logs.pop();
        }
    }

    private boolean outliers(RegSarimaModelling modelling) {
        RobustOutliersDetector detector = RobustOutliersDetector.builder().criticalValue(5.0).precision(0.001).build();
        ModelDescription desc = modelling.getDescription();
        TsData data = desc.getTransformedSeries();
        FastMatrix regs = desc.regarima().variables();
        try {
            detector.process(data.getValues(), data.getAnnualFrequency(), regs);
            int[][] outliers = detector.getOutliers();
            if (outliers.length == 0) {
                return false;
            }
            for (int i = 0; i < outliers.length; ++i) {
                int[] cur = outliers[i];
                TsPeriod pos = (TsPeriod)data.getPeriod(cur[0]);
                IOutlier o = FAC[cur[1]].make(pos.start());
                desc.addVariable(Variable.variable((String)IOutlier.defaultName((String)o.getCode(), (TsPeriod)pos), (ITsVariable)o, OutliersDetectionModule.attributes(o)));
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    public TransformationType getTransformation() {
        return this.isChoosingLog() ? TransformationType.Log : TransformationType.None;
    }

    public double getAICcLevel() {
        return this.aiccLevel;
    }

    public double getAICcLog() {
        return this.aiccLog;
    }

    private void clear() {
        this.log = null;
        this.level = null;
        this.aiccLevel = 0.0;
        this.aiccLog = 0.0;
    }

    public RegArimaEstimation<SarimaModel> getLevel() {
        return this.level;
    }

    public RegArimaEstimation<SarimaModel> getLog() {
        return this.log;
    }

    public static class Builder {
        private double aiccdiff = -2.0;
        private double precision = 1.0E-7;
        private LengthOfPeriodType preadjust = LengthOfPeriodType.None;
        private boolean outliersCorrection = false;

        public Builder preadjust(LengthOfPeriodType preadjust) {
            this.preadjust = preadjust;
            return this;
        }

        public Builder estimationPrecision(double eps) {
            this.precision = eps;
            return this;
        }

        public Builder aiccLogCorrection(double aiccdiff) {
            this.aiccdiff = aiccdiff;
            return this;
        }

        public Builder outliersCorrection(boolean outliers) {
            this.outliersCorrection = outliers;
            return this;
        }

        public LogLevelModule build() {
            return new LogLevelModule(this.aiccdiff, this.precision, this.preadjust, this.outliersCorrection);
        }
    }

    public static class Info {
        private final double logs;
        private final double levels;
        private final double logpreference;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AICC on logs=").append(new Formatter(Locale.ROOT).format("%6g", this.logs)).append("; ").append("AICC on levels=").append(new Formatter(Locale.ROOT).format("%6g", this.levels)).append("; ").append("(AICC-preference)=").append(new Formatter(Locale.ROOT).format("%6g", this.logpreference)).append(')');
            return builder.toString();
        }

        @Generated
        public double getLogs() {
            return this.logs;
        }

        @Generated
        public double getLevels() {
            return this.levels;
        }

        @Generated
        public double getLogpreference() {
            return this.logpreference;
        }

        @Generated
        public Info(double logs, double levels, double logpreference) {
            this.logs = logs;
            this.levels = levels;
            this.logpreference = logpreference;
        }
    }
}

