/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo.internal;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.core.math.functions.levmar.LevenbergMarquardtMinimizer;
import jdplus.toolkit.base.core.math.functions.ssq.SsqFunctionMinimizer;
import jdplus.toolkit.base.core.regarima.IRegArimaComputer;
import jdplus.toolkit.base.core.regarima.outlier.CriticalValueComputer;
import jdplus.toolkit.base.core.regsarima.GlsSarimaComputer;
import jdplus.toolkit.base.core.regsarima.IArmaInitializer;
import jdplus.toolkit.base.core.regsarima.internal.HannanRissanenInitializer;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.stats.tests.LjungBox;
import lombok.Generated;

public final class TramoUtility {
    public static final double MINCV = 2.0;

    public static int autlar(int n, SarimaOrders spec) {
        int d = spec.getD() + spec.getPeriod() * spec.getBd();
        int q = spec.getQ() + spec.getPeriod() * spec.getBq();
        int p = spec.getP() + spec.getPeriod() * spec.getBp();
        int nd = n - d;
        int nar = (int)Math.log(nd * nd);
        int m = Math.max(p, 2 * q);
        if (m > nar) {
            nar = m;
        }
        if (nar >= nd) {
            nar = nd - nd / 4;
        }
        if (nar > 50) {
            nar = 50;
        }
        int ncol = spec.getP() + (1 + spec.getP()) * spec.getBp() + spec.getQ() + (1 + spec.getQ()) * spec.getBq();
        return nd - nar - Math.max(p, q) - ncol;
    }

    public static boolean meantest(int n, double t) {
        double vct = 2.5;
        if (n <= 80) {
            vct = 1.96;
        } else if (n <= 155) {
            vct = 1.98;
        } else if (n <= 230) {
            vct = 2.1;
        } else if (n <= 320) {
            vct = 2.3;
        }
        return Math.abs(t) > vct;
    }

    public static double PLjungBox(int freq, double[] res, int hp) {
        int n = LjungBox.defaultAutoCorrelationsCount((int)freq);
        StatisticalTest lb = new LjungBox(DoubleSeq.of((double[])res)).hyperParametersCount(hp).lag(n).build();
        return 1.0 - lb.getPvalue();
    }

    public static IRegArimaComputer<SarimaModel> processor(boolean ml, double precision) {
        HannanRissanenInitializer initializer = HannanRissanenInitializer.builder().stabilize(true).useDefaultIfFailed(true).build();
        return GlsSarimaComputer.builder().initializer((IArmaInitializer)initializer).useMaximumLikelihood(ml).minimizer((SsqFunctionMinimizer.Builder)LevenbergMarquardtMinimizer.builder()).precision(precision).build();
    }

    public static double calcCv(int nobs) {
        return Math.max(CriticalValueComputer.simpleComputer().applyAsDouble(nobs), 2.0);
    }

    @Generated
    private TramoUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

