/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.inference.model.Bounds;
import dr.inference.model.MatrixParameter;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;
import dr.math.matrixAlgebra.Matrix;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class ApproximateFactorAnalysisPrecisionMatrix
extends Parameter.Abstract
implements MatrixParameterInterface,
VariableListener {
    private double[] values;
    private double[] storedValues;
    private boolean valuesKnown;
    private boolean storedValuesKnow;
    private final MatrixParameterInterface L;
    private final Parameter gamma;
    private int dim;
    private static final boolean DEBUG = false;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String APPROXIMATE_PARAMETER = "approximateFactorAnalysisPrecision";
        public static final String L_LABEL = "L";
        public static final String GAMMA = "gamma";
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("L", new XMLSyntaxRule[]{new ElementRule(MatrixParameterInterface.class)}), new ElementRule("gamma", new XMLSyntaxRule[]{new ElementRule(Parameter.class)})};

        @Override
        public String getParserName() {
            return APPROXIMATE_PARAMETER;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            MatrixParameterInterface matrixParameterInterface = (MatrixParameterInterface)xMLObject.getElementFirstChild(L_LABEL);
            Parameter parameter = (Parameter)xMLObject.getElementFirstChild(GAMMA);
            String string = xMLObject.hasId() ? xMLObject.getId() : APPROXIMATE_PARAMETER;
            return new ApproximateFactorAnalysisPrecisionMatrix(string, matrixParameterInterface, parameter);
        }

        @Override
        public String getParserDescription() {
            return "A diffusion approximation to a factor analysis";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return ApproximateFactorAnalysisPrecisionMatrix.class;
        }
    };

    public ApproximateFactorAnalysisPrecisionMatrix(String string, MatrixParameterInterface matrixParameterInterface, Parameter parameter) {
        super(string);
        this.L = matrixParameterInterface;
        this.gamma = parameter;
        matrixParameterInterface.addVariableListener(this);
        parameter.addVariableListener(this);
        this.dim = matrixParameterInterface.getRowDimension();
        this.values = new double[this.dim * this.dim];
    }

    private void computeValues() {
        if (!this.valuesKnown) {
            this.computeValuesImp();
            this.valuesKnown = true;
        }
    }

    private void computeValuesImp() {
        int n;
        int n2;
        this.dim = this.L.getRowDimension();
        double[][] dArray = new double[this.dim][this.dim];
        for (n2 = 0; n2 < this.L.getRowDimension(); ++n2) {
            for (n = 0; n < this.L.getRowDimension(); ++n) {
                double d = 0.0;
                for (int i = 0; i < this.L.getColumnDimension(); ++i) {
                    d += this.L.getParameterValue(n2, i) * this.L.getParameterValue(n, i);
                }
                dArray[n2][n] = d;
            }
        }
        for (n2 = 0; n2 < this.dim; ++n2) {
            double[] dArray2 = dArray[n2];
            int n3 = n2;
            dArray2[n3] = dArray2[n3] + 1.0 / this.gamma.getParameterValue(n2);
        }
        dArray = new Matrix(dArray).inverse().toComponents();
        n2 = 0;
        for (n = 0; n < this.dim; ++n) {
            for (int i = 0; i < this.dim; ++i) {
                this.values[n2] = dArray[n][i];
                ++n2;
            }
        }
    }

    @Override
    public String getDimensionName(int n) {
        int n2 = n % this.dim + 1;
        int n3 = n / this.dim + 1;
        return this.getParameterName() + n2 + n3;
    }

    @Override
    public int getDimension() {
        return this.dim * this.dim;
    }

    @Override
    public double getParameterValue(int n) {
        this.computeValues();
        return this.values[n];
    }

    @Override
    public double[][] getParameterAsMatrix() {
        this.computeValues();
        double[][] dArray = new double[this.dim][this.dim];
        for (int i = 0; i < this.dim; ++i) {
            System.arraycopy(this.values, i * this.dim, dArray[i], 0, this.dim);
        }
        return dArray;
    }

    @Override
    public double getParameterValue(int n, int n2) {
        this.computeValues();
        return this.values[n2 * this.dim + n];
    }

    @Override
    public Parameter getParameter(int n) {
        return null;
    }

    @Override
    public double[] getParameterValues() {
        this.computeValues();
        double[] dArray = new double[this.values.length];
        System.arraycopy(this.values, 0, dArray, 0, this.values.length);
        return dArray;
    }

    @Override
    protected void storeValues() {
        this.L.storeParameterValues();
        this.gamma.storeParameterValues();
        if (this.storedValues == null) {
            this.storedValues = new double[this.dim * this.dim];
        }
        System.arraycopy(this.values, 0, this.storedValues, 0, this.values.length);
        this.storedValuesKnow = this.valuesKnown;
    }

    @Override
    protected void restoreValues() {
        this.L.restoreParameterValues();
        this.gamma.restoreParameterValues();
        double[] dArray = this.values;
        this.values = this.storedValues;
        this.storedValues = dArray;
        this.valuesKnown = this.storedValuesKnow;
    }

    @Override
    protected void acceptValues() {
        this.L.acceptParameterValues();
        this.gamma.acceptParameterValues();
    }

    @Override
    protected void adoptValues(Parameter parameter) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValue(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public String getParameterName() {
        return this.getId();
    }

    @Override
    public void addBounds(Bounds<Double> bounds) {
    }

    @Override
    public Bounds<Double> getBounds() {
        return null;
    }

    @Override
    public void addDimension(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double removeDimension(int n) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValue(int n, int n2, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValueQuietly(int n, int n2, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, int n2, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double[] getColumnValues(int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public int getColumnDimension() {
        return this.dim;
    }

    @Override
    public int getRowDimension() {
        return this.dim;
    }

    @Override
    public int getUniqueParameterCount() {
        return 2;
    }

    @Override
    public Parameter getUniqueParameter(int n) {
        return n == 0 ? this.L : this.gamma;
    }

    @Override
    public void copyParameterValues(double[] dArray, int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public void setAllParameterValuesQuietly(double[] dArray, int n) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public String toSymmetricString() {
        return MatrixParameter.toSymmetricString(this);
    }

    @Override
    public boolean isConstrainedSymmetric() {
        return false;
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.valuesKnown = false;
        this.fireParameterChangedEvent();
    }
}

