/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

public class BFloat
implements Cloneable {
    float iF;
    int iE;
    private static final float iRange = 2.028241E31f;
    private static final float iRangeInv = 4.9303807E-32f;
    private static final float iLogRange = (float)Math.log(2.028240960365167E31);
    private static final float iHalfRange = 1.0E18f;
    private static final float iHalfRangeInv = 1.0E-18f;
    private static final int iInfExp = 1000000000;
    private static final boolean iCheckOF = false;
    private static final int iConvTableSize = 100;
    private static float[] iConvTable = new float[100];

    public Object clone() {
        try {
            BFloat bFloat = (BFloat)super.clone();
            bFloat.iE = this.iE;
            bFloat.iF = this.iF;
            return bFloat;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.out.println("BFloat.clone: Something happened that cannot happen -- ?");
            return null;
        }
    }

    public String toString() {
        String string;
        if (this.iE == 1000000000) {
            string = "1.0e+Inf";
        } else if (this.iE == -1000000000) {
            string = "1.0e-Inf";
        } else {
            float f;
            double d = (Math.log(this.iF) + Math.log(2.028240960365167E31) * (double)this.iE) / Math.log(10.0);
            long l = (long)Math.floor(d);
            if ((f = (float)Math.exp((d -= Math.floor(d)) * Math.log(10.0))) >= 10.0f) {
                f = 1.0f;
                ++l;
            }
            string = String.valueOf(f) + "e";
            string = l < 0L ? string + String.valueOf(l) : string + "+" + String.valueOf(l);
        }
        return string;
    }

    private void normalise() {
        if ((double)this.iF > 0.0) {
            while (this.iF > 1.0E18f) {
                this.iF *= 4.9303807E-32f;
                ++this.iE;
            }
            while (this.iF < 1.0E-18f) {
                this.iF *= 2.028241E31f;
                --this.iE;
            }
        } else if ((double)this.iF < 0.0) {
            while (this.iF < -1.0E18f) {
                this.iF *= 4.9303807E-32f;
                ++this.iE;
            }
            while (this.iF > -1.0E-18f) {
                this.iF *= 2.028241E31f;
                --this.iE;
            }
        } else {
            this.iE = -1000000000;
        }
    }

    private void normaliseOnce() {
        if ((double)this.iF > 0.0) {
            if (this.iF > 1.0E18f) {
                this.iF *= 4.9303807E-32f;
                ++this.iE;
            } else if (this.iF < 1.0E-18f) {
                this.iF *= 2.028241E31f;
                --this.iE;
            }
        } else if ((double)this.iF < 0.0) {
            if (this.iF < -1.0E18f) {
                this.iF *= 4.9303807E-32f;
                ++this.iE;
            } else if (this.iF > -1.0E-18f) {
                this.iF *= 2.028241E31f;
                --this.iE;
            }
        } else {
            this.iE = -1000000000;
        }
    }

    public BFloat(float f) {
        this.iF = f;
        this.iE = 0;
        this.normalise();
    }

    public BFloat(double d) {
        int n = 0;
        if (d > 0.0) {
            while (d > (double)1.0E18f) {
                d *= 4.930380657631324E-32;
                ++n;
            }
            while (d < (double)1.0E-18f) {
                d *= 2.028240960365167E31;
                --n;
            }
        } else if (d < 0.0) {
            while (d < (double)-1.0E18f) {
                d *= 4.930380657631324E-32;
                ++n;
            }
            while (d > (double)-1.0E-18f) {
                d *= 2.028240960365167E31;
                --n;
            }
        } else {
            n = -1000000000;
        }
        this.iF = (float)d;
        this.iE = n;
    }

    public BFloat(float f, int n) {
        this.iF = f;
        this.iE = n;
    }

    public static BFloat exp(float f) {
        int n = Math.round(f / iLogRange);
        return new BFloat((float)Math.exp(f - (float)n * iLogRange), n);
    }

    public double log() {
        return (double)this.iE * (double)iLogRange + Math.log(this.iF);
    }

    public void add(BFloat bFloat) {
        if (this.iE >= bFloat.iE) {
            if (this.iE < bFloat.iE + 100) {
                this.iF += bFloat.iF * iConvTable[this.iE - bFloat.iE];
            }
        } else if (this.iE > bFloat.iE - 100) {
            this.iF = bFloat.iF + this.iF * iConvTable[bFloat.iE - this.iE];
            this.iE = bFloat.iE;
        } else {
            this.iF = bFloat.iF;
            this.iE = bFloat.iE;
        }
    }

    public void add(float f) {
        this.add(new BFloat(f));
    }

    public void add(double d) {
        this.add(new BFloat(d));
    }

    public void multiply(BFloat bFloat) {
        this.iF *= bFloat.iF;
        this.iE += bFloat.iE;
        this.normaliseOnce();
    }

    public void multiply(float f) {
        this.multiply(new BFloat(f));
    }

    public void multiply(double d) {
        this.multiply(new BFloat(d));
    }

    static {
        BFloat.iConvTable[0] = 1.0f;
        for (int i = 1; i < 100; ++i) {
            BFloat.iConvTable[i] = iConvTable[i - 1] * 4.9303807E-32f;
        }
    }
}

