## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(HaDeX2)

## ----echo = FALSE-------------------------------------------------------------
colnames <- c("Protein", "Start", "End", "Sequence", "Modification", "Fragment", "MaxUptake", "MHP", "State", "Exposure", "File", "z", "RT", "Inten", "Center")

print(colnames)

## ----echo = FALSE-------------------------------------------------------------
colnames <- c("Protein", "Start", "End", "Sequence", "Modification", "Fragment", "MaxUptake", "MHP", "State", "Exposure", "Center", "Center SD", "Uptake", "Uptake SD", "RT", "RT SD")

print(colnames)

## ----eval = FALSE-------------------------------------------------------------
#  
#  dat <- read.csv(datafile)
#  
#  dat %>%
#      # mock columns
#      mutate(z = 1,
#             Inten = 1,
#             File = "")
#      # exclude unused columns
#      select(-Uptake, -`Uptake SD`, -`Center SD`, -`RT SD`)
#  

## ----eval = FALSE-------------------------------------------------------------
#  
#  kin_dat <- dat %>%
#      # select only one state
#      # exclude measurement without calculated uptake
#      filter(State == state,
#             !is.na(Uptake)) %>%
#      # rename to used convention
#      rename(deut_uptake = Uptake,
#             err_deut_uptake = `Uptake SD`) %>%
#      # exclude unused columns
#      select(-Center, -`Center SD`, -RT, -`RT SD`, -Fragment)
#  

## ----eval = FALSE-------------------------------------------------------------
#  
#  # select FD based on Exposure in time_100
#  fd_dat <- filter(kin_dat, Exposure == time_100) %>%
#      arrange(Start, End) %>%
#      mutate(ID = 1:nrow(.))
#  
#  # normalize the uptake data and calculate uncertainty
#    kin_dat <- merge(kin_dat, fd_dat,
#                 by = c("Protein", "Start", "End", "Sequence", "Modification", "MaxUptake", "MHP", "State"),
#                 suffixes = c("", "_fd")) %>%
#      mutate(frac_deut_uptake = deut_uptake/deut_uptake_fd,
#             err_frac_deut_uptake = sqrt((err_deut_uptake/deut_uptake_fd)^2 + (deut_uptake*err_deut_uptake_fd/deut_uptake_fd^2)^2)) %>%
#      select(-Exposure_fd, -deut_uptake_fd, -err_deut_uptake_fd) %>%
#      filter(Exposure > time_0) %>%
#      arrange(Start, End, State, Exposure) %>%
#      select(ID, everything())
#  
#    attr(kin_dat, "time_100")= time_100
#  

## ----echo= FALSE--------------------------------------------------------------
colnames <- c("Protein State",  "Deut Time", "Experiment", 
                     "Start", "End", "Sequence", "Charge", "Search RT",
                     "Actual RT", "# Spectra", "Peak Width", "m/z Shift",
                     "Max Inty", "Exp Cent", "Theor Cent", "Score", "Cent Diff", 
                     "# Deut", "Deut %", "Confidence")

colnames


## ----echo = FALSE-------------------------------------------------------------
colnames <- c("Protein State", "Protein", "Start"," End", "Sequence", "Peptide Mass", "RT (min)", "Deut Time (sec)", "maxD", "Theor #D", "#D", "%D", "Conf Interval (#D)", "#Rep", "Confidence", "Stddev", "p")

colnames


## ----eval = FALSE-------------------------------------------------------------
#  # select only necessary columns
#  dat <- dat[c(1:6, 8:12)]
#  # adjust column names
#  colnames(dat) <- c("State", "Protein", "Start", "End", "Sequence", "MHP",  "Exposure", "MaxUptake", "theo_deut_uptake", "deut_uptake", "frac_deut_uptake")
#  # change units
#  dat["Exposure"] <- dat["Exposure"]/60
#  dat["frac_deut_uptake"] <- dat["frac_deut_uptake"]/100
#  
#  # add ID
#  peptide_list <- select(dat, Sequence, Start, End) %>%
#    arrange(Start, End) %>%
#    unique() %>%
#    mutate(ID = 1:nrow(.))
#  
#  kin_dat <- merge(dat, peptide_list, by = c("Sequence", "Start", "End")) %>%
#    arrange(Start, End)
#  
#  # mock uncertainty for plots
#  kin_dat["err_frac_deut_uptake"] <- 0
#  kin_dat["err_deut_uptake"] <- 0
#  

## ----eval = FALSE-------------------------------------------------------------
#  # select one state for classification
#  kin_dat <- filter(kin_dat, State == unique(kin_dat[["State"]])[1] )
#  
#  # show uptake dat in form of chiclet plot
#  plot_chiclet(kin_dat, fractional = FALSE)
#  

