/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.hups;

import umontreal.iro.lecuyer.hups.ContainerPointSet;
import umontreal.iro.lecuyer.hups.PointSet;
import umontreal.iro.lecuyer.hups.PointSetIterator;

public class AntitheticPointSet
extends ContainerPointSet {
    public AntitheticPointSet(PointSet pointSet) {
        this.init(pointSet);
    }

    public double getCoordinate(int n, int n2) {
        return 1.0 - this.P.getCoordinate(n, n2);
    }

    public PointSetIterator iterator() {
        return new AntitheticPointSetIterator();
    }

    public String toString() {
        return "Antithetic point set of: {\n" + this.P.toString() + "\n}";
    }

    public String formatPoints() {
        try {
            return super.formatPoints();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return "The values are 1-u for each coordinate:\n {" + this.P.formatPoints() + "\n}";
        }
    }

    protected class AntitheticPointSetIterator
    extends ContainerPointSet.ContainerPointSetIterator {
        protected AntitheticPointSetIterator() {
            super(AntitheticPointSet.this);
        }

        public double nextCoordinate() {
            return 1.0 - this.innerIterator.nextCoordinate();
        }

        public double nextDouble() {
            return 1.0 - this.innerIterator.nextCoordinate();
        }

        public void nextCoordinates(double[] dArray, int n) {
            this.innerIterator.nextCoordinates(dArray, n);
            for (int i = 0; i < n; ++i) {
                dArray[i] = 1.0 - dArray[i];
            }
        }

        public int nextPoint(double[] dArray, int n) {
            this.innerIterator.nextPoint(dArray, n);
            for (int i = 0; i < n; ++i) {
                dArray[i] = 1.0 - dArray[i];
            }
            return this.getCurPointIndex();
        }
    }
}

