/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v21;

import it.bancaditalia.oss.sdmx.api.Codelist;
import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dimension;
import it.bancaditalia.oss.sdmx.api.SDMXReference;
import it.bancaditalia.oss.sdmx.api.SdmxAttribute;
import it.bancaditalia.oss.sdmx.client.Parser;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxXmlContentException;
import it.bancaditalia.oss.sdmx.parser.v21.CodelistParser;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.LocalizedText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class DataStructureParser
implements Parser<List<DataFlowStructure>> {
    private static final String sourceClass = DataStructureParser.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();
    static final String DATASTRUCTURE = "DataStructure";
    static final String CODELISTS = "Codelists";
    static final String CODELIST = "Codelist";
    static final String CODE = "Code";
    static final String CONCEPTS = "Concepts";
    static final String CONCEPT = "Concept";
    static final String NAME = "Name";
    static final String DIMENSIONLIST = "DimensionList";
    static final String GROUP = "Group";
    static final String ATTRIBUTELIST = "AttributeList";
    static final String MEASURELIST = "MeasureList";
    static final String DIMENSION = "Dimension";
    static final String ATTRIBUTE = "Attribute";
    static final String TIMEDIMENSION = "TimeDimension";
    static final String PRIMARYMEASURE = "PrimaryMeasure";
    static final String POSITION = "position";
    static final String ID = "id";
    static final String AGENCYID = "agencyID";
    static final String VERSION = "version";
    static final String LOCAL_REPRESENTATION = "LocalRepresentation";
    static final String REF = "Ref";
    static final String CONCEPT_IDENTITY = "ConceptIdentity";

    @Override
    public List<DataFlowStructure> parse(XMLEventReader xMLEventReader, List<Locale.LanguageRange> list) throws XMLStreamException, SdmxException {
        logger.entering(sourceClass, "parse");
        ArrayList<DataFlowStructure> arrayList = new ArrayList<DataFlowStructure>();
        Map<String, Codelist> map = null;
        Map<String, String> map2 = null;
        DataFlowStructure dataFlowStructure = null;
        LocalizedText localizedText = new LocalizedText(list);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart() == DATASTRUCTURE) {
                    logger.finer("Got data structure.");
                    localizedText = new LocalizedText(list);
                    String string = null;
                    String string2 = null;
                    String string3 = null;
                    for (Attribute attribute : startElement::getAttributes) {
                        switch (attribute.getName().toString()) {
                            case "id": {
                                string = attribute.getValue();
                                break;
                            }
                            case "agencyID": {
                                string2 = attribute.getValue();
                                break;
                            }
                            case "version": {
                                string3 = attribute.getValue();
                            }
                        }
                    }
                    dataFlowStructure = new DataFlowStructure(string, string2, string3);
                } else {
                    switch (startElement.getName().getLocalPart()) {
                        case "Name": {
                            localizedText.setText(startElement, xMLEventReader);
                            break;
                        }
                        case "Codelists": {
                            map = DataStructureParser.getCodelists(xMLEventReader, list);
                            break;
                        }
                        case "Concepts": {
                            map2 = DataStructureParser.getConcepts(xMLEventReader, list);
                            break;
                        }
                        case "DimensionList": {
                            DataStructureParser.setStructureDimensions(dataFlowStructure, xMLEventReader, map, map2);
                            break;
                        }
                        case "Group": {
                            DataStructureParser.setStructureGroups(dataFlowStructure, xMLEventReader);
                            break;
                        }
                        case "AttributeList": {
                            DataStructureParser.setStructureAttributes(dataFlowStructure, xMLEventReader, map, map2);
                            break;
                        }
                        case "MeasureList": {
                            DataStructureParser.setStructureMeasures(dataFlowStructure, xMLEventReader);
                        }
                    }
                }
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(DATASTRUCTURE)) continue;
            logger.finer("Adding data structure. " + dataFlowStructure);
            dataFlowStructure.setName(localizedText.getText());
            arrayList.add(dataFlowStructure);
        }
        logger.exiting(sourceClass, "parse");
        return arrayList;
    }

    private static void setStructureAttributes(DataFlowStructure dataFlowStructure, XMLEventReader xMLEventReader, Map<String, Codelist> map, Map<String, String> map2) throws XMLStreamException {
        logger.entering(sourceClass, "setStructureAttributes");
        String string = null;
        String string2 = null;
        Codelist codelist = null;
        while (xMLEventReader.hasNext()) {
            Object object;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                object = xMLEvent.asStartElement();
                if (object.getName().getLocalPart().equals(ATTRIBUTE)) {
                    logger.finer("Got attribute");
                    string = null;
                    string2 = null;
                    codelist = null;
                    for (Attribute attribute : ((StartElement)object)::getAttributes) {
                        if (!attribute.getName().toString().equals(ID)) continue;
                        string = attribute.getValue();
                    }
                    if (string == null || string.isEmpty()) {
                        throw new RuntimeException("Error during Structure Parsing. Invalid attribute id: " + string);
                    }
                } else if (object.getName().getLocalPart().equals(LOCAL_REPRESENTATION)) {
                    logger.finer("Got codelist");
                    SDMXReference sDMXReference = DataStructureParser.getRefCoordinates(xMLEventReader);
                    if (map != null && sDMXReference != null) {
                        codelist = map.containsKey(sDMXReference.getFullIdentifier()) ? map.get(sDMXReference.getFullIdentifier()) : new Codelist(sDMXReference, null, null);
                    }
                } else if (object.getName().getLocalPart().equals(CONCEPT_IDENTITY)) {
                    logger.finer("Got concept identity");
                    if (map2 != null && (string2 = DataStructureParser.getConceptName(map2, xMLEventReader)) != null) {
                        codelist = map != null && map.containsKey(string2) ? map.get(string2) : new Codelist(string2, null, null);
                    }
                }
            }
            if (!xMLEvent.isEndElement()) continue;
            if (xMLEvent.asEndElement().getName().getLocalPart().equals(ATTRIBUTE)) {
                if (dataFlowStructure != null) {
                    object = new SdmxAttribute(string, string2, codelist);
                    logger.finer("Adding attribute: " + object);
                    dataFlowStructure.addAttribute((SdmxAttribute)object);
                    continue;
                }
                throw new RuntimeException("Error during Structure Parsing. Null current structure or dimension.");
            }
            if (!xMLEvent.asEndElement().getName().getLocalPart().equals(ATTRIBUTELIST)) continue;
            break;
        }
        logger.exiting(sourceClass, "setStructureAttributes");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setStructureDimensions(DataFlowStructure dataFlowStructure, XMLEventReader xMLEventReader, Map<String, Codelist> map, Map<String, String> map2) throws XMLStreamException, SdmxXmlContentException {
        logger.entering(sourceClass, "setStructureDimensions");
        int n = 0;
        String string = null;
        Codelist codelist = null;
        String string2 = null;
        while (xMLEventReader.hasNext()) {
            Object object;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                object = xMLEvent.asStartElement();
                if (object.getName().getLocalPart().equals(DIMENSION)) {
                    logger.finer("Got dimension");
                    string = null;
                    codelist = null;
                    string2 = null;
                    for (Attribute attribute : ((StartElement)object)::getAttributes) {
                        if (!attribute.getName().toString().equals(ID)) continue;
                        string = attribute.getValue();
                    }
                    if (string == null || string.isEmpty()) throw new RuntimeException("Error during Structure Parsing. Invalid dimension id: " + string);
                    ++n;
                } else if (object.getName().getLocalPart().equals(TIMEDIMENSION)) {
                    logger.finer("Got time dimension");
                    string = null;
                    codelist = null;
                    string2 = null;
                    for (Attribute attribute : ((StartElement)object)::getAttributes) {
                        if (!attribute.getName().toString().equals(ID)) continue;
                        string = attribute.getValue();
                    }
                    if (string == null || string.isEmpty()) throw new RuntimeException("Error during Structure Parsing. Invalid time dimension: " + string);
                    if (dataFlowStructure == null) throw new RuntimeException("Error during Structure Parsing. Null current Structure.");
                    logger.finer("Adding time dimension: " + string);
                    dataFlowStructure.setTimeDimension(string);
                } else if (object.getName().getLocalPart().equals(LOCAL_REPRESENTATION)) {
                    logger.finer("Got codelist");
                    Iterator iterator = DataStructureParser.getRefCoordinates(xMLEventReader);
                    codelist = map != null && iterator != null && map.containsKey(((SDMXReference)((Object)iterator)).getFullIdentifier()) ? map.get(((SDMXReference)((Object)iterator)).getFullIdentifier()) : new Codelist((SDMXReference)((Object)iterator), null, null);
                } else if (object.getName().getLocalPart().equals(CONCEPT_IDENTITY)) {
                    logger.finer("Got concept identity");
                    if (map2 != null) {
                        string2 = DataStructureParser.getConceptName(map2, xMLEventReader);
                        if (string2 != null) {
                            codelist = map != null && map.containsKey(string2) ? map.get(string2) : new Codelist(string2, null, null);
                        } else {
                            logger.finer("dimension " + string + " has no concept or local representation");
                        }
                    }
                }
            }
            if (!xMLEvent.isEndElement()) continue;
            if (xMLEvent.asEndElement().getName().getLocalPart().equals(DIMENSION)) {
                if (dataFlowStructure == null) throw new RuntimeException("Error during Structure Parsing. Null current structure or dimension.");
                object = new Dimension(string, string2, codelist, n);
                logger.finer("Adding dimension: " + object);
                dataFlowStructure.addDimension((Dimension)object);
                continue;
            }
            if (!xMLEvent.asEndElement().getName().getLocalPart().equals(DIMENSIONLIST)) continue;
            break;
        }
        logger.exiting(sourceClass, "setStructureDimensions");
    }

    private static SDMXReference getRefCoordinates(XMLEventReader xMLEventReader) throws XMLStreamException {
        logger.entering(sourceClass, "getRefCoordinates");
        SDMXReference sDMXReference = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                StartElement startElement = xMLEvent.asStartElement();
                if (!startElement.getName().getLocalPart().equals(REF)) continue;
                logger.finer("Got <Ref>");
                String string = null;
                String string2 = null;
                String string3 = null;
                for (Attribute attribute : startElement::getAttributes) {
                    switch (attribute.getName().toString()) {
                        case "id": {
                            string = attribute.getValue();
                            break;
                        }
                        case "agencyID": {
                            string2 = attribute.getValue();
                            break;
                        }
                        case "version": {
                            string3 = attribute.getValue();
                        }
                    }
                }
                if (string != null && !string.isEmpty()) {
                    sDMXReference = new SDMXReference(string, string2, string3);
                    logger.finer("Found coordinates: " + sDMXReference.getFullIdentifier());
                    continue;
                }
                throw new RuntimeException("Error during Structure Parsing. Invalid time dimension: " + string);
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(LOCAL_REPRESENTATION)) continue;
            break;
        }
        logger.exiting(sourceClass, "getRefCoordinates");
        return sDMXReference;
    }

    private static void setStructureGroups(DataFlowStructure dataFlowStructure, XMLEventReader xMLEventReader) throws XMLStreamException {
        logger.entering(sourceClass, "setStructureGroups");
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(GROUP)) continue;
            break;
        }
        logger.exiting(sourceClass, "setStructureGroups");
    }

    private static void setStructureMeasures(DataFlowStructure dataFlowStructure, XMLEventReader xMLEventReader) throws XMLStreamException {
        logger.entering(sourceClass, "setStructureMeasures");
        while (xMLEventReader.hasNext()) {
            StartElement startElement;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement() && (startElement = xMLEvent.asStartElement()).getName().getLocalPart().equals(PRIMARYMEASURE)) {
                logger.finer("Got primary measure");
                Iterator<Attribute> iterator = startElement.getAttributes();
                String string = null;
                while (iterator.hasNext()) {
                    Attribute attribute = iterator.next();
                    if (!attribute.getName().toString().equals(ID)) continue;
                    string = attribute.getValue();
                }
                if (string != null && !string.isEmpty()) {
                    if (dataFlowStructure != null) {
                        logger.finer("Adding primary measure: " + string);
                        dataFlowStructure.setMeasure(string);
                        continue;
                    }
                    throw new RuntimeException("Error during Structure Parsing. Null current Structure.");
                }
                throw new RuntimeException("Error during Structure Parsing. Invalid primary measure: " + string);
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(MEASURELIST)) continue;
            break;
        }
        logger.exiting(sourceClass, "setStructureMeasures");
    }

    private static Map<String, Codelist> getCodelists(XMLEventReader xMLEventReader, List<Locale.LanguageRange> list) throws XMLStreamException, SdmxException {
        HashMap<String, Codelist> hashMap = new HashMap<String, Codelist>();
        while (xMLEventReader.hasNext()) {
            StartElement startElement;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement() && (startElement = xMLEvent.asStartElement()).getName().getLocalPart().equals(CODELIST)) {
                Object object;
                Iterator<Attribute> iterator = startElement.getAttributes();
                String string = null;
                String string2 = null;
                String string3 = null;
                while (iterator.hasNext()) {
                    object = iterator.next();
                    if (object.getName().toString().equals(ID)) {
                        string = object.getValue();
                        continue;
                    }
                    if (object.getName().toString().equals(AGENCYID)) {
                        string2 = object.getValue();
                        continue;
                    }
                    if (!object.getName().toString().equals(VERSION)) continue;
                    string3 = object.getValue();
                }
                logger.finer("Got codelist: " + string);
                object = CodelistParser.getCodes(new SDMXReference(string, string2, string3), xMLEventReader, list);
                hashMap.put(((SDMXReference)object).getFullIdentifier(), (Codelist)object);
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(CODELISTS)) continue;
            break;
        }
        return hashMap;
    }

    private static Map<String, String> getConcepts(XMLEventReader xMLEventReader, List<Locale.LanguageRange> list) throws XMLStreamException, SdmxException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = "";
        String string2 = "";
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                Object object;
                Iterator<Attribute> iterator;
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart().equals("ConceptScheme")) {
                    iterator = startElement.getAttributes();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        if (object.getName().toString().equals(AGENCYID)) {
                            string = object.getValue();
                            continue;
                        }
                        if (!object.getName().toString().equals(VERSION)) continue;
                        string2 = object.getValue();
                    }
                } else if (startElement.getName().getLocalPart().equals(CONCEPT)) {
                    iterator = startElement.getAttributes();
                    object = null;
                    String string3 = "";
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        if (!attribute.getName().toString().equals(ID)) continue;
                        object = attribute.getValue();
                    }
                    if (object != null) {
                        string3 = string + "/" + (String)object + "/" + string2;
                        logger.finer("Got concept: " + string3);
                        hashMap.put(string3, DataStructureParser.getConceptCodeList(xMLEventReader));
                    } else {
                        logger.warning("Found concept without an id. Skipping");
                    }
                }
            }
            if (!xMLEvent.isEndElement() || !xMLEvent.asEndElement().getName().getLocalPart().equals(CONCEPTS)) continue;
            break;
        }
        return hashMap;
    }

    private static String getConceptCodeList(XMLEventReader xMLEventReader) throws XMLStreamException, SdmxException {
        String string = null;
        while (xMLEventReader.hasNext()) {
            Object object;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement() && (object = xMLEvent.asStartElement()).getName().getLocalPart() == REF) {
                Iterator<Attribute> iterator = object.getAttributes();
                String string2 = null;
                String string3 = null;
                while (iterator.hasNext()) {
                    Attribute attribute = iterator.next();
                    if (attribute.getName().toString().equals(ID)) {
                        string = attribute.getValue();
                        continue;
                    }
                    if (attribute.getName().toString().equals(AGENCYID)) {
                        string2 = attribute.getValue();
                        continue;
                    }
                    if (!attribute.getName().toString().equals(VERSION)) continue;
                    string3 = attribute.getValue();
                }
                if (string != null) {
                    if (string2 != null) {
                        string = string2 + "/" + string;
                    }
                    if (string3 != null) {
                        string = string + "/" + string3;
                    }
                }
                logger.finer("Got codelist: " + string);
            }
            if (!xMLEvent.isEndElement() || !((String)(object = xMLEvent.asEndElement().getName().getLocalPart())).equals(CONCEPT)) continue;
            break;
        }
        return string;
    }

    private static String getConceptName(Map<String, String> map, XMLEventReader xMLEventReader) throws XMLStreamException {
        String string = null;
        while (xMLEventReader.hasNext()) {
            Object object;
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement() && (object = xMLEvent.asStartElement()).getName().getLocalPart() == REF) {
                Iterator<Attribute> iterator = object.getAttributes();
                String string2 = null;
                String string3 = "";
                String string4 = "";
                while (iterator.hasNext()) {
                    Attribute attribute = iterator.next();
                    if (attribute.getName().toString().equals(ID)) {
                        string2 = attribute.getValue();
                        continue;
                    }
                    if (attribute.getName().toString().equals(AGENCYID)) {
                        string4 = attribute.getValue();
                        continue;
                    }
                    if (!attribute.getName().toString().equals("maintainableParentVersion")) continue;
                    string3 = attribute.getValue();
                }
                string = map.get(string4 + "/" + string2 + "/" + string3);
            }
            if (!xMLEvent.isEndElement() || !((String)(object = xMLEvent.asEndElement().getName().getLocalPart())).equals(CONCEPT_IDENTITY)) continue;
            break;
        }
        return string;
    }
}

