## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----echo = FALSE, eval = FALSE-----------------------------------------------
#  set.seed(27)
#  
#  x <- rep(0, 62)
#  ones <- sample(62, 17)
#  x[ones] <- 1
#  dput(x)

## -----------------------------------------------------------------------------
n <- 62
pi <- 17 / 62
pi_0 <- 0.2

# calculate the z-statistic
z_stat <- (pi - pi_0) / sqrt(pi_0 * (1 - pi_0) / n)
z_stat

## -----------------------------------------------------------------------------
library(distributions3)

Z <- Normal(0, 1)  # make a standard normal r.v.
1 - cdf(Z, 1.46) + cdf(Z, -1.46)

## -----------------------------------------------------------------------------
1 - cdf(Z, abs(z_stat)) + cdf(Z, -abs(z_stat))

## -----------------------------------------------------------------------------
2 * cdf(Z, -1.46)

## -----------------------------------------------------------------------------
1 - cdf(Z, 1.46)

## -----------------------------------------------------------------------------
cdf(Z, 1.46)

