/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.options;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.af.commons.widgets.validate.ValidationException;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.options.OptionsPanel;

public class NumericPanel
extends OptionsPanel
implements ActionListener {
    private JCheckBox useEpsApprox;
    private JTextField jtfEps;
    private JCheckBox tryToSimplify;
    private JTextField jtfDigits;
    private JCheckBox verbose;
    private Configuration conf;
    private JTextField numberOfSimulations;
    private JComboBox randomNumbers;
    private JComboBox upscale;
    private JCheckBox useSeed;
    private JTextField seed;
    private JLabel seedLabel = new JLabel("Random number seed:");

    public NumericPanel(Configuration conf) {
        this.conf = conf;
        this.makeComponents();
        this.doTheLayout();
    }

    private void makeComponents() {
        this.useEpsApprox = new JCheckBox("Use epsilon approximation");
        this.useEpsApprox.setSelected(this.conf.getGeneralConfig().useEpsApprox());
        this.useEpsApprox.addActionListener(this);
        this.useEpsApprox.setEnabled(false);
        this.useEpsApprox.setToolTipText("<html>In this version this option can not be changed.<br>No calculations with infinitesimal small values are done<br>but instead the epsilon is approximated by a small real number.</html>");
        this.jtfEps = new JTextField(30);
        this.jtfEps.setText("" + this.conf.getGeneralConfig().getEpsilon());
        this.jtfEps.setEnabled(this.conf.getGeneralConfig().useEpsApprox());
        this.jtfEps.setToolTipText("<html>The small real value that should be used to approximate<br>the infinitesimal small epsilon. Default is 0.001.</html>");
        this.tryToSimplify = new JCheckBox("Try to show fractions / rounded numbers");
        this.tryToSimplify.setSelected(this.conf.getGeneralConfig().simplify());
        this.tryToSimplify.addActionListener(this);
        this.tryToSimplify.setEnabled(false);
        this.tryToSimplify.setToolTipText("<html></html>");
        this.jtfDigits = new JTextField(30);
        this.jtfDigits.setText("" + this.conf.getGeneralConfig().getDigits2());
        this.jtfDigits.setEnabled(this.conf.getGeneralConfig().simplify());
        this.jtfDigits.setToolTipText("<html></html>");
        this.verbose = new JCheckBox("Verbose output of algorithms");
        this.verbose.setSelected(this.conf.getGeneralConfig().verbose());
        this.verbose.setToolTipText("<html>If selected the algorithms produce a verbose<br>output that is shown in the GUI. For example the Simes<br>test specifies for each intersection of elementar hypotheses<br>whether and why it could be rejected.</html>");
        this.numberOfSimulations = new JTextField(30);
        this.numberOfSimulations.setText("" + this.conf.getGeneralConfig().getNumberOfSimulations());
        this.numberOfSimulations.setToolTipText("<html>The Monte Carlo sample size for power calculations.<br>Default is 10000.</html>");
        this.randomNumbers = new JComboBox<String>(new String[]{"quasirandom", "pseudorandom"});
        this.randomNumbers.setSelectedIndex(this.conf.getGeneralConfig().getTypeOfRandom().equals("quasirandom") ? 0 : 1);
        this.randomNumbers.setToolTipText("<html>You can select quasirandom or pseudorandom numbers for<br>power calculations. The quasirandom option uses a randomized<br>Lattice rule, and should be more efficient than the<br>pseudorandom option that uses ordinary (pseudo) random numbers.</html>");
        this.upscale = new JComboBox<String>(new String[]{"Yes", "No"});
        this.upscale.setSelectedIndex(this.conf.getGeneralConfig().getUpscale() ? 0 : 1);
        this.upscale.setToolTipText("<html>If 'No' is selected then for each intersection of hypotheses (i.e. each subgraph)<br>a weighted test is performed at the possibly reduced level alpha of sum(w)*alpha,<br>where sum(w) is the sum of all node weights in this subset.<br>If 'Yes' is selected all weights are upscaled, so that sum(w)=1.<br>Please see the manual for a longer explanation and examples.</html>");
        this.useSeed = new JCheckBox("Use random number seed");
        this.useSeed.setSelected(this.conf.getGeneralConfig().useSeed());
        this.useSeed.addActionListener(this);
        this.useSeed.setToolTipText("<html>If selected a user specified seed is used to set the random number<br>generator state to the specified value. This way all calculations<br>involving random numbers give a reproducable result.</html>");
        this.seed = new JTextField(30);
        this.seed.setEnabled(this.useSeed.isSelected());
        this.seedLabel.setEnabled(this.useSeed.isSelected());
        this.seed.setText("" + this.conf.getGeneralConfig().getSeed());
        this.seed.setToolTipText("<html>Integer seed value to use for random number generation.</html>");
    }

    private void doTheLayout() {
        JPanel p1 = new JPanel();
        String cols = "pref, 5dlu, fill:pref:grow";
        String rows = "pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref";
        FormLayout layout = new FormLayout(cols, rows);
        p1.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 1;
        p1.add((Component)this.useEpsApprox, cc.xyw(1, row, 3));
        p1.add((Component)new JLabel("Epsilon:"), cc.xy(1, row += 2));
        p1.add((Component)this.jtfEps, cc.xy(3, row));
        p1.add((Component)this.verbose, cc.xyw(1, row += 2, 3));
        p1.add((Component)new JLabel("Monte Carlo sample size for power:"), cc.xy(1, row += 2));
        p1.add((Component)this.numberOfSimulations, cc.xy(3, row));
        p1.add((Component)new JLabel("Type of random numbers:"), cc.xy(1, row += 2));
        p1.add((Component)this.randomNumbers, cc.xy(3, row));
        p1.add((Component)new JLabel("Weights of subgraphs are upscaled to 1:"), cc.xy(1, row += 2));
        p1.add((Component)this.upscale, cc.xy(3, row));
        this.add(p1);
        p1.add((Component)this.useSeed, cc.xyw(1, row += 2, 3));
        p1.add((Component)this.seedLabel, cc.xy(1, row += 2));
        p1.add((Component)this.seed, cc.xy(3, row));
    }

    @Override
    public void setProperties() throws ValidationException {
        this.conf.getGeneralConfig().setVerbose(this.verbose.isSelected());
        this.conf.getGeneralConfig().setUseEpsApprox(this.useEpsApprox.isSelected());
        try {
            double eps = Double.parseDouble(this.jtfEps.getText());
            this.conf.getGeneralConfig().setEps(eps);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\"" + this.jtfEps.getText() + "\" is not a valid double for epsilon.", "Invalid input", 0);
        }
        this.conf.getGeneralConfig().setSimplify(this.tryToSimplify.isSelected());
        try {
            int nr = Integer.parseInt(this.jtfDigits.getText());
            this.conf.getGeneralConfig().setDigits2(nr);
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\"" + this.jtfDigits.getText() + "\" is not a valid integer.", "Invalid input", 0);
        }
        try {
            this.conf.getGeneralConfig().setNumberOfSimulations(Integer.parseInt(this.numberOfSimulations.getText()));
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\"" + this.numberOfSimulations.getText() + "\" is not a valid integer.", "Invalid input", 0);
        }
        this.conf.getGeneralConfig().setTypeOfRandom(this.randomNumbers.getSelectedItem().toString());
        this.conf.getGeneralConfig().setUpscale(this.upscale.getSelectedIndex() == 0);
        this.conf.getGeneralConfig().setUseSeed(this.useSeed.isSelected());
        try {
            this.conf.getGeneralConfig().setSeed(Integer.parseInt(this.seed.getText()));
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this, "\"" + this.seed.getText() + "\" is not a valid integer.", "Invalid input", 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.useEpsApprox) {
            this.jtfEps.setEnabled(this.useEpsApprox.isSelected());
        }
        if (e.getSource() == this.useSeed) {
            this.seed.setEnabled(this.useSeed.isSelected());
            this.seedLabel.setEnabled(this.useSeed.isSelected());
        }
    }
}

