## Test that grouping terms works
expect_identical(odyssey:::build_query(c("A", "B")), "(A OR B)")
expect_identical(odyssey:::build_query(list("A", "B")), "(A AND B)")

## Test that infix operators work
expect_identical("A" %OR% "B", "A OR B")
expect_identical("A" %AND% "B", "A AND B")

expect_identical(
  "Paris" %AND% "France" %AND% "history" %NOT% list("Texas", "history"),
  "Paris AND France AND history NOT (Texas AND history)"
)
expect_identical(
  "Journal" %AND% c("Histoire", "History"),
  "Journal AND (Histoire OR History)"
)

expect_identical("aluminium" %BY% 1, "aluminium~1")
expect_identical(c("aluminium", "fer") %BY% 3, '"aluminium fer"~3')

expect_identical(c("japon", "france") %IN% "title_t", "title_t:(japon OR france)")

expect_identical("Aa" %TO% "Ab" %IN% "city_s", "city_s:[Aa TO Ab]")
expect_identical(2000 %TO% 2013, "[2000 TO 2013]")
expect_identical("" %TO% "", '["" TO *]')
