/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nu.xom.Element;
import nu.xom.Elements;
import org.xmlcml.cml.base.CMLConstants;

public class CMLElements<E extends Element>
implements Iterable<E>,
CMLConstants {
    private ArrayList<E> elementsArray;
    private Class<?> type;

    public CMLElements(Elements elements) {
        if (elements == null) {
            this.elementsArray = new ArrayList(0);
        } else {
            this.elementsArray = new ArrayList(elements.size());
            for (int i = 0; i < elements.size(); ++i) {
                if (i == 0) {
                    this.type = elements.get(0).getClass();
                }
                if (!elements.get(i).getClass().equals(this.type)) {
                    throw new RuntimeException("Elements list contains elements of different types");
                }
                Element elem = elements.get(i);
                this.elementsArray.add(elem);
            }
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new CMLElementsIterator<E>(this.elementsArray);
    }

    public E get(int i) {
        return (E)(i < 0 || i >= this.elementsArray.size() ? (Element)null : (Element)this.elementsArray.get(i));
    }

    public int size() {
        return this.elementsArray.size();
    }

    public Class<?> getType() {
        if (this.type.equals(Class.class)) {
            int i = 0;
            for (Element element : this.elementsArray) {
                Class<?> classx = element.getClass();
                if (i == 0) {
                    this.type = classx;
                } else if (!this.type.equals(classx)) {
                    throw new RuntimeException("CMLElements is not homogeneous: " + this.type + "/" + classx);
                }
                ++i;
            }
        }
        return this.type;
    }

    public List<E> getList() {
        return new ArrayList<E>(this.elementsArray);
    }

    class CMLElementsIterator<T extends Element>
    implements Iterator<T> {
        int index = 0;
        List<T> list;

        public CMLElementsIterator(List<T> list) {
            this.list = list;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public T next() {
            return (T)((Element)this.list.get(this.index++));
        }

        @Override
        public boolean hasNext() {
            return this.index < this.list.size();
        }
    }
}

