/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.tsp.fixme;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdplus.toolkit.base.tsp.fixme.AbstractIterator;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class Strings {
    @NonNull
    public static String nullToEmpty(@Nullable String o) {
        return o == null ? "" : o;
    }

    public static @Nullable String emptyToNull(@Nullable String o) {
        return o != null && o.isEmpty() ? null : o;
    }

    public static boolean isNullOrEmpty(@Nullable String o) {
        return o == null || o.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable String o) {
        return !Strings.isNullOrEmpty(o);
    }

    @NonNull
    public static Stream<String> splitToStream(@NonNull String separator, @NonNull CharSequence input) {
        if (separator == null) {
            throw new NullPointerException("separator is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return separator.length() == 1 ? Strings.splitToStream(separator.charAt(0), input) : StreamSupport.stream(Spliterators.spliteratorUnknownSize(Strings.splitToIterator(separator, input), 0), false);
    }

    @NonNull
    public static Stream<String> splitToStream(char separator, @NonNull CharSequence input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(Strings.splitToIterator(separator, input), 0), false);
    }

    @NonNull
    public static Iterator<String> splitToIterator(@NonNull String separator, @NonNull CharSequence input) {
        if (separator == null) {
            throw new NullPointerException("separator is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return Strings.asIterator(CharMatcher.of(separator), separator.length(), input);
    }

    @NonNull
    public static Iterator<String> splitToIterator(char separator, @NonNull CharSequence input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return Strings.asIterator(CharMatcher.of(separator), 1, input);
    }

    private static Iterator<String> asIterator(final CharMatcher matcher, final int inc, final CharSequence input) {
        return new AbstractIterator<String>(){
            private int start = -1;
            private int end = -1;

            @Override
            protected String get() {
                return this.start == this.end ? "" : input.subSequence(this.start, this.end).toString();
            }

            @Override
            protected boolean moveNext() {
                this.end += inc;
                this.start = this.end;
                while (this.end < input.length()) {
                    if (matcher.matches(input, this.end)) {
                        return true;
                    }
                    ++this.end;
                }
                return this.start <= input.length();
            }
        };
    }

    @Generated
    private Strings() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    @FunctionalInterface
    public static interface CharMatcher {
        public boolean matches(CharSequence var1, int var2);

        public static CharMatcher of(char value) {
            return (seq, index) -> seq.charAt(index) == value;
        }

        public static CharMatcher of(CharSequence value) {
            return (seq, index) -> {
                if (value.length() > seq.length() - index) {
                    return false;
                }
                for (int i = 0; i < value.length(); ++i) {
                    if (seq.charAt(index + i) == value.charAt(i)) continue;
                    return false;
                }
                return true;
            };
        }
    }
}

