/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup;

import java.util.HashMap;
import java.util.Map;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGDescription;
import org.vikamine.kernel.subgroup.target.SGTarget;

public class SGCache {
    private SGTarget target;
    private DataView population;
    private final Map<SGDescription, SG> selToSGMap;

    public SGCache(SGTarget target, DataView population) {
        this.target = target;
        this.population = population;
        this.selToSGMap = new HashMap<SGDescription, SG>();
    }

    public void clear() {
        this.selToSGMap.clear();
    }

    public DataView getPopulation() {
        return this.population;
    }

    public boolean containsSG(SGDescription descr) {
        return this.selToSGMap.containsKey(descr);
    }

    public SG getSG(SGDescription description, boolean createStatisticsonDemand) {
        if (this.population != null && this.target != null) {
            SG sg = this.selToSGMap.get(description);
            if (sg == null) {
                sg = new SG(this.population, this.target, description);
                if (createStatisticsonDemand) {
                    sg.createStatistics();
                }
                this.cache(description, sg);
            }
            return sg;
        }
        return null;
    }

    public void cache(SGDescription sgd, SG sg) {
        this.selToSGMap.put(sgd, sg);
    }

    public SGTarget getTarget() {
        return this.target;
    }

    public void setPopulation(DataView population) {
        this.population = population;
        this.clear();
    }

    public void setTarget(SGTarget target) {
        this.target = target;
        this.clear();
    }

    public int getSize() {
        return this.selToSGMap.size();
    }
}

