## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----eval = FALSE-------------------------------------------------------------
# library(sasquatch)

## ----eval = FALSE-------------------------------------------------------------
# sas_connect()
# #> ✔ SAS connection established.

## ----eval = FALSE-------------------------------------------------------------
# sas_connect(cfgname = "my_config", reconnect = TRUE)
# #> ✔ SAS connection terminated.
# #> ✔ SAS connection established.

## ----eval = FALSE-------------------------------------------------------------
# sas_disconnect()
# #> ✔ SAS connection terminated.

## ----eval = FALSE-------------------------------------------------------------
# sas_get_session()
# #> Access Method         = IOM
# #> SAS Config name       = my_config
# #> SAS Config file       = /home/user/.virtualenvs/r-saspy/lib/python3.12/site-packages/saspy/sascfg_personal.py
# #> WORK Path             = /saswork/SAS_work0D3600010B4E_odaws01-usw2-2.oda.sas.com/SAS_work920700010B4E_odaws01-usw2-2.oda.sas.com/
# #> SAS Version           = 9.04.01M7P08062020
# #> SASPy Version         = 5.101.1
# #> Teach me SAS          = False
# #> Batch                 = False
# #> Results               = Pandas
# #> SAS Session Encoding  = utf-8
# #> Python Encoding value = utf-8
# #> SAS process Pid value = 68430
# #> SASsession started    = Wed Dec 25 13:58:22 2024

## ----eval = FALSE-------------------------------------------------------------
# sas_run_string("PROC MEANS DATA = sashelp.cars;RUN;")

## ----echo = FALSE-------------------------------------------------------------
readRDS("files/proc_means_widget.rds")

## ----eval = FALSE-------------------------------------------------------------
# cat("PROC MEANS DATA = sashelp.cars;RUN;", file = "script.sas")
# sas_widget <- sas_run_file("script.sas")
# 
# # will save output.html and output.log files
# sas_run_file("script.sas", "output.html")

## ----eval = FALSE-------------------------------------------------------------
# df <- data.frame(
#   double = c(1, 2.5, NA),
#   integer = c(1:2, NA),
#   logical = c(T, F, NA),
#   character = c("a", "b", NA),
#   factor = factor(c("a", "b", NA)),
#   date = as.Date("2015-12-09") + c(1:2, NA),
#   datetime = as.POSIXct("2015-12-09 10:51:34.5678", tz = "UTC") + c(1:2, NA)
# )
# tibble::tibble(df)
# #> # A tibble: 3 × 7
# #>   double integer logical character factor date       datetime
# #>    <dbl>   <int> <lgl>   <chr>     <fct>  <date>     <dttm>
# #> 1    1         1 TRUE    a         a      2015-12-10 2015-12-09 10:51:35
# #> 2    2.5       2 FALSE   b         b      2015-12-11 2015-12-09 10:51:36
# #> 3   NA        NA NA      NA        NA     NA         NA
# 
# sas_from_r(df, "df", libref = "WORK")

## ----eval = FALSE-------------------------------------------------------------
# df <- sas_to_r("df", libref = "WORK")
# 
# tibble::tibble(df)
# #> # A tibble: 3 × 7
# #>   double integer logical character factor date                datetime
# #>    <dbl>   <dbl>   <dbl> <chr>     <chr>  <dttm>              <dttm>
# #> 1    1         1       1 a         a      2015-12-10 00:00:00 2015-12-09 10:51:35
# #> 2    2.5       2       0 b         b      2015-12-11 00:00:00 2015-12-09 10:51:36
# #> 3   NA        NA      NA NA        NA     NA                  NA

## ----eval = FALSE-------------------------------------------------------------
# cat("PROC MEANS DATA = sashelp.cars;RUN;", file = "script.sas")
# sas_file_upload(local_path = "script.sas", sas_path = "~/script.sas")

## ----eval = FALSE-------------------------------------------------------------
# sas_file_download(sas_path = "~/script.sas", local_path = "script.sas")

## ----eval = FALSE-------------------------------------------------------------
# sas_file_exists("~/script.sas")

## ----eval = FALSE-------------------------------------------------------------
# sas_file_copy("~/script.sas", "~/script_copy.sas")

## ----eval = FALSE-------------------------------------------------------------
# sas_file_remove("~/script_copy.sas")

## ----eval = FALSE-------------------------------------------------------------
# sas_list("~")
# #> [1] "directory1" "file1.csv" "file2.sas"

