/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Parameter;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class RateBitExchangeOperator
extends SimpleMCMCOperator {
    public static final String OPERATOR_NAME = "rateBitExchangeOperator";
    public static final String BITS = "bits";
    public static final String RATES = "rates";
    public static final String MAX_TRIES = "maxTries";
    private static final int MAX_TRIES_MAGIC_NUMBER = 1000;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule("bits", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("rates", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), AttributeRule.newIntegerRule("maxTries", true)};

        @Override
        public String getParserName() {
            return RateBitExchangeOperator.OPERATOR_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            Parameter parameter = (Parameter)xMLObject.getChild(RateBitExchangeOperator.RATES).getChild(Parameter.class);
            Parameter parameter2 = (Parameter)xMLObject.getChild(RateBitExchangeOperator.BITS).getChild(Parameter.class);
            int n = xMLObject.getAttribute(RateBitExchangeOperator.MAX_TRIES, 1000);
            return new RateBitExchangeOperator(parameter, parameter2, d, n);
        }

        @Override
        public String getParserDescription() {
            return "This element returns a bit-flip operator on a given parameter.";
        }

        @Override
        public Class getReturnType() {
            return MCMCOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };
    private Parameter bitParameter = null;
    private Parameter rateParameter = null;
    private final int maxTries;

    RateBitExchangeOperator(Parameter parameter, Parameter parameter2, double d, int n) {
        this.rateParameter = parameter;
        this.bitParameter = parameter2;
        this.setWeight(d);
        this.maxTries = n;
    }

    @Override
    public double doOperation() {
        int n = this.rateParameter.getDimension() / 2;
        int n2 = 0;
        int n3 = -1;
        while (this.bitParameter.getParameterValue(n3 = MathUtils.nextInt(n)) + this.bitParameter.getParameterValue(n3 + n) < 1.0 && ++n2 < this.maxTries) {
        }
        if (n2 >= this.maxTries) {
            return Double.NEGATIVE_INFINITY;
        }
        double d = this.bitParameter.getParameterValue(n3);
        double d2 = this.rateParameter.getParameterValue(n3);
        this.bitParameter.setParameterValue(n3, this.bitParameter.getParameterValue(n3 + n));
        this.rateParameter.setParameterValue(n3, this.rateParameter.getParameterValue(n3 + n));
        this.bitParameter.setParameterValue(n3 + n, d);
        this.rateParameter.setParameterValue(n3 + n, d2);
        return 0.0;
    }

    @Override
    public final String getOperatorName() {
        return "rateBitExchangeOperator(" + this.bitParameter.getParameterName() + "," + this.rateParameter.getParameterName() + ")";
    }

    public final String getPerformanceSuggestion() {
        return "No performance suggestion";
    }

    public String toString() {
        return this.getOperatorName();
    }
}

