/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.smooth;

import dr.evomodel.coalescent.smooth.SmoothSkygridLikelihood;
import dr.evomodel.tree.TreeModel;
import dr.evomodel.treedatalikelihood.discrete.NodeHeightProxyParameter;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.loggers.LogColumn;
import dr.inference.loggers.Loggable;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.xml.Reportable;

public class SmoothSkygridGradient
implements GradientWrtParameterProvider,
Reportable,
Loggable {
    private final SmoothSkygridLikelihood skygridLikelihood;
    private final WrtParameter wrtParameter;
    private final Parameter parameter;
    private final Double tolerance;

    public SmoothSkygridGradient(SmoothSkygridLikelihood smoothSkygridLikelihood, WrtParameter wrtParameter, Double d) {
        this.skygridLikelihood = smoothSkygridLikelihood;
        this.wrtParameter = wrtParameter;
        this.tolerance = d;
        this.parameter = wrtParameter.getParameter(smoothSkygridLikelihood);
    }

    @Override
    public Likelihood getLikelihood() {
        return this.skygridLikelihood;
    }

    @Override
    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public int getDimension() {
        return this.parameter.getDimension();
    }

    @Override
    public double[] getGradientLogDensity() {
        return this.wrtParameter.getGradientLogDensity(this.skygridLikelihood);
    }

    @Override
    public String getReport() {
        return GradientWrtParameterProvider.getReportAndCheckForError(this, 0.0, Double.POSITIVE_INFINITY, this.tolerance, 0.001);
    }

    @Override
    public LogColumn[] getColumns() {
        return Loggable.getColumnsFromReport(this, "SmoothSkygridGradient check");
    }

    public static enum WrtParameter {
        NODE_HEIGHT("nodeHeight"){

            @Override
            Parameter getParameter(SmoothSkygridLikelihood smoothSkygridLikelihood) {
                TreeModel treeModel = (TreeModel)smoothSkygridLikelihood.getTree(0);
                return new NodeHeightProxyParameter("allInternalNode", treeModel, true);
            }

            @Override
            double[] getGradientLogDensity(SmoothSkygridLikelihood smoothSkygridLikelihood) {
                return smoothSkygridLikelihood.getGradientWrtNodeHeight();
            }
        };

        private final String name;

        private WrtParameter(String string2) {
            this.name = string2;
        }

        abstract Parameter getParameter(SmoothSkygridLikelihood var1);

        abstract double[] getGradientLogDensity(SmoothSkygridLikelihood var1);

        public static WrtParameter factory(String string) {
            for (WrtParameter wrtParameter : WrtParameter.values()) {
                if (!string.equalsIgnoreCase(wrtParameter.name)) continue;
                return wrtParameter;
            }
            return null;
        }
    }
}

