## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")

## ----message=FALSE, echo=F, warning=F-----------------------------------------
# Load SemanticDistance
library(SemanticDistance)

## ----eval=T, message=F, warning=F---------------------------------------------
knitr::kable(head(Dialogue_Typical, 6), format = "pipe")

## ----message=FALSE------------------------------------------------------------
Dialogue_Cleaned <- clean_dialogue(dat=Dialogue_Typical, wordcol="text", who_talking="speaker", omit_stops=TRUE, lemmatize=TRUE)
knitr::kable(head(Dialogue_Cleaned, 12), format = "pipe")

## ----message=FALSE------------------------------------------------------------
DialogueDists <- dist_dialogue(dat=Dialogue_Cleaned, who_talking="speaker")
knitr::kable(head(DialogueDists, 12), format = "pipe", digits=2)

