### Using the Browse Button to Load and Extract .KMZ Files

Welcome to the help page for the browse button functionality! Here, we will guide you through the process of loading and extracting a .KMZ file and displaying the images embedded within it on a map.

#### What is a .KMZ File?

A .KMZ file is a compressed version of a .KML (Keyhole Markup Language) file, which is used to display geographic data in an Earth browser such as Google Earth. The .KMZ format allows for the inclusion of images, 3D models, and other multimedia content, making it a versatile choice for sharing and viewing complex geographic data.

#### Requirements for the .KMZ File

To ensure smooth operation, the .KMZ file you use should meet the following criteria: 1. **Embedded Equirectangular 360 JPEG Images**: The images within the .KMZ file should be in the equirectangular 360 format, which allows for a panoramic view. This format is essential for a complete and immersive viewing experience. 2. **Embedded Geolocation Data**: Each image should contain geolocation data embedded within it. This data is crucial for accurately placing the images on the map based on their real-world coordinates.

#### Steps to Use the Browse Button

1.  **Click the Browse Button**: Start by clicking the browse button on the interface. This action will open a file dialog window.
2.  **Select Your .KMZ File**: Navigate to the location of your .KMZ file on your computer, select it, and click 'Open'. Ensure that the file meets the requirements mentioned above.
3.  **Loading the File**: Once the file is selected, the application will begin to load and extract the contents of the .KMZ file. This process may take a few moments, depending on the size of the file and the number of images it contains.
4.  **Displaying the Images**: After extraction, the images embedded in the .KMZ file will be displayed on the map. The geolocation data within each image will ensure that they appear at their correct locations.

#### Troubleshooting

-   **File Not Loading**: If the file fails to load, double-check that it is a valid .KMZ file and that it contains the required equirectangular 360 JPEG images with embedded geolocation data.
-   **Images Not Displaying Correctly**: Ensure that the images are in the correct format and contain accurate geolocation data. If the images appear distorted or misplaced, the file might not meet the necessary specifications.

We hope this guide helps you effectively use the browse button to load and display your .KMZ files.
