/*
 * Decompiled with CFR 0.152.
 */
package ActiveSubnetworkSearchMisc;

import ActiveSubnetworkSearchAlgorithms.ActiveSubnetworkSearch;
import ActiveSubnetworkSearchMisc.ScoreCalculations;
import Network.Network;
import Network.Node;
import java.util.ArrayList;
import java.util.HashSet;

public class Subnetwork
implements Comparable<Object> {
    private Network network;
    private ArrayList<Node> nodeList;
    private ScoreCalculations scoreCalculations;
    private double score;
    private double zSum;
    private HashSet<Node> neighborSet;
    private ArrayList<Node> neighborList;

    public Subnetwork(ArrayList<Node> nodeList) {
        this.nodeList = nodeList;
        this.scoreCalculations = ActiveSubnetworkSearch.scoreCalculations;
        this.neighborSet = new HashSet();
        this.neighborList = new ArrayList();
        this.network = ActiveSubnetworkSearch.network;
        this.zSum = 0.0;
        for (Node node : nodeList) {
            this.zSum += this.scoreCalculations.getZScore(node).doubleValue();
        }
        this.score = this.scoreCalculations.calculateScoreOfSubnetwork(nodeList.size(), this.zSum, true);
    }

    public ArrayList<Node> getNodeList() {
        return this.nodeList;
    }

    public HashSet<Node> getNeighborSet() {
        if (this.neighborSet.isEmpty()) {
            this.extractNeighborSet();
        }
        return this.neighborSet;
    }

    public ArrayList<Node> getNeighborList() {
        if (this.neighborSet.isEmpty()) {
            this.extractNeighborSet();
        }
        return this.neighborList;
    }

    public int numberOfNodes() {
        return this.nodeList.size();
    }

    public double getScore() {
        return this.score;
    }

    @Override
    public int compareTo(Object o) {
        return (int)Math.signum(this.getScore() - ((Subnetwork)o).getScore());
    }

    public boolean contains(Node node) {
        return this.nodeList.contains(node);
    }

    public void addNode(Node node) {
        this.nodeList.add(node);
        this.zSum += this.scoreCalculations.getZScore(node).doubleValue();
        this.score = this.scoreCalculations.calculateScoreOfSubnetwork(this.nodeList.size(), this.zSum, true);
        this.neighborSet.clear();
    }

    public void removeNode(Node node) {
        if (this.nodeList.contains(node)) {
            this.nodeList.remove(node);
            this.zSum -= this.scoreCalculations.getZScore(node).doubleValue();
            this.score = this.scoreCalculations.calculateScoreOfSubnetwork(this.nodeList.size(), this.zSum, true);
            this.neighborSet.clear();
        }
    }

    private void extractNeighborSet() {
        this.neighborSet.clear();
        for (Node node : this.nodeList) {
            this.neighborSet.addAll(this.network.getNeighborSet(node));
        }
        this.neighborSet.removeAll(this.nodeList);
        this.neighborList.addAll(this.neighborSet);
    }
}

