/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.automata.structure.multicostregular;

import gnu.trove.set.hash.TIntHashSet;
import gnu.trove.stack.TIntStack;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Set;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.nary.automata.FA.ICostAutomaton;
import org.chocosolver.solver.constraints.nary.automata.structure.Node;
import org.chocosolver.solver.constraints.nary.automata.structure.multicostregular.FastPathFinder;
import org.chocosolver.solver.constraints.nary.automata.structure.regular.Arc;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.iterators.DisposableIntIterator;
import org.chocosolver.util.objects.StoredIndexedBipartiteSetWithOffset;
import org.jgrapht.graph.DirectedMultigraph;

public class StoredDirectedMultiGraph {
    private final int[] starts;
    private final int[] offsets;
    public int sourceIndex;
    public int tinIndex;
    public int nbR;
    private final StoredIndexedBipartiteSetWithOffset[] supports;
    public StoredIndexedBipartiteSetWithOffset[] layers;
    private FastPathFinder pf;
    public BitSet inStack;
    private final IntVar[] z;
    public Nodes GNodes;
    public Arcs GArcs;
    private final int[] minmax = new int[2];

    public void delayedBoundUpdate(TIntStack toRemove, IntVar[] z, int ... dim) {
        for (int i = 0; i < this.offsets.length; ++i) {
            DisposableIntIterator iter = this.layers[i].getIterator();
            while (iter.hasNext()) {
                int n = iter.next();
                DisposableIntIterator it = this.GNodes.outArcs[n].getIterator();
                while (it.hasNext()) {
                    int arc = it.next();
                    int orig = this.GArcs.origs[arc];
                    int dest = this.GArcs.dests[arc];
                    for (int k : dim) {
                        if (!(this.GNodes.spfsI[orig][k] + this.GArcs.originalCost[arc][k] + this.GNodes.spftI[dest][k] > (double)z[k].getUB()) && !(this.GNodes.lpfsI[orig][k] + this.GArcs.originalCost[arc][k] + this.GNodes.lpftI[dest][k] < (double)z[k].getLB()) || this.isInStack(arc)) continue;
                        this.setInStack(arc);
                        toRemove.push(arc);
                    }
                }
                it.dispose();
            }
            iter.dispose();
        }
    }

    public StoredDirectedMultiGraph(IEnvironment environment, DirectedMultigraph<Node, Arc> graph, int[][] layers, int[] starts, int[] offsets, int supportLength, ICostAutomaton pi, IntVar[] z) {
        this.nbR = pi.getNbResources();
        this.z = z;
        this.starts = starts;
        this.offsets = offsets;
        this.layers = new StoredIndexedBipartiteSetWithOffset[layers.length];
        for (int i = 0; i < layers.length; ++i) {
            this.layers[i] = new StoredIndexedBipartiteSetWithOffset(environment, layers[i]);
        }
        this.sourceIndex = layers[0][0];
        this.tinIndex = layers[layers.length - 1][0];
        this.GNodes = new Nodes();
        this.GArcs = new Arcs();
        TIntHashSet[] sups = new TIntHashSet[supportLength];
        this.supports = new StoredIndexedBipartiteSetWithOffset[supportLength];
        Set arcs = graph.edgeSet();
        this.inStack = new BitSet(arcs.size());
        this.GArcs.values = new int[arcs.size()];
        this.GArcs.dests = new int[arcs.size()];
        this.GArcs.origs = new int[arcs.size()];
        this.GArcs.originalCost = new double[arcs.size()][this.nbR];
        this.GArcs.temporaryCost = new double[arcs.size()];
        for (Arc a : arcs) {
            this.GArcs.values[a.id] = a.value;
            this.GArcs.dests[a.id] = a.dest.id;
            this.GArcs.origs[a.id] = a.orig.id;
            int state = a.orig.state;
            int layer = a.orig.layer;
            for (int r = 0; r < this.nbR; ++r) {
                this.GArcs.originalCost[a.id][r] = layer < layers.length - 2 ? pi.getCostByResourceAndState(layer, a.value, r, state) : 0.0;
            }
            if (a.orig.layer >= starts.length) continue;
            int idx = starts[a.orig.layer] + a.value - offsets[a.orig.layer];
            if (sups[idx] == null) {
                sups[idx] = new TIntHashSet();
            }
            sups[idx].add(a.id);
        }
        for (int i = 0; i < sups.length; ++i) {
            if (sups[i] == null) continue;
            this.supports[i] = new StoredIndexedBipartiteSetWithOffset(environment, sups[i].toArray());
        }
        Set nodes = graph.vertexSet();
        this.GNodes.outArcs = new StoredIndexedBipartiteSetWithOffset[nodes.size()];
        this.GNodes.inArcs = new StoredIndexedBipartiteSetWithOffset[nodes.size()];
        this.GNodes.layers = new int[nodes.size()];
        this.GNodes.states = new int[nodes.size()];
        this.GNodes.prevLP = new int[nodes.size()];
        Arrays.fill(this.GNodes.prevLP, Integer.MIN_VALUE);
        this.GNodes.nextLP = new int[nodes.size()];
        Arrays.fill(this.GNodes.nextLP, Integer.MIN_VALUE);
        this.GNodes.prevSP = new int[nodes.size()];
        Arrays.fill(this.GNodes.prevSP, Integer.MIN_VALUE);
        this.GNodes.nextSP = new int[nodes.size()];
        Arrays.fill(this.GNodes.nextSP, Integer.MIN_VALUE);
        this.GNodes.lpfs = new double[nodes.size()];
        this.GNodes.lpft = new double[nodes.size()];
        this.GNodes.spfs = new double[nodes.size()];
        this.GNodes.spft = new double[nodes.size()];
        this.GNodes.lpfsI = new double[nodes.size()][this.nbR];
        this.GNodes.lpftI = new double[nodes.size()][this.nbR];
        this.GNodes.spfsI = new double[nodes.size()][this.nbR];
        this.GNodes.spftI = new double[nodes.size()][this.nbR];
        this.GNodes.prevLPI = new int[nodes.size()][this.nbR];
        this.GNodes.nextLPI = new int[nodes.size()][this.nbR];
        this.GNodes.prevSPI = new int[nodes.size()][this.nbR];
        this.GNodes.nextSPI = new int[nodes.size()][this.nbR];
        for (int k = 0; k < this.nbR; ++k) {
            Arrays.fill(this.GNodes.prevLPI[k], Integer.MIN_VALUE);
            Arrays.fill(this.GNodes.nextLPI[k], Integer.MIN_VALUE);
            Arrays.fill(this.GNodes.prevSPI[k], Integer.MIN_VALUE);
            Arrays.fill(this.GNodes.nextSPI[k], Integer.MIN_VALUE);
        }
        for (Node n : nodes) {
            Set inarc;
            int i;
            this.GNodes.layers[n.id] = n.layer;
            this.GNodes.states[n.id] = n.state;
            Set outarc = graph.outgoingEdgesOf(n);
            if (!outarc.isEmpty()) {
                int[] out = new int[outarc.size()];
                i = 0;
                for (Arc a : outarc) {
                    out[i++] = a.id;
                }
                this.GNodes.outArcs[n.id] = new StoredIndexedBipartiteSetWithOffset(environment, out);
            }
            if ((inarc = graph.incomingEdgesOf(n)).isEmpty()) continue;
            int[] in = new int[inarc.size()];
            i = 0;
            for (Arc a : inarc) {
                in[i++] = a.id;
            }
            this.GNodes.inArcs[n.id] = new StoredIndexedBipartiteSetWithOffset(environment, in);
        }
    }

    public final void makePathFinder() {
        this.pf = new FastPathFinder(this);
    }

    public final StoredIndexedBipartiteSetWithOffset getUBport(int i, int j) {
        int idx = this.starts[i] + j - this.offsets[i];
        if (idx == -1) {
            System.err.println("stop");
        }
        return this.supports[idx];
    }

    public final FastPathFinder getPathFinder() {
        return this.pf;
    }

    public boolean removeArc(int arcId, TIntStack toRemove, TIntStack[] updateLeft, TIntStack[] updateRight, Propagator<IntVar> propagator) throws ContradictionException {
        boolean needUpdate;
        block10: {
            int k;
            int dest;
            block9: {
                int id;
                int i;
                int[] list;
                StoredIndexedBipartiteSetWithOffset in;
                this.inStack.clear(arcId);
                needUpdate = false;
                int orig = this.GArcs.origs[arcId];
                dest = this.GArcs.dests[arcId];
                int layer = this.GNodes.layers[orig];
                int value = this.GArcs.values[arcId];
                if (layer < this.starts.length) {
                    StoredIndexedBipartiteSetWithOffset support = this.getUBport(layer, value);
                    support.remove(arcId);
                    if (support.isEmpty()) {
                        IntVar var = propagator.getVar(layer);
                        var.removeValue(value, (ICause)propagator);
                    }
                }
                StoredIndexedBipartiteSetWithOffset out = this.GNodes.outArcs[orig];
                out.remove(arcId);
                if (out.isEmpty()) {
                    this.layers[layer].remove(orig);
                    if (layer > 0) {
                        in = this.GNodes.inArcs[orig];
                        list = in._getStructure();
                        int size = in.size();
                        for (i = 0; i < size; ++i) {
                            id = list[i];
                            if (this.isInStack(id)) continue;
                            this.setInStack(id);
                            toRemove.push(id);
                        }
                    }
                } else {
                    for (k = 0; k < this.nbR; ++k) {
                        if (this.GNodes.nextSPI[orig][k] != arcId && this.GNodes.nextLPI[orig][k] != arcId) continue;
                        updateRight[k].push(orig);
                        needUpdate = true;
                    }
                }
                in = this.GNodes.inArcs[dest];
                in.remove(arcId);
                if (!in.isEmpty()) break block9;
                this.layers[layer + 1].remove(dest);
                if (layer + 1 >= this.starts.length) break block10;
                out = this.GNodes.outArcs[dest];
                list = out._getStructure();
                int size = out.size();
                for (i = 0; i < size; ++i) {
                    id = list[i];
                    if (this.isInStack(id)) continue;
                    this.setInStack(id);
                    toRemove.push(id);
                }
                break block10;
            }
            for (k = 0; k < this.nbR; ++k) {
                if (this.GNodes.prevSPI[dest][k] != arcId && this.GNodes.prevLPI[dest][k] != arcId) continue;
                updateLeft[k].push(dest);
                needUpdate = true;
            }
        }
        return needUpdate;
    }

    public void updateRight(TIntStack updateRight, TIntStack toRemove, int dim, boolean[] modBound, Propagator<IntVar> propagator) throws ContradictionException {
        int nid = updateRight.pop();
        double tempPval = Double.POSITIVE_INFINITY;
        double tempPval2 = Double.NEGATIVE_INFINITY;
        int tempP = Integer.MIN_VALUE;
        int temp2 = Integer.MIN_VALUE;
        int[] list = this.GNodes.outArcs[nid]._getStructure();
        int size = this.GNodes.outArcs[nid].size();
        for (int i = 0; i < size; ++i) {
            double lpft;
            int arcId = list[i];
            int dest = this.GArcs.dests[arcId];
            double spft = this.GNodes.spftI[dest][dim] + this.GArcs.originalCost[arcId][dim];
            if (tempPval > spft) {
                tempPval = spft;
                tempP = arcId;
            }
            if (!(tempPval2 < (lpft = this.GNodes.lpftI[dest][dim] + this.GArcs.originalCost[arcId][dim]))) continue;
            tempPval2 = lpft;
            temp2 = arcId;
        }
        double old = this.GNodes.spftI[nid][dim];
        this.GNodes.spftI[nid][dim] = tempPval;
        this.GNodes.nextSPI[nid][dim] = tempP;
        double old2 = this.GNodes.lpftI[nid][dim];
        this.GNodes.lpftI[nid][dim] = tempPval2;
        this.GNodes.nextLPI[nid][dim] = temp2;
        if (nid == this.sourceIndex) {
            if (dim == 0) {
                modBound[0] = modBound[0] | this.z[0].updateLowerBound((int)Math.ceil(tempPval), (ICause)propagator);
                modBound[1] = modBound[1] | this.z[0].updateUpperBound((int)Math.floor(tempPval2), (ICause)propagator);
            } else {
                this.z[dim].updateLowerBound((int)Math.ceil(tempPval), (ICause)propagator);
                this.z[dim].updateUpperBound((int)Math.floor(tempPval2), (ICause)propagator);
            }
        }
        if (nid != this.sourceIndex && (old != tempPval || old2 != tempPval2)) {
            list = this.GNodes.inArcs[nid]._getStructure();
            size = this.GNodes.inArcs[nid].size();
            for (int i = 0; i < size; ++i) {
                int arcId = list[i];
                int orig = this.GArcs.origs[arcId];
                if (this.GNodes.nextSPI[orig][dim] == arcId && old != tempPval || old2 != tempPval2 && this.GNodes.nextLPI[orig][dim] == arcId) {
                    updateRight.push(orig);
                }
                double spfs = this.GNodes.spfsI[orig][dim];
                double lpfs = this.GNodes.lpfsI[orig][dim];
                double acost = this.GArcs.originalCost[arcId][dim];
                if (this.isInStack(arcId) || !(tempPval + spfs + acost > (double)this.z[dim].getUB()) && !(tempPval2 + lpfs + acost < (double)this.z[dim].getLB())) continue;
                this.setInStack(arcId);
                toRemove.push(arcId);
            }
        }
    }

    public void updateLeft(TIntStack updateLeft, TIntStack toRemove, int dim, boolean[] modBound, Propagator<IntVar> propagator) throws ContradictionException {
        int nid = updateLeft.pop();
        double tempPval = Double.POSITIVE_INFINITY;
        int tempP = Integer.MIN_VALUE;
        double tempPval2 = Double.NEGATIVE_INFINITY;
        int tempP2 = Integer.MIN_VALUE;
        int[] list = this.GNodes.inArcs[nid]._getStructure();
        int size = this.GNodes.inArcs[nid].size();
        for (int i = 0; i < size; ++i) {
            double lpfs;
            int arcId = list[i];
            int orig = this.GArcs.origs[arcId];
            double spfs = this.GNodes.spfsI[orig][dim] + this.GArcs.originalCost[arcId][dim];
            if (tempPval > spfs) {
                tempPval = spfs;
                tempP = arcId;
            }
            if (!(tempPval2 < (lpfs = this.GNodes.lpfsI[orig][dim] + this.GArcs.originalCost[arcId][dim]))) continue;
            tempPval2 = lpfs;
            tempP2 = arcId;
        }
        double old = this.GNodes.spfsI[nid][dim];
        this.GNodes.spfsI[nid][dim] = tempPval;
        this.GNodes.prevSPI[nid][dim] = tempP;
        double old2 = this.GNodes.lpfsI[nid][dim];
        this.GNodes.lpfsI[nid][dim] = tempPval2;
        this.GNodes.prevLPI[nid][dim] = tempP2;
        if (nid == this.tinIndex) {
            if (dim == 0) {
                modBound[0] = modBound[0] | this.z[0].updateLowerBound((int)Math.ceil(tempPval), (ICause)propagator);
                modBound[1] = modBound[1] | this.z[0].updateUpperBound((int)Math.floor(tempPval2), (ICause)propagator);
            } else {
                this.z[dim].updateLowerBound((int)Math.ceil(tempPval), (ICause)propagator);
                this.z[dim].updateUpperBound((int)Math.floor(tempPval2), (ICause)propagator);
            }
        }
        if (nid != this.tinIndex && (old != tempPval || old2 != tempPval2)) {
            list = this.GNodes.outArcs[nid]._getStructure();
            size = this.GNodes.outArcs[nid].size();
            for (int i = 0; i < size; ++i) {
                int arcId = list[i];
                int dest = this.GArcs.dests[arcId];
                if (old != tempPval && this.GNodes.prevSPI[dest][dim] == arcId || old2 != tempPval2 && this.GNodes.prevLPI[dest][dim] == arcId) {
                    updateLeft.push(dest);
                }
                double spft = this.GNodes.spftI[dest][dim];
                double acost = this.GArcs.originalCost[arcId][dim];
                double lpft = this.GNodes.lpftI[dest][dim];
                if (this.isInStack(arcId) || !(tempPval + spft + acost > (double)this.z[dim].getUB()) && !(tempPval2 + lpft + acost < (double)this.z[dim].getLB())) continue;
                this.setInStack(arcId);
                toRemove.push(arcId);
            }
        }
    }

    public final BitSet getInStack() {
        return this.inStack;
    }

    public final boolean isInStack(int idx) {
        return this.inStack.get(idx);
    }

    public final void setInStack(int idx) {
        this.inStack.set(idx);
    }

    public int getRegret(int layer, int value, int ... resources) {
        int result = Integer.MAX_VALUE;
        StoredIndexedBipartiteSetWithOffset arcs = this.getUBport(layer, value);
        DisposableIntIterator it = arcs.getIterator();
        while (it.hasNext()) {
            int arcId = it.next();
            int origId = this.GArcs.origs[arcId];
            int destId = this.GArcs.dests[arcId];
            double cost = 0.0;
            for (int r : resources) {
                cost += this.pf.spfs[origId][r] + this.GArcs.originalCost[arcId][r] + this.pf.spft[destId][r];
            }
            if (!(cost < (double)result)) continue;
            result = (int)cost;
        }
        it.dispose();
        for (int r : resources) {
            result = (int)((double)result - this.pf.spft[this.sourceIndex][r]);
        }
        return result;
    }

    public int getMinPathCostForAssignment(int layer, int value, int ... resources) {
        int result = Integer.MAX_VALUE;
        StoredIndexedBipartiteSetWithOffset arcs = this.getUBport(layer, value);
        DisposableIntIterator it = arcs.getIterator();
        int[] list = arcs._getStructure();
        int size = arcs.size();
        for (int i = 0; i < size; ++i) {
            int arcId = list[i];
            int origId = this.GArcs.origs[arcId];
            int destId = this.GArcs.dests[arcId];
            double cost = 0.0;
            for (int r : resources) {
                cost += this.pf.spfs[origId][r] + this.GArcs.originalCost[arcId][r] + this.pf.spft[destId][r];
            }
            if (!(cost < (double)result)) continue;
            result = (int)cost;
        }
        it.dispose();
        return result;
    }

    public int[] getMinMaxPathCostForAssignment(int layer, int value, int ... resources) {
        this.minmax[0] = Integer.MAX_VALUE;
        this.minmax[1] = Integer.MIN_VALUE;
        StoredIndexedBipartiteSetWithOffset arcs = this.getUBport(layer, value);
        DisposableIntIterator it = arcs.getIterator();
        while (it.hasNext()) {
            int arcId = it.next();
            int origId = this.GArcs.origs[arcId];
            int destId = this.GArcs.dests[arcId];
            double cost = 0.0;
            for (int r : resources) {
                cost += this.pf.spfs[origId][r] + this.GArcs.originalCost[arcId][r] + this.pf.spft[destId][r];
            }
            if (cost < (double)this.minmax[0]) {
                this.minmax[0] = (int)cost;
            }
            if (!(cost > (double)this.minmax[1])) continue;
            this.minmax[1] = (int)cost;
        }
        it.dispose();
        return this.minmax;
    }

    public double[] getInstantiatedLayerCosts(int layer) {
        StoredIndexedBipartiteSetWithOffset couche = this.layers[layer];
        DisposableIntIterator it = couche.getIterator();
        int node = it.next();
        it.dispose();
        it = this.GNodes.outArcs[node].getIterator();
        int arcId = it.next();
        it.dispose();
        return this.GArcs.originalCost[arcId];
    }

    public int getMinPathCost(int ... resources) {
        double result = 0.0;
        for (int r : resources) {
            result += this.pf.spft[this.sourceIndex][r];
        }
        return (int)result;
    }

    public class Nodes {
        public int[] states;
        public int[] layers;
        public StoredIndexedBipartiteSetWithOffset[] outArcs;
        public StoredIndexedBipartiteSetWithOffset[] inArcs;
        public int[] nextSP;
        public int[] prevSP;
        public int[] nextLP;
        public int[] prevLP;
        public double[] spfs;
        public double[] spft;
        public double[] lpfs;
        public double[] lpft;
        public int[][] nextSPI;
        public int[][] prevSPI;
        public int[][] nextLPI;
        public int[][] prevLPI;
        public double[][] spfsI;
        public double[][] spftI;
        public double[][] lpfsI;
        public double[][] lpftI;
    }

    public class Arcs {
        public int[] values;
        public int[] dests;
        public int[] origs;
        public double[][] originalCost;
        public double[] temporaryCost;
    }
}

