/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.tsp.grid;

import java.io.IOException;
import java.time.LocalDateTime;
import java.util.function.Function;
import jdplus.toolkit.base.tsp.grid.GridOutput;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

@FunctionalInterface
public interface InternalValueWriter<T> {
    public void write( @NonNull GridOutput.Stream var1, @Nullable T var2) throws IOException;

    @NonNull
    public static <X> InternalValueWriter<X> onStringFormatter(@NonNull Function<X, String> formatter) {
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        return FuncWriter.onStringFormatter(formatter);
    }

    @NonNull
    public static InternalValueWriter<LocalDateTime> onDateTime() {
        return FuncWriter.DATETIME;
    }

    @NonNull
    public static InternalValueWriter<Double> onDouble() {
        return FuncWriter.DOUBLE;
    }

    @NonNull
    public static InternalValueWriter<String> onString() {
        return FuncWriter.STRING;
    }

    @NonNull
    public static <T> InternalValueWriter<T> onNull() {
        return NullWriter.INSTANCE;
    }

    public static interface FuncWriter<T>
    extends InternalValueWriter<T>,
    Function<T, Object> {
        public static final FuncWriter<LocalDateTime> DATETIME = o -> o;
        public static final FuncWriter<Double> DOUBLE = o -> o;
        public static final FuncWriter<String> STRING = o -> o;

        @Override
        default public void write(GridOutput.Stream stream, T value) throws IOException {
            stream.writeCell(this.apply(value));
        }

        public static <T> FuncWriter<T> onStringFormatter(Function<T, String> parser) {
            return o -> o != null ? parser.apply(o) : null;
        }
    }

    public static enum NullWriter implements InternalValueWriter
    {
        INSTANCE;


        public void write(GridOutput.Stream stream, Object value) throws IOException {
            stream.writeCell(null);
        }
    }
}

