/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import jdplus.toolkit.base.api.time.ISO_8601;
import jdplus.toolkit.base.api.time.TemporalFormatter;
import jdplus.toolkit.base.api.time.TimeIntervalAccessor;
import jdplus.toolkit.base.api.time.TimeIntervalFormatter;
import jdplus.toolkit.base.api.timeseries.TimeSeriesInterval;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsException;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.util.HasShortStringRepresentation;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

@ISO_8601
public final class TsPeriod
implements TimeSeriesInterval<TsUnit>,
Comparable<TsPeriod>,
HasShortStringRepresentation {
    @NonNull
    private final LocalDateTime epoch;
    @NonNull
    private final TsUnit unit;
    private final long id;
    public static final LocalDateTime DEFAULT_EPOCH = LocalDate.ofEpochDay(0L).atStartOfDay();
    static final TimeIntervalFormatter ISO_8601 = TimeIntervalFormatter.StartDuration.of(TemporalFormatter.EXTENDED_CALENDAR_TIME, LocalDateTime::from, TsUnit::parse);

    @Override
    @NonNull
    public LocalDateTime start() {
        return TsPeriod.dateAt(this.epoch, this.unit, this.id);
    }

    @Override
    @NonNull
    public LocalDateTime end() {
        return TsPeriod.dateAt(this.epoch, this.unit, this.id + 1L);
    }

    @Override
    public boolean contains(@NonNull LocalDateTime date) {
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return TsPeriod.idAt(this.epoch, this.unit, date) == this.id;
    }

    @Override
    @NonNull
    public TsUnit getDuration() {
        return this.unit;
    }

    @Override
    public int compareTo(@NonNull TsPeriod period) {
        if (period == null) {
            throw new NullPointerException("period is marked non-null but is null");
        }
        this.checkCompatibility(period);
        return Long.compare(this.id, this.getRebasedId(period));
    }

    public int year() {
        return this.start().getYear();
    }

    public int annualPosition() {
        TsPeriod p = this.withUnit(TsUnit.P1Y);
        return TsDomain.splitOf(p, this.unit, true).indexOf(this);
    }

    public int annualFrequency() {
        return this.unit.getAnnualFrequency();
    }

    public boolean isAfter(TsPeriod period) {
        this.checkCompatibility(period);
        return this.id > this.getRebasedId(period);
    }

    public boolean isBefore(TsPeriod period) {
        this.checkCompatibility(period);
        return this.id < this.getRebasedId(period);
    }

    public TsPeriod next() {
        return this.plus(1L);
    }

    public TsPeriod previous() {
        return this.plus(-1L);
    }

    public TsPeriod plus(long count) {
        if (count == 0L) {
            return this;
        }
        return new TsPeriod(this.epoch, this.unit, this.id + count);
    }

    public TsPeriod withEpoch(LocalDateTime epoch) {
        if (epoch.equals(this.epoch)) {
            return this;
        }
        return TsPeriod.make(epoch.equals(DEFAULT_EPOCH) ? DEFAULT_EPOCH : epoch, this.unit, this.start());
    }

    public TsPeriod withUnit(TsUnit newUnit) {
        if (this.unit.equals(newUnit)) {
            return this;
        }
        return TsPeriod.make(this.epoch, newUnit, this.start());
    }

    public TsPeriod withDate(LocalDateTime date) {
        return TsPeriod.make(this.epoch, this.unit, date);
    }

    public TsPeriod withId(long id) {
        if (this.id == id) {
            return this;
        }
        return new TsPeriod(this.epoch, this.unit, id);
    }

    public int until(TsPeriod end) {
        this.checkCompatibility(end);
        return (int)(this.getRebasedId(end) - this.id);
    }

    public String toString() {
        return ISO_8601.format(this);
    }

    @Override
    @NonNull
    public String toShortString() {
        return ISO_8601.format(this, this.unit.getPrecision());
    }

    @NonNull
    public String getStartAsShortString() {
        return TemporalFormatter.EXTENDED_CALENDAR_TIME.format(this.start(), this.unit.getPrecision());
    }

    public long idAt(LocalDateTime date) {
        return TsPeriod.idAt(this.epoch, this.unit, date);
    }

    public LocalDateTime dateAt(long id) {
        return TsPeriod.dateAt(this.epoch, this.unit, id);
    }

    public boolean hasDefaultEpoch() {
        return this.epoch.equals(DEFAULT_EPOCH);
    }

    private boolean hasSameEpoch(@NonNull TsPeriod period) {
        if (period == null) {
            throw new NullPointerException("period is marked non-null but is null");
        }
        return this.epoch.equals(period.epoch);
    }

    long getRebasedId(TsPeriod period) {
        return this.hasSameEpoch(period) ? period.id : this.idAt(period.start());
    }

    void checkCompatibility(TsPeriod period) throws IllegalArgumentException {
        if (this.unit != period.unit && !this.unit.equals(period.unit)) {
            throw new TsException("Incompatible frequencies");
        }
    }

    @NonNull
    public static TsPeriod of(@NonNull TsUnit unit, @NonNull LocalDateTime date) {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return TsPeriod.make(DEFAULT_EPOCH, unit, date);
    }

    @NonNull
    public static TsPeriod of(@NonNull TsUnit unit, @NonNull LocalDate date) {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        if (date == null) {
            throw new NullPointerException("date is marked non-null but is null");
        }
        return TsPeriod.make(DEFAULT_EPOCH, unit, date);
    }

    @NonNull
    public static TsPeriod of(@NonNull TsUnit unit, long id) {
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        return TsPeriod.make(DEFAULT_EPOCH, unit, id);
    }

    @NonNull
    public static TsPeriod yearly(int year) {
        return TsPeriod.make(DEFAULT_EPOCH, TsUnit.P1Y, LocalDate.of(year, 1, 1));
    }

    @NonNull
    public static TsPeriod quarterly(int year, int quarter) {
        return TsPeriod.make(DEFAULT_EPOCH, TsUnit.P3M, LocalDate.of(year, (quarter - 1) * 3 + 1, 1));
    }

    @NonNull
    public static TsPeriod monthly(int year, int month) {
        return TsPeriod.make(DEFAULT_EPOCH, TsUnit.P1M, LocalDate.of(year, month, 1));
    }

    @NonNull
    public static TsPeriod daily(int year, int month, int dayOfMonth) {
        return TsPeriod.make(DEFAULT_EPOCH, TsUnit.P1D, LocalDate.of(year, month, dayOfMonth));
    }

    @NonNull
    public static TsPeriod weekly(int year, int month, int dayOfMonth) {
        LocalDate start = LocalDate.of(year, month, dayOfMonth);
        int dw_start = start.getDayOfWeek().getValue();
        int dw_epoch = DEFAULT_EPOCH.getDayOfWeek().getValue();
        return TsPeriod.make(DEFAULT_EPOCH.plusDays(dw_start - dw_epoch), TsUnit.P7D, start);
    }

    @NonNull
    public static TsPeriod hourly(int year, int month, int dayOfMonth, int hour) {
        return TsPeriod.make(DEFAULT_EPOCH, TsUnit.PT1H, LocalDateTime.of(year, month, dayOfMonth, hour, 0));
    }

    @NonNull
    public static TsPeriod minutely(int year, int month, int dayOfMonth, int hour, int minute) {
        return TsPeriod.make(DEFAULT_EPOCH, TsUnit.PT1M, LocalDateTime.of(year, month, dayOfMonth, hour, minute));
    }

    @NonNull
    public static TsPeriod parse(@NonNull CharSequence text) throws DateTimeParseException {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        return ISO_8601.parse(text, TsPeriod::from);
    }

    @NonNull
    public static TsPeriod from(@NonNull TimeIntervalAccessor timeInterval) {
        if (timeInterval == null) {
            throw new NullPointerException("timeInterval is marked non-null but is null");
        }
        return TsPeriod.of((TsUnit)timeInterval.getDuration(), LocalDateTime.from(timeInterval.start()));
    }

    private static TsPeriod make(LocalDateTime epoch, TsUnit unit, LocalDate date) {
        return new TsPeriod(epoch, unit, TsPeriod.idAt(epoch, unit, date.atStartOfDay()));
    }

    static TsPeriod make(LocalDateTime epoch, TsUnit unit, LocalDateTime date) {
        return new TsPeriod(epoch, unit, TsPeriod.idAt(epoch, unit, date));
    }

    private static TsPeriod make(LocalDateTime epoch, TsUnit unit, long id) {
        return new TsPeriod(epoch, unit, id);
    }

    public static long idAt(LocalDateTime epoch, TsUnit unit, LocalDateTime date) {
        if (date.compareTo(epoch) >= 0) {
            return unit.getChronoUnit().between(epoch, date) / unit.getAmount();
        }
        long result = unit.getChronoUnit().between(epoch, date) / unit.getAmount();
        return TsPeriod.dateAt(epoch, unit, result).compareTo(date) <= 0 ? result : result - 1L;
    }

    public static LocalDateTime dateAt(LocalDateTime epoch, TsUnit unit, long id) {
        return epoch.plus(unit.getAmount() * id, unit.getChronoUnit());
    }

    @Deprecated
    public String display() {
        if (this.unit.getChronoUnit().getDuration().compareTo(ChronoUnit.DAYS.getDuration()) < 0) {
            return this.start().toString();
        }
        int freq = this.annualFrequency();
        if (freq < 1) {
            return this.start().toLocalDate().toString();
        }
        if (freq == 1) {
            return Integer.toString(this.year());
        }
        int pos = this.annualPosition() + 1;
        if (freq < 12) {
            pos *= 12 / freq;
        }
        int year = this.year();
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(pos).append('-').append(year);
        return buffer.toString();
    }

    @Generated
    TsPeriod(@NonNull LocalDateTime epoch, @NonNull TsUnit unit, long id) {
        if (epoch == null) {
            throw new NullPointerException("epoch is marked non-null but is null");
        }
        if (unit == null) {
            throw new NullPointerException("unit is marked non-null but is null");
        }
        this.epoch = epoch;
        this.unit = unit;
        this.id = id;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull Builder builder() {
        return new Builder();
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().epoch(this.epoch).unit(this.unit).id(this.id);
    }

    @NonNull
    @Generated
    public LocalDateTime getEpoch() {
        return this.epoch;
    }

    @NonNull
    @Generated
    public TsUnit getUnit() {
        return this.unit;
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsPeriod)) {
            return false;
        }
        TsPeriod other = (TsPeriod)o;
        if (this.getId() != other.getId()) {
            return false;
        }
        LocalDateTime this$epoch = this.getEpoch();
        LocalDateTime other$epoch = other.getEpoch();
        if (this$epoch == null ? other$epoch != null : !((Object)this$epoch).equals(other$epoch)) {
            return false;
        }
        TsUnit this$unit = this.getUnit();
        TsUnit other$unit = other.getUnit();
        return !(this$unit == null ? other$unit != null : !((Object)this$unit).equals(other$unit));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        LocalDateTime $epoch = this.getEpoch();
        result = result * 59 + ($epoch == null ? 43 : ((Object)$epoch).hashCode());
        TsUnit $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : ((Object)$unit).hashCode());
        return result;
    }

    @ISO_8601
    public static final class Builder
    implements TimeSeriesInterval<TsUnit>,
    HasShortStringRepresentation {
        private LocalDateTime epoch = DEFAULT_EPOCH;
        private TsUnit unit = TsUnit.P1M;
        private long id;

        private void refreshId(LocalDateTime oldref, TsUnit oldUnit, LocalDateTime newref, TsUnit newUnit) {
            this.id = TsPeriod.idAt(newref, newUnit, TsPeriod.dateAt(oldref, oldUnit, this.id));
        }

        public Builder epoch(LocalDateTime epoch) {
            this.epoch = epoch;
            this.refreshId(this.epoch, this.unit, this.epoch, this.unit);
            return this;
        }

        public Builder unit(TsUnit unit) {
            this.unit = unit;
            this.refreshId(this.epoch, this.unit, this.epoch, this.unit);
            return this;
        }

        public Builder date(LocalDate date) {
            return this.date(date.atStartOfDay());
        }

        public Builder date(LocalDateTime date) {
            this.id = TsPeriod.idAt(this.epoch, this.unit, date);
            return this;
        }

        public Builder plus(int count) {
            this.id += (long)count;
            return this;
        }

        @Override
        @NonNull
        public LocalDateTime start() {
            return TsPeriod.dateAt(this.epoch, this.unit, this.id);
        }

        @Override
        @NonNull
        public LocalDateTime end() {
            return TsPeriod.dateAt(this.epoch, this.unit, this.id + 1L);
        }

        @Override
        @NonNull
        public TsUnit getDuration() {
            return this.unit;
        }

        @Override
        public boolean contains(@NonNull LocalDateTime date) {
            if (date == null) {
                throw new NullPointerException("date is marked non-null but is null");
            }
            return TsPeriod.idAt(this.epoch, this.unit, date) == this.id;
        }

        public String toString() {
            return ISO_8601.format(this);
        }

        @Override
        @NonNull
        public String toShortString() {
            return ISO_8601.format(this, this.unit.getPrecision());
        }

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder id(long id) {
            this.id = id;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull TsPeriod build() {
            return new TsPeriod(this.epoch, this.unit, this.id);
        }
    }
}

