/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.arima;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.estimation.ArmaFilter;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.LogSign;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.LowerTriangularMatrix;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.RationalFunction;

public class LjungBoxFilter
implements ArmaFilter {
    private int m_n;
    private int m_p;
    private int m_q;
    private Polynomial m_ar;
    private Polynomial m_ma;
    private double[] m_u;
    private FastMatrix m_G;
    private FastMatrix m_X;
    private FastMatrix m_V1;
    private FastMatrix m_L;
    private double m_s;
    private double m_t;

    private void ar(double[] a) {
        if (this.m_p > 0) {
            int j;
            double s;
            int i = a.length - 1;
            while (i >= this.m_p) {
                s = 0.0;
                for (j = 1; j <= this.m_p; ++j) {
                    s += this.m_ar.get(j) * a[i - j];
                }
                int n = i--;
                a[n] = a[n] + s;
            }
            i = this.m_p - 1;
            while (i > 0) {
                s = 0.0;
                for (j = 1; j <= i; ++j) {
                    s += this.m_ar.get(j) * a[i - j];
                }
                int n = i--;
                a[n] = a[n] + s;
            }
        }
    }

    private double[] calca0(DoubleSeq w) {
        double[] a0 = new double[w.length()];
        w.copyTo(a0, 0);
        this.ar(a0);
        this.rma(a0);
        return a0;
    }

    private double[] calcg(double[] a0) {
        double[] g = (double[])a0.clone();
        if (this.m_q > 0) {
            int i = this.m_n - 2;
            while (i >= 0) {
                double s = 0.0;
                int j = 1;
                for (int k = i + 1; j <= this.m_q && k < this.m_n; ++j, ++k) {
                    s += this.m_ma.get(j) * g[k];
                }
                int n = i--;
                g[n] = g[n] - s;
            }
        }
        return g;
    }

    private void calcg(int m) {
        RationalFunction rf = RationalFunction.of(Polynomial.ONE, this.m_ma);
        double[] pi = rf.coefficients(this.m_n);
        FastMatrix gg = FastMatrix.square(m);
        for (int i = 0; i < m; ++i) {
            double s = 0.0;
            for (int j = i; j < this.m_n; ++j) {
                s += pi[j] * pi[j - i];
            }
            gg.set(i, 0, s);
        }
        for (int c = 1; c < m; ++c) {
            DataBlock col = gg.column(c);
            DataBlock prevcol = gg.column(c - 1);
            for (int r = c; r < m; ++r) {
                col.set(r, prevcol.get(r - 1) - pi[this.m_n - r] * pi[this.m_n - c]);
            }
        }
        SymmetricMatrix.fromLower(gg);
        this.m_G = gg;
    }

    private double[] calch(double[] g) {
        int j;
        int i;
        double[] h = new double[this.m_p + this.m_q];
        for (i = 0; i < this.m_p; ++i) {
            for (j = 0; j <= i; ++j) {
                int n = i;
                h[n] = h[n] - this.m_ar.get(this.m_p - i + j) * g[j];
            }
        }
        for (i = 0; i < this.m_q; ++i) {
            for (j = 0; j <= i; ++j) {
                int n = i + this.m_p;
                h[n] = h[n] + this.m_ma.get(this.m_q - i + j) * g[j];
            }
        }
        return h;
    }

    private void calcv(double[] v) {
        int j;
        int i;
        for (i = 0; i < this.m_p; ++i) {
            for (j = i; j < this.m_p; ++j) {
                int n = i;
                v[n] = v[n] - this.m_ar.get(this.m_p + i - j) * this.m_u[j];
            }
        }
        for (i = 0; i < this.m_q; ++i) {
            for (j = i; j < this.m_q; ++j) {
                int n = i;
                v[n] = v[n] + this.m_ma.get(this.m_q + i - j) * this.m_u[this.m_p + j];
            }
        }
        this.rma(v);
    }

    @Override
    public void apply(DoubleSeq w, DataBlock wl) {
        if (this.m_G == null) {
            int n = wl.length();
            for (int i = 0; i < n; ++i) {
                wl.set(i, w.get(i));
            }
        } else {
            double[] a0 = this.calca0(w);
            double[] g = this.calcg(a0);
            this.m_u = this.calch(g);
            DataBlock U = DataBlock.of(this.m_u);
            LowerTriangularMatrix.solveLx(this.m_X, U);
            LowerTriangularMatrix.solvexL(this.m_X, U);
            double[] v = new double[w.length()];
            this.calcv(v);
            for (int i = 0; i < a0.length; ++i) {
                int n = i;
                a0[n] = a0[n] - v[i];
            }
            wl.drop(this.m_u.length, 0).copyFrom(a0, 0);
            DataBlock wl0 = wl.range(0, this.m_u.length);
            wl0.copyFrom(this.m_u, 0);
            LowerTriangularMatrix.solveLx(this.m_L, wl0);
        }
    }

    @Override
    public double getLogDeterminant() {
        return this.m_s + this.m_t;
    }

    @Override
    public int prepare(IArimaModel arima, int n) {
        this.clear();
        this.m_ar = arima.getAr().asPolynomial();
        this.m_ma = arima.getMa().asPolynomial();
        this.m_n = n;
        this.m_p = this.m_ar.degree();
        this.m_q = this.m_ma.degree();
        int m = Math.max(this.m_p, this.m_q);
        if (m > 0) {
            int i;
            FastMatrix W;
            this.m_L = FastMatrix.square(this.m_p + this.m_q);
            this.m_L.diagonal().set(1.0);
            this.m_V1 = FastMatrix.make(m, this.m_p + this.m_q);
            if (this.m_p > 0) {
                double[] cov = arima.getAutoCovarianceFunction().values(this.m_p);
                W = this.m_L.extract(0, this.m_p, 0, this.m_p);
                W.diagonal().set(cov[0]);
                for (int i2 = 1; i2 < this.m_p; ++i2) {
                    W.subDiagonal(i2).set(cov[i2]);
                }
                FastMatrix P = this.m_V1.extract(0, this.m_p, 0, this.m_p);
                P.diagonal().set(-this.m_ar.get(this.m_p));
                for (i = 1; i < this.m_p; ++i) {
                    P.subDiagonal(i).set(-this.m_ar.get(this.m_p - i));
                }
            }
            if (this.m_q > 0) {
                FastMatrix Q = this.m_V1.extract(0, this.m_q, this.m_p, this.m_q);
                Q.diagonal().set(this.m_ma.get(this.m_q));
                for (int i3 = 1; i3 < this.m_q; ++i3) {
                    Q.subDiagonal(i3).set(this.m_ma.get(this.m_q - i3));
                }
            }
            if (this.m_q > 0 && this.m_p > 0) {
                double[] psi = RationalFunction.of(this.m_ma, this.m_ar).coefficients(this.m_q);
                W = this.m_L.extract(0, this.m_p, this.m_p, this.m_q);
                int imin = this.m_q - this.m_p;
                for (i = 0; i < this.m_q; ++i) {
                    W.subDiagonal(imin - i).set(psi[i]);
                }
            }
            SymmetricMatrix.fromUpper(this.m_L);
            this.calcg(m);
            this.m_X = SymmetricMatrix.XtSX(this.m_G, this.m_V1);
            SymmetricMatrix.lcholesky(this.m_L);
            this.m_s = 2.0 * LogSign.of((DoubleSeq)this.m_L.diagonal()).getValue();
            FastMatrix IL = LowerTriangularMatrix.inverse(this.m_L);
            this.m_X.add(SymmetricMatrix.LtL(IL));
            SymmetricMatrix.lcholesky(this.m_X);
            this.m_t = 2.0 * LogSign.of((DoubleSeq)this.m_X.diagonal()).getValue();
        }
        return n + this.m_p + this.m_q;
    }

    void rma(double[] a) {
        if (this.m_q > 0) {
            int j;
            double s;
            int i = 1;
            while (i < this.m_q) {
                s = 0.0;
                for (j = 1; j <= i; ++j) {
                    s += this.m_ma.get(j) * a[i - j];
                }
                int n = i++;
                a[n] = a[n] - s;
            }
            i = this.m_q;
            while (i < a.length) {
                s = 0.0;
                for (j = 1; j <= this.m_q; ++j) {
                    s += this.m_ma.get(j) * a[i - j];
                }
                int n = i++;
                a[n] = a[n] - s;
            }
        }
    }

    private void clear() {
        this.m_G = null;
        this.m_X = null;
        this.m_V1 = null;
        this.m_L = null;
        this.m_s = 0.0;
        this.m_t = 0.0;
    }
}

