/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.timeseries.simplets.analysis;

import jdplus.toolkit.base.core.timeseries.simplets.analysis.DiagnosticTsFunction;
import jdplus.toolkit.base.core.timeseries.simplets.analysis.TsDataFunction;

public enum DiagnosticInfo {
    AbsoluteDifference,
    RelativeDifference,
    PeriodToPeriodGrowthDifference,
    PeriodToPeriodDifference,
    AnnualGrowthDifference,
    AnnualDifference;


    public DiagnosticTsFunction asFunction() {
        switch (this.ordinal()) {
            case 0: {
                return (ref, s, pos) -> ref.getValue(pos) - s.getValue(pos);
            }
            case 1: {
                return (ref, s, pos) -> {
                    double T2 = ref.getValue(pos);
                    return 100.0 * (T2 - s.getValue(pos)) / T2;
                };
            }
            case 2: {
                return (ref, s, pos) -> 100.0 * (ref.getValue(pos) / ref.getValue(pos - 1) - s.getValue(pos) / s.getValue(pos - 1));
            }
            case 3: {
                return (ref, s, pos) -> ref.getValue(pos) - ref.getValue(pos - 1) - (s.getValue(pos) - s.getValue(pos - 1));
            }
            case 4: {
                return (ref, s, pos) -> {
                    int lag = ref.getAnnualFrequency();
                    return 100.0 * (ref.getValue(pos) / ref.getValue(pos - lag) - s.getValue(pos) / s.getValue(pos - lag));
                };
            }
            case 5: {
                return (ref, s, pos) -> {
                    int lag = ref.getAnnualFrequency();
                    return ref.getValue(pos) - ref.getValue(pos - lag) - (s.getValue(pos) - s.getValue(pos - lag));
                };
            }
        }
        return (ref, s, pos) -> Double.NaN;
    }

    public TsDataFunction asTsDataFunction() {
        return switch (this.ordinal()) {
            case 0, 1 -> (s, pos) -> s.getValue(pos);
            case 2 -> (s, pos) -> pos > 0 ? 100.0 * (s.getValue(pos) / s.getValue(pos - 1) - 1.0) : Double.NaN;
            case 3 -> (s, pos) -> pos > 0 ? s.getValue(pos) - s.getValue(pos - 1) : Double.NaN;
            case 4 -> (s, pos) -> pos >= s.getAnnualFrequency() ? 100.0 * (s.getValue(pos) / s.getValue(pos - s.getAnnualFrequency()) - 1.0) : Double.NaN;
            case 5 -> (s, pos) -> pos >= s.getAnnualFrequency() ? s.getValue(pos) - s.getValue(pos - s.getAnnualFrequency()) : Double.NaN;
            default -> (s, pos) -> Double.NaN;
        };
    }

    public DiagnosticInfo adaptForNegativeValues() {
        return switch (this.ordinal()) {
            case 1 -> AbsoluteDifference;
            case 2 -> PeriodToPeriodDifference;
            case 4 -> AnnualDifference;
            default -> this;
        };
    }

    public boolean isRelative() {
        return this == RelativeDifference || this == PeriodToPeriodGrowthDifference || this == AnnualGrowthDifference;
    }

    public String toString() {
        return switch (this.ordinal()) {
            case 0 -> "Absolute differences";
            case 1 -> "Relative differences (%)";
            case 2 -> "Period to period growth differences (%)";
            case 3 -> "Period to period differences";
            case 4 -> "Annual growth differences (%)";
            case 5 -> "Annual differences";
            default -> null;
        };
    }
}

