/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ucarima;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.arima.AutoCovarianceFunction;
import jdplus.toolkit.base.core.arima.CrossCovarianceFunction;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.arima.ILinearProcess;
import jdplus.toolkit.base.core.arima.LinearProcess;
import jdplus.toolkit.base.core.arima.StationaryTransformation;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.FiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalFilter;
import jdplus.toolkit.base.core.math.linearfilters.RationalForeFilter;
import jdplus.toolkit.base.core.ucarima.UcarimaModel;
import jdplus.toolkit.base.core.ucarima.WienerKolmogorovEstimator;
import jdplus.toolkit.base.core.ucarima.WienerKolmogorovEstimators;

public class WienerKolmogorovPreliminaryEstimatorProperties {
    private WienerKolmogorovEstimators m_wk;
    private int m_cmp;
    private int m_lag;
    private boolean m_signal = true;
    private RationalFilter m_wcmp;
    private RationalFilter m_wrev;
    private LinearProcess m_stcmp;
    private LinearProcess m_strev;
    private AutoCovarianceFunction m_acgfcmp;
    private AutoCovarianceFunction m_acgfrev;
    private CrossCovarianceFunction m_ccgf;
    private BackFilter m_ur;

    public WienerKolmogorovPreliminaryEstimatorProperties() {
    }

    public WienerKolmogorovPreliminaryEstimatorProperties(WienerKolmogorovEstimators wk) {
        this.m_wk = wk;
    }

    public WienerKolmogorovEstimators getWienerKolmogorovEstimators() {
        return this.m_wk;
    }

    public void setWienerKolmogorovEstimators(WienerKolmogorovEstimators wk) {
        this.m_wk = wk;
        this.clear();
    }

    public UcarimaModel getModel() {
        return this.m_wk.getUcarimaModel();
    }

    public int getSelectedComponent() {
        return this.m_cmp;
    }

    public boolean isSignalSelected() {
        return this.m_signal;
    }

    public int getLag() {
        return this.m_lag;
    }

    public void setLag(int lag) {
        if (this.m_lag != lag) {
            this.m_lag = lag;
            this.pclear();
        }
    }

    public boolean isValid() {
        return this.init();
    }

    public void select(int cmp, boolean signal) {
        if (cmp != this.m_cmp || signal != this.m_signal) {
            this.m_cmp = cmp;
            this.m_signal = signal;
            this.clear();
        }
    }

    public double getWeight(int idx) {
        if (!this.init()) {
            return 0.0;
        }
        if (this.m_signal) {
            return this.m_wcmp.weight(idx) - this.m_wrev.weight(idx - this.m_lag - 1);
        }
        return this.m_wcmp.weight(idx) + this.m_wrev.weight(idx - this.m_lag - 1);
    }

    public double getStationaryAutoCovariance(int order) {
        if (!this.init()) {
            return 0.0;
        }
        int lp1 = this.m_lag + 1;
        double ac = this.m_acgfcmp.get(order) + this.m_acgfrev.get(order);
        ac = this.m_signal ? (ac -= this.m_ccgf.get(order - lp1) + this.m_ccgf.get(-order - lp1)) : (ac += this.m_ccgf.get(order - lp1) + this.m_ccgf.get(-order - lp1));
        return ac;
    }

    public Complex getFrequencyResponse(double frequency) {
        if (!this.init()) {
            return Complex.cart((double)0.0, (double)0.0);
        }
        double lw = frequency * (double)(1 + this.m_lag);
        Complex cfr = Complex.cart((double)Math.cos(lw), (double)Math.sin(lw));
        if (!this.m_signal) {
            cfr = cfr.negate();
        }
        return this.m_wcmp.frequencyResponse(frequency).minus(cfr.times(this.m_wrev.frequencyResponse(frequency)));
    }

    public void prepare(int from, int to) {
        if (this.init()) {
            this.m_wcmp.prepare(from, to);
            this.m_wrev.prepare(from - this.m_lag - 1, to - this.m_lag - 1);
        }
    }

    public BackFilter getDifferencingFilter() {
        if (!this.init()) {
            return null;
        }
        return this.m_ur;
    }

    public CrossCovarianceFunction getCcgf() {
        if (!this.init()) {
            return null;
        }
        return this.m_ccgf;
    }

    public AutoCovarianceFunction getStationaryAcgf() {
        if (!this.init()) {
            return null;
        }
        return this.m_acgfcmp;
    }

    public AutoCovarianceFunction getRevisionAcgf() {
        if (!this.init()) {
            return null;
        }
        return this.m_acgfrev;
    }

    private void clear() {
        this.m_wcmp = null;
        this.m_stcmp = null;
        this.m_acgfcmp = null;
        this.m_ur = null;
        this.pclear();
    }

    private void pclear() {
        this.m_wrev = null;
        this.m_strev = null;
        this.m_acgfrev = null;
        this.m_ccgf = null;
    }

    private boolean init() {
        if (this.m_wk == null) {
            return false;
        }
        if (this.m_ccgf != null) {
            return true;
        }
        try {
            IArimaModel model = this.m_wk.getUcarimaModel().getModel();
            WienerKolmogorovEstimator fest = this.m_wk.finalEstimator(this.m_cmp, this.m_signal);
            if (this.m_wcmp == null) {
                this.m_wcmp = fest.getWienerKolmogorovFilter();
                StationaryTransformation<ILinearProcess> st = this.m_wk.finalStationaryEstimator(this.m_cmp, this.m_signal);
                this.m_stcmp = (LinearProcess)st.getStationaryModel();
                this.m_ur = st.getUnitRoots();
                this.m_acgfcmp = this.m_stcmp.getAutoCovarianceFunction();
            }
            if (this.m_wrev == null) {
                LinearProcess errmodel = this.m_wk.revisionModel(this.m_cmp, this.m_lag);
                RationalForeFilter rferr = errmodel.getFilter().getRationalForeFilter();
                this.m_wrev = RationalFilter.of(FiniteFilter.multiply((IFiniteFilter)rferr.getNumerator(), model.getAr()), model.getMa(), rferr.getDenominator());
                RationalFilter ferr = RationalFilter.of(FiniteFilter.multiply((IFiniteFilter)this.m_ur, rferr.getNumerator()), BackFilter.ONE, rferr.getDenominator());
                this.m_strev = new LinearProcess(ferr, errmodel.getInnovationVariance());
                this.m_acgfrev = this.m_strev.getAutoCovarianceFunction();
                this.m_ccgf = new CrossCovarianceFunction(this.m_strev, this.m_stcmp);
            }
            return true;
        }
        catch (RuntimeException err) {
            return false;
        }
    }
}

