/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.util;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.SimpleTree;
import dr.evolution.util.Taxon;
import dr.math.MathUtils;
import java.util.Formatter;
import java.util.Iterator;
import java.util.Locale;
import jebl.util.FixedBitSet;

public class AlloppMisc {
    public static String FixedBitSetasText(FixedBitSet fixedBitSet) {
        if (fixedBitSet == null) {
            return "{?}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        for (int i = 0; i < fixedBitSet.cardinality() + FixedBitSet.complement(fixedBitSet).cardinality(); ++i) {
            String string;
            String string2 = string = i == 0 ? "" : ",";
            if (fixedBitSet.contains(i)) {
                stringBuilder.append(string + i);
                continue;
            }
            stringBuilder.append(string + " ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static String nonnegIn8Chars(double d) {
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder, Locale.US);
        if (d < 0.0) {
            formatter.format("%8s", "NA");
        } else if (d == 0.0) {
            formatter.format("%8s", "zero");
        } else if (d < 0.001) {
            formatter.format("%8.2e", d);
        } else if (d < 9.999) {
            formatter.format("%8.5f", d);
        } else if (d < 99.99) {
            formatter.format("%8.4f", d);
        } else if (d < 999.9) {
            formatter.format("%8.3f", d);
        } else if (d < 9999.0) {
            formatter.format("%8.2f", d);
        } else {
            formatter.format("%8.0f", d);
        }
        return stringBuilder.toString();
    }

    public static String nonnegIntIn2Chars(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        Formatter formatter = new Formatter(stringBuilder, Locale.US);
        if (n < 0) {
            formatter.format("%2s", "NA");
        } else {
            formatter.format("%2d", n);
        }
        return stringBuilder.toString();
    }

    public static String SimpleNodeAsText(SimpleTree simpleTree, NodeRef nodeRef) {
        String string = "" + nodeRef.getNumber() + " ";
        while (string.length() < 3) {
            string = string + " ";
        }
        int n = simpleTree.getChildCount(nodeRef);
        if (n > 0) {
            assert (n == 2);
            string = string + simpleTree.getChild(nodeRef, 0).getNumber();
            while (string.length() < 6) {
                string = string + " ";
            }
            string = string + simpleTree.getChild(nodeRef, 1).getNumber();
        }
        while (string.length() < 9) {
            string = string + " ";
        }
        Taxon taxon = simpleTree.getNodeTaxon(nodeRef);
        String string2 = "*";
        if (taxon != null && ((string2 = taxon.getId()) == null || string2.length() == 0)) {
            string2 = "*";
        }
        string = string + string2;
        while (string.length() < 20) {
            string = string + " ";
        }
        simpleTree.getNodeHeight(nodeRef);
        string = string + " height=";
        string = string + simpleTree.getNodeHeight(nodeRef);
        Iterator iterator = simpleTree.getNodeAttributeNames(nodeRef);
        if (iterator != null) {
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                string = string + " ";
                string = string + string3;
                string = string + "=";
                string = string + simpleTree.getNodeAttribute(nodeRef, string3);
            }
        }
        return string;
    }

    public static double uniformInRange(double d, double d2, double d3, double d4) {
        assert (d4 > 0.0);
        assert (d4 < 0.5);
        assert (d2 < d3);
        double d5 = MathUtils.uniform(-1.0, 1.0) * (d3 - d2) * d4;
        double d6 = d + d5;
        if (d6 < d2) {
            d6 = 2.0 * d2 - d6;
        }
        if (d6 > d3) {
            d6 = 2.0 * d3 - d6;
        }
        assert (d6 > d2);
        assert (d6 < d3);
        return d6;
    }
}

