/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.operators;

import dr.evolution.alignment.PatternList;
import dr.evolution.datatype.DataType;
import dr.evolution.tree.NodeRef;
import dr.evolution.util.Taxon;
import dr.evomodel.operators.AbstractTreeOperator;
import dr.evomodel.tree.TreeLogger;
import dr.evomodel.tree.TreeModel;
import dr.math.MathUtils;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public class ImportanceNarrowExchange
extends AbstractTreeOperator
implements TreeLogger.LogUpon {
    private TreeModel tree = null;
    private final double epsilon;
    private int[] nodeCounts;
    private boolean justAccepted;
    private final double[] weights;
    private double totalWeight;
    private final int DEBUG = 0;
    private final long lFreq = 1000L;
    private long lastLog = -1001L;

    public ImportanceNarrowExchange(TreeModel treeModel, PatternList patternList, double d, double d2) throws Exception {
        this.tree = treeModel;
        this.setWeight(d2);
        this.justAccepted = false;
        this.epsilon = d;
        this.weights = new double[treeModel.getNodeCount()];
        this.setTaxaWeights(patternList);
    }

    private void setTaxaWeights(PatternList patternList) throws Exception {
        int n;
        Object object;
        DataType dataType = patternList.getDataType();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int[] nArray = new int[patternList.getPatternLength()];
        for (int i = 0; i < patternList.getPatternCount(); ++i) {
            int[] nArray2 = patternList.getPattern(i);
            hashMap.clear();
            for (int n2 : nArray2) {
                if (dataType.isGapState(n2) || dataType.isAmbiguousState(n2) || dataType.isUnknownState(n2)) continue;
                if (!hashMap.containsKey(n2)) {
                    hashMap.put(n2, 0);
                }
                hashMap.put(n2, (Integer)hashMap.get(n2) + 1);
            }
            if (hashMap.size() <= 1) continue;
            object = null;
            for (Map.Entry entry : hashMap.entrySet()) {
                if (object != null && (Integer)entry.getValue() <= (Integer)object.getValue()) continue;
                object = entry;
            }
            assert (object != null);
            for (int j = 0; j < nArray2.length; ++j) {
                int n3 = nArray2[j];
                if (dataType.isGapState(n3) || dataType.isAmbiguousState(n3) || dataType.isUnknownState(n3) || n3 == (Integer)object.getKey()) continue;
                int n4 = j;
                nArray[n4] = (int)((double)nArray[n4] + patternList.getPatternWeight(i));
            }
        }
        this.nodeCounts = new int[this.tree.getNodeCount()];
        HashMap<Taxon, Integer> hashMap2 = new HashMap<Taxon, Integer>();
        for (n = 0; n < nArray.length; ++n) {
            hashMap2.put(patternList.getTaxon(n), nArray[n]);
        }
        for (n = 0; n < this.tree.getExternalNodeCount(); ++n) {
            object = this.tree.getExternalNode(n);
            Taxon taxon = this.tree.getNodeTaxon((NodeRef)object);
            if (!hashMap2.containsKey(taxon)) {
                throw new Exception("" + taxon + " in tree " + this.tree.getId() + " not in patterns" + patternList.getId() + ".");
            }
            this.nodeCounts[object.getNumber()] = (Integer)hashMap2.get(taxon);
        }
    }

    private int traverseTree(NodeRef nodeRef) {
        int n = nodeRef.getNumber();
        if (!this.tree.isExternal(nodeRef)) {
            int n2 = 0;
            for (int i = 0; i < this.tree.getChildCount(nodeRef); ++i) {
                n2 += this.traverseTree(this.tree.getChild(nodeRef, i));
            }
            this.nodeCounts[n] = n2;
        }
        return this.nodeCounts[n];
    }

    private double nodeWeight(NodeRef nodeRef) {
        NodeRef nodeRef2 = this.tree.getChild(nodeRef, 0);
        NodeRef nodeRef3 = this.tree.getChild(nodeRef, 1);
        if (this.tree.isExternal(nodeRef2) && this.tree.isExternal(nodeRef3)) {
            return 0.0;
        }
        boolean bl = this.tree.getNodeHeight(nodeRef2) < this.tree.getNodeHeight(nodeRef3);
        int n = this.nodeCounts[(bl ? nodeRef2 : nodeRef3).getNumber()];
        int n2 = this.nodeCounts[this.tree.getChild(bl ? nodeRef3 : nodeRef2, 0).getNumber()];
        int n3 = this.nodeCounts[this.tree.getChild(bl ? nodeRef3 : nodeRef2, 1).getNumber()];
        double d = (this.epsilon + (double)n) * (this.epsilon + (double)n2) + (this.epsilon + (double)n) * (this.epsilon + (double)n3) + (this.epsilon + (double)n2) * (this.epsilon + (double)n3) - 3.0 * this.epsilon * this.epsilon;
        return d;
    }

    private int getNode() {
        this.traverseTree(this.tree.getRoot());
        this.totalWeight = 0.0;
        for (int i = 0; i < this.tree.getInternalNodeCount(); ++i) {
            double d;
            NodeRef nodeRef = this.tree.getInternalNode(i);
            this.weights[nodeRef.getNumber()] = d = this.nodeWeight(nodeRef);
            this.totalWeight += d;
        }
        double d = MathUtils.nextDouble() * this.totalWeight;
        for (int i = 0; i < this.tree.getInternalNodeCount(); ++i) {
            NodeRef nodeRef = this.tree.getInternalNode(i);
            int n = nodeRef.getNumber();
            if (!((d -= this.weights[n]) < 0.0)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public double doOperation() {
        int n;
        int n2;
        int n3 = this.getNode();
        if (n3 < 0) {
            throw new RuntimeException("no node found");
        }
        NodeRef nodeRef = this.tree.getInternalNode(n3);
        assert (this.tree.getChildCount(nodeRef) == 2);
        NodeRef nodeRef2 = this.tree.getChild(nodeRef, 0);
        NodeRef nodeRef3 = this.tree.getChild(nodeRef, 1);
        boolean bl = this.tree.getNodeHeight(nodeRef2) < this.tree.getNodeHeight(nodeRef3);
        NodeRef nodeRef4 = bl ? nodeRef2 : nodeRef3;
        NodeRef nodeRef5 = bl ? nodeRef3 : nodeRef2;
        NodeRef nodeRef6 = this.tree.getChild(nodeRef5, MathUtils.nextInt(2));
        this.exchangeNodes(this.tree, nodeRef4, nodeRef6, nodeRef, nodeRef5);
        int n4 = n2 = nodeRef5.getNumber();
        this.nodeCounts[n4] = this.nodeCounts[n4] + (-this.nodeCounts[nodeRef6.getNumber()] + this.nodeCounts[nodeRef4.getNumber()]);
        double d = this.weights[n2];
        double d2 = this.nodeWeight(nodeRef5);
        double d3 = this.totalWeight + (d2 - d);
        this.weights[n2] = d2;
        NodeRef nodeRef7 = this.tree.getParent(nodeRef);
        if (nodeRef7 != null) {
            double d4;
            int n5 = nodeRef7.getNumber();
            double d5 = this.weights[n5];
            this.weights[n5] = d4 = this.nodeWeight(nodeRef7);
            d3 += d4 - d5;
        }
        double d6 = this.totalWeight;
        double[] dArray = new double[this.weights.length];
        System.arraycopy(this.weights, 0, dArray, 0, dArray.length);
        int[] nArray = new int[this.nodeCounts.length];
        System.arraycopy(this.nodeCounts, 0, nArray, 0, nArray.length);
        this.getNode();
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] != this.nodeCounts[n]) assert (false);
        }
        for (n = 0; n < dArray.length; ++n) {
            if (Math.abs(this.weights[n] / dArray[n] - 1.0) > 1.0E-12) assert (false);
        }
        assert (Math.abs(d3 / this.totalWeight - 1.0) < 1.0E-10);
        return Math.log(d6 / d3);
    }

    @Override
    public void reject() {
        super.reject();
        this.justAccepted = false;
    }

    @Override
    public void accept(double d) {
        super.accept(d);
        this.justAccepted = true;
    }

    @Override
    public boolean logNow(long l) {
        boolean bl = this.justAccepted;
        if (this.lastLog + 1000L >= l) {
            bl = false;
        } else if (bl) {
            this.lastLog = l;
        }
        this.justAccepted = false;
        return bl;
    }

    @Override
    public String getOperatorName() {
        return "Importance Narrow Exchange(" + this.tree.getId() + ")";
    }

    public double getMinimumAcceptanceLevel() {
        return 0.025;
    }

    public double getMinimumGoodAcceptanceLevel() {
        return 0.05;
    }

    public String getPerformanceSuggestion() {
        return "";
    }
}

