/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg;

import dr.evomodel.arg.ARGModel;
import dr.inference.model.Statistic;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class RecombinationPartitionStatistic
extends Statistic.Abstract {
    public static final String RECOMBINATION_PARTITION_STATISTIC = "partitionStatistic";
    private int dimension;
    private ARGModel arg;
    private String[] taxaNames;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return RecombinationPartitionStatistic.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return null;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = xMLObject.getId();
            ARGModel aRGModel = (ARGModel)xMLObject.getChild(ARGModel.class);
            return new RecombinationPartitionStatistic(string, aRGModel);
        }

        @Override
        public String getParserName() {
            return RecombinationPartitionStatistic.RECOMBINATION_PARTITION_STATISTIC;
        }
    };

    public RecombinationPartitionStatistic(String string, ARGModel aRGModel) {
        this.setId(string);
        this.arg = aRGModel;
        this.dimension = aRGModel.getExternalNodeCount();
        this.taxaNames = new String[this.dimension];
        for (int i = 0; i < this.taxaNames.length; ++i) {
            this.taxaNames[i] = "" + ((ARGModel.Node)aRGModel.getExternalNode((int)i)).taxon;
        }
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public String getDimensionName(int n) {
        return "Taxa" + this.taxaNames[n];
    }

    @Override
    public double getStatisticValue(int n) {
        ARGModel.Node node = (ARGModel.Node)this.arg.getExternalNode(n);
        assert (node.taxon.toString().equals(this.taxaNames[n]));
        boolean bl = node.hasReassortmentAncestor();
        if (bl) {
            return 1.0;
        }
        return 0.0;
    }
}

