## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

## ----setup, echo = FALSE------------------------------------------------------
library(GimmeMyPlot)
library(RColorBrewer)

## ----violin, fig.width = 5, fig.height = 5------------------------------------
# Default plot
x <- runif(10)
plot_violin(x)

# Multiple variables
df <- lapply(seq(2), function(x) runif(10))
df <- as.data.frame(df)
df[, 3] <- runif(10, 1, 2)
colnames(df) <- paste0("X", seq(3))
plot_violin(
    df,
    title = "Some random variables",
    colour = brewer.pal(9, "Set1")[seq(3)]
)

# Advanced parameters
plot_violin(
    df,
    title = "Some random variables",
    color_title = brewer.pal(9, "Set1")[5],
    ylab = "Y-values",
    colour = brewer.pal(9, "Set1")[seq(3)],
    method = "kruskal",
    method_adjust = "none",
    cex = 1.2,
    pch_size = 3,
    width_text = 5,
    pch_colour = "gray30",
    pch_alpha = 0.5,
    width_title = 30,
    lwd = 1.25,
    digits = 2
)

## ----end, echo = FALSE--------------------------------------------------------
sessionInfo()

