/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble;

import cern.colt.function.tdouble.Double9Function;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.function.tdouble.DoubleFunction;
import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix1DProcedure;
import cern.colt.matrix.tdouble.algo.DoubleFormatter;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.DoubleSorting;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DoubleMatrix2D
extends AbstractMatrix2D {
    private static final long serialVersionUID = 1L;

    protected DoubleMatrix2D() {
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        double d = 0.0;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = doubleFunction.apply(DoubleMatrix2D.this.getQuick(n3, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = n; j < DoubleMatrix2D.this.columns; ++j) {
                                d = doubleDoubleFunction.apply(d, doubleFunction.apply(DoubleMatrix2D.this.getQuick(i, j)));
                            }
                            n = 0;
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            d = doubleFunction.apply(this.getQuick(0, 0));
            int n5 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n5; j < this.columns; ++j) {
                    d = doubleDoubleFunction.apply(d, doubleFunction.apply(this.getQuick(i, j)));
                }
                n5 = 0;
            }
        }
        return d;
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction, final DoubleProcedure doubleProcedure) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        double d = 0.0;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = DoubleMatrix2D.this.getQuick(n3, 0);
                        double d2 = 0.0;
                        if (doubleProcedure.apply(d)) {
                            d2 = doubleDoubleFunction.apply(d2, doubleFunction.apply(d));
                        }
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = n; j < DoubleMatrix2D.this.columns; ++j) {
                                d = DoubleMatrix2D.this.getQuick(i, j);
                                if (!doubleProcedure.apply(d)) continue;
                                d2 = doubleDoubleFunction.apply(d2, doubleFunction.apply(d));
                            }
                            n = 0;
                        }
                        return d2;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            double d2 = this.getQuick(0, 0);
            if (doubleProcedure.apply(d2)) {
                d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
            }
            int n5 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n5; j < this.columns; ++j) {
                    d2 = this.getQuick(i, j);
                    if (!doubleProcedure.apply(d2)) continue;
                    d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
                }
                n5 = 0;
            }
        }
        return d;
    }

    public double aggregate(final DoubleDoubleFunction doubleDoubleFunction, final DoubleFunction doubleFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        if (this.size() == 0L) {
            return Double.NaN;
        }
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        double d = 0.0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, n);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = doubleFunction.apply(DoubleMatrix2D.this.getQuick(nArray[n4], nArray2[n4]));
                        for (int i = n4 + 1; i < n5; ++i) {
                            double d2 = DoubleMatrix2D.this.getQuick(nArray[i], nArray2[i]);
                            d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            d = doubleFunction.apply(this.getQuick(nArray[0], nArray2[0]));
            for (int i = 1; i < n; ++i) {
                double d2 = this.getQuick(nArray[i], nArray2[i]);
                d = doubleDoubleFunction.apply(d, doubleFunction.apply(d2));
            }
        }
        return d;
    }

    public double aggregate(final DoubleMatrix2D doubleMatrix2D, final DoubleDoubleFunction doubleDoubleFunction, final DoubleDoubleFunction doubleDoubleFunction2) {
        this.checkShape(doubleMatrix2D);
        if (this.size() == 0L) {
            return Double.NaN;
        }
        double d = 0.0;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        double d = doubleDoubleFunction2.apply(DoubleMatrix2D.this.getQuick(n3, 0), doubleMatrix2D.getQuick(n3, 0));
                        int n = 1;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = n; j < DoubleMatrix2D.this.columns; ++j) {
                                d = doubleDoubleFunction.apply(d, doubleDoubleFunction2.apply(DoubleMatrix2D.this.getQuick(i, j), doubleMatrix2D.getQuick(i, j)));
                            }
                            n = 0;
                        }
                        return d;
                    }
                });
            }
            d = ConcurrencyUtils.waitForCompletion(futureArray, doubleDoubleFunction);
        } else {
            d = doubleDoubleFunction2.apply(this.getQuick(0, 0), doubleMatrix2D.getQuick(0, 0));
            int n5 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n5; j < this.columns; ++j) {
                    d = doubleDoubleFunction.apply(d, doubleDoubleFunction2.apply(this.getQuick(i, j), doubleMatrix2D.getQuick(i, j)));
                }
                n5 = 0;
            }
        }
        return d;
    }

    public DoubleMatrix2D assign(final DoubleFunction doubleFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix2D.this.columns; ++j) {
                                DoubleMatrix2D.this.setQuick(i, j, doubleFunction.apply(DoubleMatrix2D.this.getQuick(i, j)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, doubleFunction.apply(this.getQuick(i, j)));
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleProcedure doubleProcedure, final DoubleFunction doubleFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix2D.this.columns; ++j) {
                                double d = DoubleMatrix2D.this.getQuick(i, j);
                                if (!doubleProcedure.apply(d)) continue;
                                DoubleMatrix2D.this.setQuick(i, j, doubleFunction.apply(d));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    double d = this.getQuick(i, j);
                    if (!doubleProcedure.apply(d)) continue;
                    this.setQuick(i, j, doubleFunction.apply(d));
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleProcedure doubleProcedure, final double d) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix2D.this.columns; ++j) {
                                double d2 = DoubleMatrix2D.this.getQuick(i, j);
                                if (!doubleProcedure.apply(d2)) continue;
                                DoubleMatrix2D.this.setQuick(i, j, d);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    double d2 = this.getQuick(i, j);
                    if (!doubleProcedure.apply(d2)) continue;
                    this.setQuick(i, j, d);
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final double d) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix2D.this.columns; ++j) {
                                DoubleMatrix2D.this.setQuick(i, j, d);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, d);
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final double[] dArray) {
        if (dArray.length != this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + dArray.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 * DoubleMatrix2D.this.columns;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix2D.this.columns; ++j) {
                                DoubleMatrix2D.this.setQuick(i, j, dArray[n++]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = 0;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, dArray[n5++]);
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final double[][] dArray) {
        if (dArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + dArray.length + "rows()=" + this.rows());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double[] dArray2 = dArray[i];
                            if (dArray2.length != DoubleMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray2.length + "columns()=" + DoubleMatrix2D.this.columns());
                            }
                            for (int j = 0; j < DoubleMatrix2D.this.columns; ++j) {
                                DoubleMatrix2D.this.setQuick(i, j, dArray2[j]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                double[] dArray2 = dArray[i];
                if (dArray2.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: columns=" + dArray2.length + "columns()=" + this.columns());
                }
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, dArray2[j]);
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D == this) {
            return this;
        }
        this.checkShape(doubleMatrix2D);
        final DoubleMatrix2D doubleMatrix2D2 = this.haveSharedCells(doubleMatrix2D) ? doubleMatrix2D.copy() : doubleMatrix2D;
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix2D.this.columns; ++j) {
                                DoubleMatrix2D.this.setQuick(i, j, doubleMatrix2D2.getQuick(i, j));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, doubleMatrix2D2.getQuick(i, j));
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleMatrix2D doubleMatrix2D, final DoubleDoubleFunction doubleDoubleFunction) {
        this.checkShape(doubleMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix2D.this.columns; ++j) {
                                DoubleMatrix2D.this.setQuick(i, j, doubleDoubleFunction.apply(DoubleMatrix2D.this.getQuick(i, j), doubleMatrix2D.getQuick(i, j)));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, doubleDoubleFunction.apply(this.getQuick(i, j), doubleMatrix2D.getQuick(i, j)));
                }
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final DoubleMatrix2D doubleMatrix2D, final DoubleDoubleFunction doubleDoubleFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        this.checkShape(doubleMatrix2D);
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            int n3 = n / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = i * n3;
                final int n5 = i == n2 - 1 ? n : n4 + n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n4; i < n5; ++i) {
                            DoubleMatrix2D.this.setQuick(nArray[i], nArray2[i], doubleDoubleFunction.apply(DoubleMatrix2D.this.getQuick(nArray[i], nArray2[i]), doubleMatrix2D.getQuick(nArray[i], nArray2[i])));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n; ++i) {
                this.setQuick(nArray[i], nArray2[i], doubleDoubleFunction.apply(this.getQuick(nArray[i], nArray2[i]), doubleMatrix2D.getQuick(nArray[i], nArray2[i])));
            }
        }
        return this;
    }

    public DoubleMatrix2D assign(final float[] fArray) {
        if (fArray.length != this.rows * this.columns) {
            throw new IllegalArgumentException("Must have same length: length=" + fArray.length + "rows()*columns()=" + this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 * DoubleMatrix2D.this.columns;
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix2D.this.columns; ++j) {
                                DoubleMatrix2D.this.setQuick(i, j, fArray[n++]);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n5 = 0;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    this.setQuick(i, j, fArray[n5++]);
                }
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.rows * this.columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            n2 = Math.min(n2, this.rows);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n4 = this.rows / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = n3 * n4;
                final int n6 = n3 == n2 - 1 ? this.rows : n5 + n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        for (int i = n5; i < n6; ++i) {
                            for (int j = 0; j < DoubleMatrix2D.this.columns; ++j) {
                                if (DoubleMatrix2D.this.getQuick(i, j) == 0.0) continue;
                                ++n;
                            }
                        }
                        return n;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    integerArray[n3] = (Integer)futureArray[n3].get();
                }
                n = integerArray[0];
                for (n3 = 1; n3 < n2; ++n3) {
                    n += integerArray[n3].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    if (this.getQuick(i, j) == 0.0) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public DoubleMatrix2D copy() {
        return this.like().assign(this);
    }

    public abstract Object elements();

    public boolean equals(double d) {
        return DoubleProperty.DEFAULT.equals(this, d);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DoubleMatrix2D)) {
            return false;
        }
        return DoubleProperty.DEFAULT.equals(this, (DoubleMatrix2D)object);
    }

    public DoubleMatrix2D forEachNonZero(final IntIntDoubleFunction intIntDoubleFunction) {
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            for (int j = 0; j < DoubleMatrix2D.this.columns; ++j) {
                                double d;
                                double d2 = DoubleMatrix2D.this.getQuick(i, j);
                                if (d2 == 0.0 || (d = intIntDoubleFunction.apply(i, j, d2)) == d2) continue;
                                DoubleMatrix2D.this.setQuick(i, j, d);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    double d;
                    double d2 = this.getQuick(i, j);
                    if (d2 == 0.0 || (d = intIntDoubleFunction.apply(i, j, d2)) == d2) continue;
                    this.setQuick(i, j, d);
                }
            }
        }
        return this;
    }

    public double get(int n, int n2) {
        if (n2 < 0 || n2 >= this.columns || n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + n + ", column:" + n2);
        }
        return this.getQuick(n, n2);
    }

    public double[] getMaxLocation() {
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n3 = Math.min(n3, this.rows);
            Future[] futureArray = new Future[n3];
            double[][] dArray = new double[n3][2];
            int n5 = this.rows / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? this.rows : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n = n6;
                        int n2 = 0;
                        double d = DoubleMatrix2D.this.getQuick(n, 0);
                        int n3 = 1;
                        for (int i = n6; i < n7; ++i) {
                            for (int j = n3; j < DoubleMatrix2D.this.columns; ++j) {
                                double d2 = DoubleMatrix2D.this.getQuick(i, j);
                                if (!(d < d2)) continue;
                                d = d2;
                                n = i;
                                n2 = j;
                            }
                            n3 = 0;
                        }
                        return new double[]{d, n, n2};
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    dArray[n4] = (double[])futureArray[n4].get();
                }
                d = dArray[0][0];
                n = (int)dArray[0][1];
                n2 = (int)dArray[0][2];
                for (n4 = 1; n4 < n3; ++n4) {
                    if (!(d < dArray[n4][0])) continue;
                    d = dArray[n4][0];
                    n = (int)dArray[n4][1];
                    n2 = (int)dArray[n4][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            d = this.getQuick(0, 0);
            int n8 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n8; j < this.columns; ++j) {
                    double d2 = this.getQuick(i, j);
                    if (!(d < d2)) continue;
                    d = d2;
                    n = i;
                    n2 = j;
                }
                n8 = 0;
            }
        }
        return new double[]{d, n, n2};
    }

    public double[] getMinLocation() {
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n3 = Math.min(n3, this.rows);
            Future[] futureArray = new Future[n3];
            double[][] dArray = new double[n3][2];
            int n5 = this.rows / n3;
            for (n4 = 0; n4 < n3; ++n4) {
                final int n6 = n4 * n5;
                final int n7 = n4 == n3 - 1 ? this.rows : n6 + n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        int n = n6;
                        int n2 = 0;
                        double d = DoubleMatrix2D.this.getQuick(n, 0);
                        int n3 = 1;
                        for (int i = n6; i < n7; ++i) {
                            for (int j = n3; j < DoubleMatrix2D.this.columns; ++j) {
                                double d2 = DoubleMatrix2D.this.getQuick(i, j);
                                if (!(d > d2)) continue;
                                d = d2;
                                n = i;
                                n2 = j;
                            }
                            n3 = 0;
                        }
                        return new double[]{d, n, n2};
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n3; ++n4) {
                    dArray[n4] = (double[])futureArray[n4].get();
                }
                d = dArray[0][0];
                n = (int)dArray[0][1];
                n2 = (int)dArray[0][2];
                for (n4 = 1; n4 < n3; ++n4) {
                    if (!(d > dArray[n4][0])) continue;
                    d = dArray[n4][0];
                    n = (int)dArray[n4][1];
                    n2 = (int)dArray[n4][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            d = this.getQuick(0, 0);
            int n8 = 1;
            for (int i = 0; i < this.rows; ++i) {
                for (int j = n8; j < this.columns; ++j) {
                    double d2 = this.getQuick(i, j);
                    if (!(d > d2)) continue;
                    d = d2;
                    n = i;
                    n2 = j;
                }
                n8 = 0;
            }
        }
        return new double[]{d, n, n2};
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, DoubleArrayList doubleArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        doubleArrayList.clear();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                double d = this.getQuick(i, j);
                if (!(d < 0.0)) continue;
                intArrayList.add(i);
                intArrayList2.add(j);
                doubleArrayList.add(d);
            }
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, DoubleArrayList doubleArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        doubleArrayList.clear();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                double d = this.getQuick(i, j);
                if (d == 0.0) continue;
                intArrayList.add(i);
                intArrayList2.add(j);
                doubleArrayList.add(d);
            }
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, DoubleArrayList doubleArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        doubleArrayList.clear();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                double d = this.getQuick(i, j);
                if (!(d > 0.0)) continue;
                intArrayList.add(i);
                intArrayList2.add(j);
                doubleArrayList.add(d);
            }
        }
    }

    public abstract double getQuick(int var1, int var2);

    public DoubleMatrix2D like() {
        return this.like(this.rows, this.columns);
    }

    public abstract DoubleMatrix2D like(int var1, int var2);

    public abstract DoubleMatrix1D like1D(int var1);

    public void normalize() {
        double d = this.getMinLocation()[0];
        if (d < 0.0) {
            this.assign(DoubleFunctions.minus(d));
        }
        if (this.getMaxLocation()[0] == 0.0) {
            this.assign(1.0 / (double)this.size());
        } else {
            double d2 = this.zSum();
            d2 = 1.0 / d2;
            this.assign(DoubleFunctions.mult(d2));
        }
    }

    public void set(int n, int n2, double d) {
        if (n2 < 0 || n2 >= this.columns || n < 0 || n >= this.rows) {
            throw new IndexOutOfBoundsException("row:" + n + ", column:" + n2);
        }
        this.setQuick(n, n2, d);
    }

    public abstract void setQuick(int var1, int var2, double var3);

    public double[][] toArray() {
        final double[][] dArray = new double[this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double[] dArray2 = dArray[i];
                            for (int j = 0; j < DoubleMatrix2D.this.columns; ++j) {
                                dArray2[j] = DoubleMatrix2D.this.getQuick(i, j);
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                double[] dArray2 = dArray[i];
                for (int j = 0; j < this.columns; ++j) {
                    dArray2[j] = this.getQuick(i, j);
                }
            }
        }
        return dArray;
    }

    public String toString() {
        return new DoubleFormatter().toString(this);
    }

    public abstract DoubleMatrix1D vectorize();

    public DoubleMatrix1D viewColumn(int n) {
        this.checkColumn(n);
        int n2 = this.rows;
        int n3 = (int)this.index(0, n);
        int n4 = this.rowStride;
        return this.like1D(n2, n3, n4);
    }

    public DoubleMatrix2D viewColumnFlip() {
        return (DoubleMatrix2D)this.view().vColumnFlip();
    }

    public DoubleMatrix2D viewDice() {
        return (DoubleMatrix2D)this.view().vDice();
    }

    public DoubleMatrix2D viewPart(int n, int n2, int n3, int n4) {
        return (DoubleMatrix2D)this.view().vPart(n, n2, n3, n4);
    }

    public DoubleMatrix1D viewRow(int n) {
        this.checkRow(n);
        int n2 = this.columns;
        int n3 = (int)this.index(n, 0);
        int n4 = this.columnStride;
        return this.like1D(n2, n3, n4);
    }

    public DoubleMatrix2D viewRowFlip() {
        return (DoubleMatrix2D)this.view().vRowFlip();
    }

    public DoubleMatrix2D viewSelection(DoubleMatrix1DProcedure doubleMatrix1DProcedure) {
        IntArrayList intArrayList = new IntArrayList();
        for (int i = 0; i < this.rows; ++i) {
            if (!doubleMatrix1DProcedure.apply(this.viewRow(i))) continue;
            intArrayList.add(i);
        }
        intArrayList.trimToSize();
        return this.viewSelection(intArrayList.elements(), null);
    }

    public DoubleMatrix2D viewSelection(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        if (nArray == null) {
            nArray = new int[this.rows];
            for (n2 = 0; n2 < this.rows; ++n2) {
                nArray[n2] = n2;
            }
        }
        if (nArray2 == null) {
            nArray2 = new int[this.columns];
            for (n2 = 0; n2 < this.columns; ++n2) {
                nArray2[n2] = n2;
            }
        }
        this.checkRowIndexes(nArray);
        this.checkColumnIndexes(nArray2);
        int[] nArray3 = new int[nArray.length];
        int[] nArray4 = new int[nArray2.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray3[n] = this._rowOffset(this._rowRank(nArray[n]));
        }
        for (n = 0; n < nArray2.length; ++n) {
            nArray4[n] = this._columnOffset(this._columnRank(nArray2[n]));
        }
        return this.viewSelectionLike(nArray3, nArray4);
    }

    public DoubleMatrix2D viewSelection(Set<int[]> set) {
        int n;
        int[] nArray4;
        int n2 = set.size();
        int[] nArray2 = new int[n2];
        int[] nArray3 = new int[n2];
        int n3 = 0;
        for (int[] nArray4 : set) {
            nArray2[n3] = nArray4[0];
            nArray3[n3] = nArray4[1];
            ++n3;
        }
        this.checkRowIndexes(nArray2);
        this.checkColumnIndexes(nArray3);
        Object object = new int[nArray2.length];
        nArray4 = new int[nArray3.length];
        for (n = 0; n < nArray2.length; ++n) {
            object[n] = this._rowOffset(this._rowRank(nArray2[n]));
        }
        for (n = 0; n < nArray3.length; ++n) {
            nArray4[n] = this._columnOffset(this._columnRank(nArray3[n]));
        }
        return this.viewSelectionLike((int[])object, nArray4);
    }

    public DoubleMatrix2D viewSorted(int n) {
        return DoubleSorting.mergeSort.sort(this, n);
    }

    public DoubleMatrix2D viewStrides(int n, int n2) {
        return (DoubleMatrix2D)this.view().vStrides(n, n2);
    }

    public void zAssign8Neighbors(DoubleMatrix2D doubleMatrix2D, Double9Function double9Function) {
        if (double9Function == null) {
            throw new NullPointerException("function must not be null.");
        }
        this.checkShape(doubleMatrix2D);
        if (this.rows < 3 || this.columns < 3) {
            return;
        }
        int n = this.rows - 1;
        int n2 = this.columns - 1;
        for (int i = 1; i < n; ++i) {
            double d = this.getQuick(i - 1, 0);
            double d2 = this.getQuick(i - 1, 1);
            double d3 = this.getQuick(i, 0);
            double d4 = this.getQuick(i, 1);
            double d5 = this.getQuick(i + 1, 0);
            double d6 = this.getQuick(i + 1, 1);
            for (int j = 1; j < n2; ++j) {
                double d7 = this.getQuick(i - 1, j + 1);
                double d8 = this.getQuick(i, j + 1);
                double d9 = this.getQuick(i + 1, j + 1);
                doubleMatrix2D.setQuick(i, j, double9Function.apply(d, d2, d7, d3, d4, d8, d5, d6, d9));
                d = d2;
                d3 = d4;
                d5 = d6;
                d2 = d7;
                d4 = d8;
                d6 = d9;
            }
        }
    }

    public DoubleMatrix1D zMult(DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2) {
        return this.zMult(doubleMatrix1D, doubleMatrix1D2, 1.0, 0.0, false);
    }

    public DoubleMatrix1D zMult(final DoubleMatrix1D doubleMatrix1D, DoubleMatrix1D doubleMatrix1D2, final double d, final double d2, boolean bl) {
        if (bl) {
            return this.viewDice().zMult(doubleMatrix1D, doubleMatrix1D2, d, d2, false);
        }
        final DoubleMatrix1D doubleMatrix1D3 = doubleMatrix1D2 == null ? doubleMatrix1D.like(this.rows) : doubleMatrix1D2;
        if ((long)this.columns != doubleMatrix1D.size() || (long)this.rows > doubleMatrix1D3.size()) {
            throw new IllegalArgumentException("Incompatible args: " + this.toStringShort() + ", " + doubleMatrix1D.toStringShort() + ", " + doubleMatrix1D3.toStringShort());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.rows);
            Future[] futureArray = new Future[n];
            int n2 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n3 = i * n2;
                final int n4 = i == n - 1 ? this.rows : n3 + n2;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n3; i < n4; ++i) {
                            double d3 = 0.0;
                            for (int j = 0; j < DoubleMatrix2D.this.columns; ++j) {
                                d3 += DoubleMatrix2D.this.getQuick(i, j) * doubleMatrix1D.getQuick(j);
                            }
                            doubleMatrix1D3.setQuick(i, d * d3 + d2 * doubleMatrix1D3.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < this.rows; ++i) {
                double d3 = 0.0;
                for (int j = 0; j < this.columns; ++j) {
                    d3 += this.getQuick(i, j) * doubleMatrix1D.getQuick(j);
                }
                doubleMatrix1D3.setQuick(i, d * d3 + d2 * doubleMatrix1D3.getQuick(i));
            }
        }
        return doubleMatrix1D3;
    }

    public DoubleMatrix2D zMult(DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2) {
        return this.zMult(doubleMatrix2D, doubleMatrix2D2, 1.0, 0.0, false, false);
    }

    public DoubleMatrix2D zMult(final DoubleMatrix2D doubleMatrix2D, DoubleMatrix2D doubleMatrix2D2, final double d, final double d2, boolean bl, boolean bl2) {
        if (bl) {
            return this.viewDice().zMult(doubleMatrix2D, doubleMatrix2D2, d, d2, false, bl2);
        }
        if (bl2) {
            return this.zMult(doubleMatrix2D.viewDice(), doubleMatrix2D2, d, d2, bl, false);
        }
        final int n = this.rows;
        final int n2 = this.columns;
        int n3 = doubleMatrix2D.columns;
        final DoubleMatrix2D doubleMatrix2D3 = doubleMatrix2D2 == null ? this.like(n, n3) : doubleMatrix2D2;
        if (doubleMatrix2D.rows != n2) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + doubleMatrix2D.toStringShort());
        }
        if (doubleMatrix2D3.rows != n || doubleMatrix2D3.columns != n3) {
            throw new IllegalArgumentException("Incompatibe result matrix: " + this.toStringShort() + ", " + doubleMatrix2D.toStringShort() + ", " + doubleMatrix2D3.toStringShort());
        }
        if (this == doubleMatrix2D3 || doubleMatrix2D == doubleMatrix2D3) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n4 = Math.min(n4, n3);
            Future[] futureArray = new Future[n4];
            int n5 = n3 / n4;
            for (int i = 0; i < n4; ++i) {
                final int n6 = i * n5;
                final int n7 = i == n4 - 1 ? n3 : n6 + n5;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        for (int i = n6; i < n7; ++i) {
                            for (int j = 0; j < n; ++j) {
                                double d3 = 0.0;
                                for (int k = 0; k < n2; ++k) {
                                    d3 += DoubleMatrix2D.this.getQuick(j, k) * doubleMatrix2D.getQuick(k, i);
                                }
                                doubleMatrix2D3.setQuick(j, i, d * d3 + d2 * doubleMatrix2D3.getQuick(j, i));
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            for (int i = 0; i < n3; ++i) {
                for (int j = 0; j < n; ++j) {
                    double d3 = 0.0;
                    for (int k = 0; k < n2; ++k) {
                        d3 += this.getQuick(j, k) * doubleMatrix2D.getQuick(k, i);
                    }
                    doubleMatrix2D3.setQuick(j, i, d * d3 + d2 * doubleMatrix2D3.getQuick(j, i));
                }
            }
        }
        return doubleMatrix2D3;
    }

    public double zSum() {
        if (this.size() == 0L) {
            return 0.0;
        }
        return this.aggregate(DoubleFunctions.plus, DoubleFunctions.identity);
    }

    protected DoubleMatrix2D getContent() {
        return this;
    }

    protected boolean haveSharedCells(DoubleMatrix2D doubleMatrix2D) {
        if (doubleMatrix2D == null) {
            return false;
        }
        if (this == doubleMatrix2D) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(doubleMatrix2D.getContent());
    }

    protected boolean haveSharedCellsRaw(DoubleMatrix2D doubleMatrix2D) {
        return false;
    }

    protected abstract DoubleMatrix1D like1D(int var1, int var2, int var3);

    protected DoubleMatrix2D view() {
        return (DoubleMatrix2D)this.clone();
    }

    protected abstract DoubleMatrix2D viewSelectionLike(int[] var1, int[] var2);
}

