/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.JGRDataFileSaveDialog;
import org.rosuda.JGR.JGRObjectManager;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.robjects.RObject;
import org.rosuda.JGR.toolkit.DataTable;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.ibase.SVarSet;

public class ObjectBrowserTree
extends JTree
implements ActionListener,
KeyListener,
MouseListener,
DragGestureListener,
DragSourceListener,
TreeWillExpandListener {
    private static final long serialVersionUID = 6767151436107674299L;
    private Collection data;
    private JGRObjectManager objmgr;
    private DragSource dragSource;
    private DataTreeModel objModel;
    private DefaultMutableTreeNode root;
    private RObject selectedObject = null;

    public ObjectBrowserTree(JGRObjectManager parent, Collection c, String name) {
        this.data = c;
        this.objmgr = parent;
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        ToolTipManager.sharedInstance().setReshowDelay(0);
        if (FontTracker.current == null) {
            FontTracker.current = new FontTracker();
        }
        FontTracker.current.add(this);
        this.root = new DefaultMutableTreeNode(name);
        this.objModel = new DataTreeModel(this.root);
        this.setModel(this.objModel);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        this.setToggleClickCount(100);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addTreeWillExpandListener(this);
    }

    private void addNodes(DefaultMutableTreeNode node) {
        RObject o = (RObject)node.getUserObject();
        for (RObject ro : RController.createContent(o, this.data)) {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(ro);
            if (!ro.isAtomar()) {
                child.add(new DefaultMutableTreeNode());
            }
            node.add(child);
        }
    }

    public void refresh(Collection c) {
        this.data = c;
        this.root.removeAllChildren();
        this.objModel = new DataTreeModel(this.root);
        this.setModel(null);
        this.setModel(this.objModel);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this.objmgr.summary != null) {
            this.objmgr.summary.hide();
        }
        if (e.isAltDown()) {
            this.objmgr.setWorking(true);
            Point p = e.getPoint();
            RObject o = (RObject)((DefaultMutableTreeNode)this.getUI().getClosestPathForLocation(this, p.x, p.y).getLastPathComponent()).getUserObject();
            String tip = RController.getSummary(o);
            if (tip != null) {
                this.objmgr.setWorking(false);
                return tip;
            }
            return null;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.startsWith("saveData")) {
            new JGRDataFileSaveDialog(this.objmgr, cmd.substring(9), JGRPrefs.workingDirectory);
        }
    }

    public void saveData() {
        new JGRDataFileSaveDialog(this.objmgr, this.selectedObject.getRName(), JGRPrefs.workingDirectory);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent evt) {
        Point p = evt.getDragOrigin();
        RObject o = (RObject)((DefaultMutableTreeNode)this.getUI().getClosestPathForLocation(this, p.x, p.y).getLastPathComponent()).getUserObject();
        StringSelection t = new StringSelection(o.getRName());
        if (t == null) {
            return;
        }
        this.dragSource.startDrag(evt, DragSource.DefaultCopyDrop, t, this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent evt) {
    }

    @Override
    public void dragOver(DragSourceDragEvent evt) {
    }

    @Override
    public void dragExit(DragSourceEvent evt) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent evt) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent evt) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 127 || e.getKeyCode() == 8) {
            TreePath[] sel = this.getSelectionPaths();
            for (int i = 0; i < sel.length; ++i) {
                TreePath p = sel[i];
                try {
                    if (((DefaultMutableTreeNode)p.getLastPathComponent()).getLevel() != 1) continue;
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)p.getPathComponent(1);
                    JGR.timedEval("rm(" + ((RObject)n.getUserObject()).getRName() + ")");
                    this.objModel.removeNodeFromParent(n);
                    continue;
                }
                catch (Exception ex) {
                    new ErrorMsg(ex);
                }
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        SVarSet vs;
        Point p = e.getPoint();
        RObject o = null;
        try {
            o = (RObject)((DefaultMutableTreeNode)this.getUI().getClosestPathForLocation(this, p.x, p.y).getLastPathComponent()).getUserObject();
            this.objmgr.savedata.setEnabled(o.isEditable());
            this.selectedObject = o;
        }
        catch (Exception ex) {
            this.objmgr.savedata.setEnabled(false);
            this.selectedObject = null;
        }
        if (e.getClickCount() == 2 && o != null && (vs = RController.newSet(o)) != null && vs.count() != 0) {
            new DataTable(vs, o.getType(), o.isEditable());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.objmgr.summary != null) {
            this.objmgr.summary.hide();
        }
        if (e.isPopupTrigger()) {
            this.objmgr.setWorking(true);
            Point p = e.getPoint();
            JToolTip call = new JToolTip();
            RObject o = (RObject)((DefaultMutableTreeNode)this.getUI().getClosestPathForLocation(this, p.x, p.y).getLastPathComponent()).getUserObject();
            String tip = RController.getSummary(o);
            if (tip == null) {
                this.objmgr.setWorking(false);
                return;
            }
            call.setTipText(tip);
            SwingUtilities.convertPointToScreen(p, this);
            this.objmgr.summary = PopupFactory.getSharedInstance().getPopup(this, call, p.x + 20, p.y + 25);
            this.objmgr.summary.show();
            this.objmgr.setWorking(false);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.objmgr.setWorking(true);
            Point p = e.getPoint();
            JToolTip call = new JToolTip();
            RObject o = (RObject)((DefaultMutableTreeNode)this.getUI().getClosestPathForLocation(this, p.x, p.y).getLastPathComponent()).getUserObject();
            String tip = RController.getSummary(o);
            if (tip == null) {
                this.objmgr.setWorking(false);
                return;
            }
            call.setTipText(tip);
            SwingUtilities.convertPointToScreen(p, this);
            this.objmgr.summary = PopupFactory.getSharedInstance().getPopup(this, call, p.x + 20, p.y + 25);
            this.objmgr.summary.show();
            this.objmgr.setWorking(false);
        }
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent e) {
        TreePath p = e.getPath();
        if (!this.hasBeenExpanded(p)) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)p.getLastPathComponent();
            n.removeAllChildren();
            this.objmgr.setWorking(true);
            this.addNodes(n);
            this.objmgr.setWorking(false);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent e) {
    }

    class DataTreeModel
    extends DefaultTreeModel {
        private static final long serialVersionUID = 7491143716491925921L;
        TreeNode root;

        public DataTreeModel(TreeNode node) {
            super(node);
            this.root = node;
            for (RObject o : ObjectBrowserTree.this.data) {
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(o);
                if (!o.isAtomar()) {
                    child.add(new DefaultMutableTreeNode());
                }
                ((DefaultMutableTreeNode)this.root).add(child);
            }
        }
    }
}

