/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.visualize;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.core.FastVector;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.visualize.VisualizeUtils;

public class ClassPanel
extends JPanel {
    private boolean m_isEnabled = false;
    private boolean m_isNumeric = false;
    private final int m_spectrumHeight = 5;
    private double m_maxC;
    private double m_minC;
    private final int m_tickSize = 5;
    private FontMetrics m_labelMetrics = null;
    private Font m_labelFont = null;
    private int m_HorizontalPad = 0;
    private int m_precisionC;
    private int m_fieldWidthC;
    private int m_oldWidth = -9000;
    private Instances m_Instances = null;
    private int m_cIndex;
    private FastVector m_colorList;
    private FastVector m_Repainters = new FastVector();
    private FastVector m_ColourChangeListeners = new FastVector();
    protected Color[] m_DefaultColors = new Color[]{Color.blue, Color.red, Color.green, Color.cyan, Color.pink, new Color(255, 0, 255), Color.orange, new Color(255, 0, 0), new Color(0, 255, 0), Color.white};

    public ClassPanel() {
        this.m_colorList = new FastVector(10);
        for (int i = this.m_colorList.size(); i < 10; ++i) {
            Color color = this.m_DefaultColors[i % 10];
            int n = i / 10;
            n *= 2;
            for (int j = 0; j < n; ++j) {
                color = color.darker();
            }
            this.m_colorList.addElement(color);
        }
    }

    public void addRepaintNotify(Component component) {
        this.m_Repainters.addElement(component);
    }

    public void addActionListener(ActionListener actionListener) {
        this.m_ColourChangeListeners.addElement(actionListener);
    }

    private void setFonts(Graphics graphics) {
        if (this.m_labelMetrics == null) {
            this.m_labelFont = new Font("Monospaced", 0, 12);
            this.m_labelMetrics = graphics.getFontMetrics(this.m_labelFont);
            int n = this.m_labelMetrics.getAscent();
            if (this.getHeight() < 3 * n) {
                this.m_labelFont = new Font("Monospaced", 0, 11);
                this.m_labelMetrics = graphics.getFontMetrics(this.m_labelFont);
            }
        }
        graphics.setFont(this.m_labelFont);
    }

    public void setOn(boolean bl) {
        this.m_isEnabled = bl;
    }

    public void setInstances(Instances instances) {
        this.m_Instances = instances;
    }

    public void setCindex(int n) {
        if (this.m_Instances.numAttributes() > 0) {
            this.m_cIndex = n;
            if (this.m_Instances.attribute(this.m_cIndex).isNumeric()) {
                this.setNumeric();
            } else {
                if (this.m_Instances.attribute(this.m_cIndex).numValues() > this.m_colorList.size()) {
                    this.extendColourMap();
                }
                this.setNominal();
            }
        }
    }

    private void extendColourMap() {
        if (this.m_Instances.attribute(this.m_cIndex).isNominal()) {
            for (int i = this.m_colorList.size(); i < this.m_Instances.attribute(this.m_cIndex).numValues(); ++i) {
                Color color = this.m_DefaultColors[i % 10];
                int n = i / 10;
                n *= 2;
                for (int j = 0; j < n; ++j) {
                    color = color.brighter();
                }
                this.m_colorList.addElement(color);
            }
        }
    }

    public void setColours(FastVector fastVector) {
        this.m_colorList = fastVector;
    }

    protected void setNominal() {
        this.m_isNumeric = false;
        this.m_HorizontalPad = 0;
        this.setOn(true);
        this.m_oldWidth = -9000;
        this.repaint();
    }

    protected void setNumeric() {
        int n;
        this.m_isNumeric = true;
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        for (n = 0; n < this.m_Instances.numInstances(); ++n) {
            if (this.m_Instances.instance(n).isMissing(this.m_cIndex)) continue;
            double d3 = this.m_Instances.instance(n).value(this.m_cIndex);
            if (d3 < d) {
                d = d3;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        if (d == Double.POSITIVE_INFINITY) {
            d2 = 0.0;
            d = 0.0;
        }
        this.m_minC = d;
        this.m_maxC = d2;
        n = (int)Math.abs(this.m_maxC);
        double d4 = Math.abs(this.m_maxC) - (double)n;
        int n2 = n > 0 ? (int)(Math.log(n) / Math.log(10.0)) : 1;
        int n3 = this.m_precisionC = d4 > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_maxC)) / Math.log(10.0)) + 2 : 1;
        if (this.m_precisionC > VisualizeUtils.MAX_PRECISION) {
            this.m_precisionC = 1;
        }
        String string = Utils.doubleToString(this.m_maxC, n2 + 1 + this.m_precisionC, this.m_precisionC);
        if (this.m_labelMetrics != null) {
            this.m_HorizontalPad = this.m_labelMetrics.stringWidth(string);
        }
        n = (int)Math.abs(this.m_minC);
        d4 = Math.abs(this.m_minC) - (double)n;
        n2 = n > 0 ? (int)(Math.log(n) / Math.log(10.0)) : 1;
        int n4 = this.m_precisionC = d4 > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_minC)) / Math.log(10.0)) + 2 : 1;
        if (this.m_precisionC > VisualizeUtils.MAX_PRECISION) {
            this.m_precisionC = 1;
        }
        string = Utils.doubleToString(this.m_minC, n2 + 1 + this.m_precisionC, this.m_precisionC);
        if (this.m_labelMetrics != null && this.m_labelMetrics.stringWidth(string) > this.m_HorizontalPad) {
            this.m_HorizontalPad = this.m_labelMetrics.stringWidth(string);
        }
        this.setOn(true);
        this.repaint();
    }

    protected void paintNominal(Graphics graphics) {
        NomLabel nomLabel;
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        this.setFonts(graphics);
        int n5 = this.m_Instances.attribute(this.m_cIndex).numValues();
        int n6 = 0;
        int n7 = 0;
        int n8 = this.getWidth();
        int n9 = this.m_labelMetrics.getAscent();
        for (n4 = 0; n4 < n5; ++n4) {
            if (this.m_Instances.attribute(this.m_cIndex).value(n4).length() <= n6) continue;
            n6 = this.m_Instances.attribute(this.m_cIndex).value(n4).length();
            n7 = n4;
        }
        n6 = this.m_labelMetrics.stringWidth(this.m_Instances.attribute(this.m_cIndex).value(n7));
        int n10 = (n8 - 2 * this.m_HorizontalPad) / (n6 + 5) >= n5 ? 1 : 2;
        n4 = this.m_HorizontalPad;
        int n11 = 1 + n9;
        int n12 = n10 == 1 ? n5 : n5 / 2;
        for (n3 = 0; n3 < n12; ++n3) {
            graphics.setColor((Color)this.m_colorList.elementAt(n3));
            if (n12 * n6 > n8 - this.m_HorizontalPad * 2) {
                object = this.m_Instances.attribute(this.m_cIndex).value(n3);
                n2 = this.m_labelMetrics.stringWidth((String)object);
                n = 0;
                if (n2 > (n8 - this.m_HorizontalPad * 2) / n12) {
                    int n13 = n2 / ((String)object).length();
                    n = (n2 - (n8 - this.m_HorizontalPad * 2) / n12) / n13;
                    if (n <= 0) {
                        n = 0;
                    }
                    object = ((String)object).substring(0, ((String)object).length() - n);
                    n2 = this.m_labelMetrics.stringWidth((String)object);
                }
                nomLabel = new NomLabel((String)object, n3);
                nomLabel.setFont(graphics.getFont());
                nomLabel.setSize(this.m_labelMetrics.stringWidth(nomLabel.getText()), this.m_labelMetrics.getAscent() + 4);
                this.add(nomLabel);
                nomLabel.setLocation(n4, n11);
                nomLabel.setForeground((Color)this.m_colorList.elementAt(n3 % this.m_colorList.size()));
                n4 += n2 + 2;
                continue;
            }
            object = new NomLabel(this.m_Instances.attribute(this.m_cIndex).value(n3), n3);
            ((JComponent)object).setFont(graphics.getFont());
            ((Component)object).setSize(this.m_labelMetrics.stringWidth(((JLabel)object).getText()), this.m_labelMetrics.getAscent() + 4);
            this.add((Component)object);
            ((Component)object).setLocation(n4, n11);
            ((JComponent)object).setForeground((Color)this.m_colorList.elementAt(n3 % this.m_colorList.size()));
            n4 += (n8 - this.m_HorizontalPad * 2) / n12;
        }
        n4 = this.m_HorizontalPad;
        n11 = 1 + n9 + 5 + n9;
        for (n3 = n12; n3 < n5; ++n3) {
            graphics.setColor((Color)this.m_colorList.elementAt(n3));
            if ((n5 - n12 + 1) * n6 > n8 - this.m_HorizontalPad * 2) {
                object = this.m_Instances.attribute(this.m_cIndex).value(n3);
                n2 = this.m_labelMetrics.stringWidth((String)object);
                n = 0;
                if (n2 > (n8 - this.m_HorizontalPad * 2) / (n5 - n12 + 1)) {
                    int n14 = n2 / ((String)object).length();
                    n = (n2 - (n8 - this.m_HorizontalPad * 2) / (n5 - n12)) / n14;
                    if (n <= 0) {
                        n = 0;
                    }
                    object = ((String)object).substring(0, ((String)object).length() - n);
                    n2 = this.m_labelMetrics.stringWidth((String)object);
                }
                nomLabel = new NomLabel((String)object, n3);
                nomLabel.setFont(graphics.getFont());
                nomLabel.setSize(this.m_labelMetrics.stringWidth(nomLabel.getText()), this.m_labelMetrics.getAscent() + 4);
                this.add(nomLabel);
                nomLabel.setLocation(n4, n11);
                nomLabel.setForeground((Color)this.m_colorList.elementAt(n3 % this.m_colorList.size()));
                n4 += n2 + 2;
                continue;
            }
            object = new NomLabel(this.m_Instances.attribute(this.m_cIndex).value(n3), n3);
            ((JComponent)object).setFont(graphics.getFont());
            ((Component)object).setSize(this.m_labelMetrics.stringWidth(((JLabel)object).getText()), this.m_labelMetrics.getAscent() + 4);
            this.add((Component)object);
            ((Component)object).setLocation(n4, n11);
            ((JComponent)object).setForeground((Color)this.m_colorList.elementAt(n3 % this.m_colorList.size()));
            n4 += (n8 - this.m_HorizontalPad * 2) / (n5 - n12);
        }
    }

    protected void paintNumeric(Graphics graphics) {
        String string;
        int n;
        int n2;
        int n3;
        this.setFonts(graphics);
        if (this.m_HorizontalPad == 0) {
            this.setCindex(this.m_cIndex);
        }
        int n4 = this.getWidth();
        double d = 15.0;
        double d2 = 240.0 / (double)(n4 - this.m_HorizontalPad * 2);
        int n5 = this.m_labelMetrics.getAscent();
        for (n3 = this.m_HorizontalPad; n3 < n4 - this.m_HorizontalPad; ++n3) {
            Color color = new Color((int)d, 150, (int)(255.0 - d));
            graphics.setColor(color);
            graphics.drawLine(n3, 0, n3, 5);
            d += d2;
        }
        n3 = (int)Math.abs(this.m_maxC);
        double d3 = Math.abs(this.m_maxC) - (double)n3;
        int n6 = n3 > 0 ? (int)(Math.log(n3) / Math.log(10.0)) : 1;
        int n7 = this.m_precisionC = d3 > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_maxC)) / Math.log(10.0)) + 2 : 1;
        if (this.m_precisionC > VisualizeUtils.MAX_PRECISION) {
            this.m_precisionC = 1;
        }
        if (n4 > 2 * (n2 = (n = this.m_labelMetrics.stringWidth(string = Utils.doubleToString(this.m_maxC, n6 + 1 + this.m_precisionC, this.m_precisionC))))) {
            graphics.setColor(Color.black);
            graphics.drawLine(this.m_HorizontalPad, 10, n4 - this.m_HorizontalPad, 10);
            graphics.drawLine(n4 - this.m_HorizontalPad, 10, n4 - this.m_HorizontalPad, 15);
            graphics.drawString(string, n4 - this.m_HorizontalPad - n / 2, 15 + n5);
            graphics.drawLine(this.m_HorizontalPad, 10, this.m_HorizontalPad, 15);
            n3 = (int)Math.abs(this.m_minC);
            d3 = Math.abs(this.m_minC) - (double)n3;
            n6 = n3 > 0 ? (int)(Math.log(n3) / Math.log(10.0)) : 1;
            int n8 = this.m_precisionC = d3 > 0.0 ? (int)Math.abs(Math.log(Math.abs(this.m_minC)) / Math.log(10.0)) + 2 : 1;
            if (this.m_precisionC > VisualizeUtils.MAX_PRECISION) {
                this.m_precisionC = 1;
            }
            string = Utils.doubleToString(this.m_minC, n6 + 1 + this.m_precisionC, this.m_precisionC);
            n = this.m_labelMetrics.stringWidth(string);
            graphics.drawString(string, this.m_HorizontalPad - n / 2, 15 + n5);
            if (n4 > 3 * n2) {
                double d4 = this.m_minC + (this.m_maxC - this.m_minC) / 2.0;
                graphics.drawLine(this.m_HorizontalPad + (n4 - 2 * this.m_HorizontalPad) / 2, 10, this.m_HorizontalPad + (n4 - 2 * this.m_HorizontalPad) / 2, 15);
                n3 = (int)Math.abs(d4);
                d3 = Math.abs(d4) - (double)n3;
                n6 = n3 > 0 ? (int)(Math.log(n3) / Math.log(10.0)) : 1;
                int n9 = this.m_precisionC = d3 > 0.0 ? (int)Math.abs(Math.log(Math.abs(d4)) / Math.log(10.0)) + 2 : 1;
                if (this.m_precisionC > VisualizeUtils.MAX_PRECISION) {
                    this.m_precisionC = 1;
                }
                string = Utils.doubleToString(d4, n6 + 1 + this.m_precisionC, this.m_precisionC);
                n = this.m_labelMetrics.stringWidth(string);
                graphics.drawString(string, this.m_HorizontalPad + (n4 - 2 * this.m_HorizontalPad) / 2 - n / 2, 15 + n5);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.m_isEnabled) {
            if (this.m_isNumeric) {
                this.m_oldWidth = -9000;
                this.removeAll();
                this.paintNumeric(graphics);
            } else if (this.m_Instances != null && this.m_Instances.numInstances() > 0 && this.m_Instances.numAttributes() > 0 && this.m_oldWidth != this.getWidth()) {
                this.removeAll();
                this.m_oldWidth = this.getWidth();
                this.paintNominal(graphics);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length < 1) {
                System.err.println("Usage : weka.gui.visualize.ClassPanel <dataset> [class col]");
                System.exit(1);
            }
            final JFrame jFrame = new JFrame("Weka Explorer: Class");
            jFrame.setSize(500, 100);
            jFrame.getContentPane().setLayout(new BorderLayout());
            ClassPanel classPanel = new ClassPanel();
            jFrame.getContentPane().add((Component)classPanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            if (stringArray.length >= 1) {
                System.err.println("Loading instances from " + stringArray[0]);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
                Instances instances = new Instances(bufferedReader);
                instances.setClassIndex(instances.numAttributes() - 1);
                classPanel.setInstances(instances);
            }
            if (stringArray.length > 1) {
                classPanel.setCindex(Integer.parseInt(stringArray[1]) - 1);
            } else {
                classPanel.setCindex(0);
            }
            jFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    private class NomLabel
    extends JLabel {
        private int m_index;

        public NomLabel(String string, int n) {
            super(string);
            this.m_index = 0;
            this.m_index = n;
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    Color color;
                    if ((mouseEvent.getModifiers() & 0x10) == 16 && (color = JColorChooser.showDialog(ClassPanel.this, "Select new Color", (Color)ClassPanel.this.m_colorList.elementAt(NomLabel.this.m_index))) != null) {
                        int n;
                        ClassPanel.this.m_colorList.setElementAt(color, NomLabel.this.m_index);
                        ClassPanel.this.m_oldWidth = -9000;
                        ClassPanel.this.repaint();
                        if (ClassPanel.this.m_Repainters.size() > 0) {
                            for (n = 0; n < ClassPanel.this.m_Repainters.size(); ++n) {
                                ((Component)ClassPanel.this.m_Repainters.elementAt(n)).repaint();
                            }
                        }
                        if (ClassPanel.this.m_ColourChangeListeners.size() > 0) {
                            for (n = 0; n < ClassPanel.this.m_ColourChangeListeners.size(); ++n) {
                                ((ActionListener)ClassPanel.this.m_ColourChangeListeners.elementAt(n)).actionPerformed(new ActionEvent(this, 0, ""));
                            }
                        }
                    }
                }
            });
        }
    }
}

