# Test Indexing
expect_equal(
  latLngToCell(
    lat = c(-37.820197, -37.818476)
    , lng = c(144.983324, 144.967354)
    , resolution = c(12L, 4L)
    )
  , c("8cbe63562a54bff", "84be635ffffffff")
  )

expect_error(
  latLngToCell(
    lat = 1
    , lng = 2:3
    , resolution = 1
  )
  , pattern = "h3r - Error: Input vectors do not have consistent length"
)

expect_equal(
  cellToLatLng(
    cell = c("8cbe63562a54bff","85283473fffffff")
    )
  , data.frame(
    "lat" = c(-37.82022743390463, 37.34579337536848)
    , "lng" = c(144.98320124261153, -121.9763759725512)
    )
  )

expect_equal(
  cellToBoundary(
    cell = c("8cbe63562a54bff","85283473fffffff")
    )
  , list("8cbe63562a54bff" = data.frame(
    "lat" = c(-37.82029703468319, -37.820192820098555, -37.820123219343586, -37.82015783305605, -37.82026204755865, -37.82033164843081),
    "lng" = c(144.9833025854974, 144.98332703750785, 144.9832256947245,144.98309989994118, 144.98307544766354, 144.98317679043646)),
    "85283473fffffff" = data.frame(
      "lat" = c(37.271355866731895, 37.35392645085226, 37.42834118609435, 37.42012867767778, 37.33755608435298, 37.26319797461824),
      "lng" = c(-121.91508032705622, -121.86222328902487, -121.92354999630157, -122.03773496427027, -122.09042892904397, -122.02910130918998)))
  )
