/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.regular;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.iterators.IntEnumeration;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.memory.structure.IndexedObject;
import choco.kernel.memory.structure.StoredIndexedBipartiteSet;
import choco.kernel.memory.structure.iterators.BipartiteSetIterator;
import choco.kernel.model.constraints.automaton.DFA;
import choco.kernel.model.constraints.automaton.LightLayeredDFA;
import choco.kernel.model.constraints.automaton.LightState;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

public final class Regular
extends AbstractLargeIntSConstraint {
    public static final boolean INCREMENTAL = true;
    protected StoredIndexedBipartiteSet[] Qij;
    protected int[] offset;
    protected int[] start;
    protected int[] sizes;
    protected LightLayeredDFA autom;
    protected int nbNode;
    protected PropagationData sdata;
    private int nbVars;
    protected ArrayList<LightState>[] Ni;
    protected BitSet mark;
    protected HashSet<IndexedObject>[] qijvalues;

    public Regular(DFA auto, IntDomainVar[] vs, int[] lbs, int[] dsize, IEnvironment environment) {
        super(ConstraintEvent.LINEAR, vs);
        this.init(auto.lightGraph, lbs, dsize, environment);
    }

    public Regular(DFA auto, IntDomainVar[] vs, IEnvironment environment) {
        super(ConstraintEvent.LINEAR, vs);
        int[] offset = new int[((IntDomainVar[])this.vars).length];
        int[] sizes = new int[((IntDomainVar[])this.vars).length];
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            offset[i] = ((IntDomainVar[])this.vars)[i].getInf();
            sizes[i] = ((IntDomainVar[])this.vars)[i].getSup() - ((IntDomainVar[])this.vars)[i].getInf() + 1;
        }
        this.init(auto.lightGraph, offset, sizes, environment);
    }

    public void init(LightLayeredDFA auto, int[] lbs, int[] dsize, IEnvironment environment) {
        int i;
        this.autom = auto;
        this.nbVars = ((IntDomainVar[])this.vars).length;
        this.start = new int[((IntDomainVar[])this.vars).length];
        this.offset = lbs;
        this.sizes = dsize;
        this.nbNode = this.autom.getAutomateSize();
        this.sdata = new PropagationData(this, environment);
        this.start[0] = 0;
        for (int i2 = 0; i2 < ((IntDomainVar[])this.vars).length; ++i2) {
            if (i2 <= 0) continue;
            this.start[i2] = this.start[i2 - 1] + this.sizes[i2 - 1];
        }
        this.Qij = new StoredIndexedBipartiteSet[this.start[this.nbVars - 1] + this.sizes[this.nbVars - 1]];
        ArrayList[] qijvalues = new ArrayList[this.Qij.length];
        for (i = 0; i < qijvalues.length; ++i) {
            qijvalues[i] = new ArrayList();
        }
        this.initQij(qijvalues);
        for (i = 0; i < this.Qij.length; ++i) {
            this.Qij[i] = (StoredIndexedBipartiteSet)environment.makeBipartiteSet(qijvalues[i]);
        }
    }

    public void initQij(ArrayList[] qijvalues) {
        int i;
        this.mark = new BitSet(this.nbNode);
        this.Ni = new ArrayList[this.nbVars + 1];
        for (i = 0; i < this.nbVars + 1; ++i) {
            this.Ni[i] = new ArrayList();
        }
        this.Ni[0].add(this.autom.getInitState());
        for (i = 0; i < this.Ni.length - 1; ++i) {
            for (LightState st : this.Ni[i]) {
                DisposableIntIterator domIt = ((IntDomainVar[])this.vars)[i].getDomain().getIterator();
                while (domIt.hasNext()) {
                    int val = domIt.next();
                    if (!st.hasDelta(val - this.autom.getOffset(i))) continue;
                    qijvalues[this.start[i] + val - this.offset[i]].add(st);
                    LightState nst = st.delta(val - this.autom.getOffset(i));
                    if (this.mark.get(nst.getIdx())) continue;
                    this.Ni[i + 1].add(nst);
                    this.mark.set(nst.getIdx());
                }
                domIt.dispose();
            }
        }
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 4;
    }

    public StoredIndexedBipartiteSet getQij(int var, int val) {
        return this.Qij[this.start[var] + val - this.offset[var]];
    }

    public void initData() {
        int i;
        this.mark = new BitSet(this.nbNode);
        this.qijvalues = new HashSet[this.Qij.length];
        for (i = 0; i < this.Qij.length; ++i) {
            this.qijvalues[i] = new HashSet();
        }
        this.Ni = new ArrayList[this.nbVars + 1];
        for (i = 0; i < this.nbVars + 1; ++i) {
            this.Ni[i] = new ArrayList();
        }
    }

    public void initMarck() {
        this.mark.clear();
        this.mark.set(0);
        this.mark.set(this.nbNode - 1);
    }

    public void forwardUpdate() {
        this.Ni[0].add(this.autom.getInitState());
        for (int i = 0; i < this.Ni.length - 1; ++i) {
            this.forwardOnLevel(i);
        }
    }

    public void forwardOnLevel(int i) {
        for (LightState st : this.Ni[i]) {
            DisposableIntIterator domIt = ((IntDomainVar[])this.vars)[i].getDomain().getIterator();
            while (domIt.hasNext()) {
                int val = domIt.next();
                if (!st.hasDelta(val - this.autom.getOffset(i))) continue;
                this.qijvalues[this.start[i] + val - this.offset[i]].add(st);
                LightState nst = st.delta(val - this.autom.getOffset(i));
                if (this.mark.get(nst.getIdx())) continue;
                this.Ni[i + 1].add(nst);
                this.mark.set(nst.getIdx());
            }
            domIt.dispose();
        }
    }

    public void backwardUpdate() {
        for (int i = this.Ni.length - 2; i >= 0; --i) {
            this.backward2OnLevel(i);
            this.backwardOnLevel(i);
            Iterator<LightState> it = this.Ni[i].iterator();
            while (it.hasNext()) {
                LightState st = it.next();
                if (this.mark.get(st.getIdx())) continue;
                it.remove();
            }
        }
    }

    public void backwardOnLevel(int i) {
        DisposableIntIterator domIt = ((IntDomainVar[])this.vars)[i].getDomain().getIterator();
        while (domIt.hasNext()) {
            int val = domIt.next();
            StoredIndexedBipartiteSet qij = this.getQij(i, val);
            BipartiteSetIterator it = qij.getObjectIterator();
            while (it.hasNext()) {
                LightState st = (LightState)it.nextObject();
                LightState nst = st.delta(val - this.autom.getOffset(i));
                if (nst != null && this.mark.get(nst.getIdx())) {
                    this.mark.set(st.getIdx());
                    this.sdata.incrementOutdeg(st);
                    this.sdata.incrementIndeg(nst);
                    continue;
                }
                it.remove();
            }
            it.dispose();
        }
        domIt.dispose();
    }

    public void backward2OnLevel(int i) {
        DisposableIntIterator domIt = ((IntDomainVar[])this.vars)[i].getDomain().getIterator();
        while (domIt.hasNext()) {
            int val = domIt.next();
            StoredIndexedBipartiteSet qij = this.getQij(i, val);
            BipartiteSetIterator it = qij.getObjectIterator();
            while (it.hasNext()) {
                LightState st = (LightState)it.nextObject();
                if (this.qijvalues[this.start[i] + val - this.offset[i]].contains(st)) continue;
                it.remove();
            }
            it.dispose();
        }
        domIt.dispose();
    }

    public void cleanUp() throws ContradictionException {
        for (int i = 0; i < this.nbVars; ++i) {
            int fin = i == this.nbVars - 1 ? this.Qij.length : this.start[i + 1];
            for (int j = this.start[i]; j < fin; ++j) {
                int val;
                if (!this.Qij[j].isEmpty() || !((IntDomainVar[])this.vars)[i].canBeInstantiatedTo((val = j - this.start[i]) + this.offset[i])) continue;
                this.prune(i, val + this.offset[i]);
            }
        }
    }

    @Override
    public void propagate() throws ContradictionException {
        if (!this.autom.isEmpty()) {
            this.sdata.resetPropagationData(this.nbNode);
            this.initData();
            this.initMarck();
            this.forwardUpdate();
            this.initMarck();
            this.backwardUpdate();
            this.cleanUp();
            this.mark = null;
            this.Ni = null;
        } else {
            this.fail();
        }
    }

    public void prune(int i, int val) throws ContradictionException {
        ((IntDomainVar[])this.vars)[i].removeVal(val, this, false);
    }

    @Override
    public void awake() throws ContradictionException {
        this.propagate();
    }

    public void propagateRemoval(int i, int j) throws ContradictionException {
        StoredIndexedBipartiteSet qij = this.getQij(i, j);
        for (int k = 0; k < qij.size(); ++k) {
            LightState st = (LightState)qij.getObject(k);
            LightState nst = st.delta(j - this.autom.getOffset(i));
            this.decrement_outdeg(st, i);
            this.decrement_indeg(nst, i + 1);
        }
        qij.clear();
    }

    public void decrement_outdeg(LightState st, int i) throws ContradictionException {
        this.sdata.decrementOutdeg(st);
        if (this.sdata.getOutdeg(st) == 0) {
            this.propagateNullOutDeg(st, i);
        }
    }

    public void propagateNullOutDeg(LightState st, int i) throws ContradictionException {
        Enumeration<? extends LightState.Arcs> pred = st.getEnumerationPred();
        while (pred.hasMoreElements()) {
            LightState.Arcs ap = pred.nextElement();
            LightState pst = ap.getSt();
            IntEnumeration valpred = ap.getEnumerationPred();
            if (!this.sdata.isAccurate(pst)) continue;
            while (valpred.hasMoreElements()) {
                int val = valpred.nextElement();
                int realval = val + this.autom.getOffset(i - 1);
                if (!((IntDomainVar[])this.vars)[i - 1].canBeInstantiatedTo(realval)) continue;
                StoredIndexedBipartiteSet supports = this.getQij(i - 1, realval);
                supports.remove(pst);
                if (supports.isEmpty()) {
                    this.prune(i - 1, realval);
                }
                this.decrement_outdeg(pst, i - 1);
            }
        }
    }

    public void decrement_indeg(LightState st, int i) throws ContradictionException {
        this.sdata.decrementIndeg(st);
        if (this.sdata.getIndeg(st) == 0) {
            this.propagateNullInDeg(st, i);
        }
    }

    public void propagateNullInDeg(LightState st, int i) throws ContradictionException {
        Enumeration<? extends Integer> succ = st.getEnumerationSucc();
        while (succ.hasMoreElements()) {
            int val = succ.nextElement();
            int realval = val + this.autom.getOffset(i);
            LightState nst = st.delta(val);
            if (!((IntDomainVar[])this.vars)[i].canBeInstantiatedTo(realval)) continue;
            StoredIndexedBipartiteSet supports = this.getQij(i, realval);
            supports.remove(st);
            if (supports.isEmpty()) {
                this.prune(i, realval);
            }
            this.decrement_indeg(nst, i + 1);
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        this.propagateRemoval(idx, x);
        if (!((IntDomainVar[])this.vars)[idx].hasEnumeratedDomain()) {
            StoredIndexedBipartiteSet supports = this.getQij(idx, ((IntDomainVar[])this.vars)[idx].getInf());
            if (supports.isEmpty()) {
                ((IntDomainVar[])this.vars)[idx].removeVal(((IntDomainVar[])this.vars)[idx].getInf(), this, true);
            }
            if ((supports = this.getQij(idx, ((IntDomainVar[])this.vars)[idx].getSup())).isEmpty()) {
                ((IntDomainVar[])this.vars)[idx].removeVal(((IntDomainVar[])this.vars)[idx].getSup(), this, true);
            }
        }
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        LightState tmp = this.autom.getInitState();
        for (int i = 0; i < tuple.length; ++i) {
            if ((tmp = tmp.delta(tuple[i] - this.autom.getOffset(i))) != null) continue;
            return false;
        }
        return this.autom.getLastState() == tmp;
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("Regular({");
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            IntDomainVar var = ((IntDomainVar[])this.vars)[i];
            sb.append(var.pretty());
        }
        sb.append("})");
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder autstring = new StringBuilder("auto : ");
        for (int i = 0; i < ((IntDomainVar[])this.vars).length; ++i) {
            autstring.append(((IntDomainVar[])this.vars)[i]).append(' ');
        }
        return autstring.toString();
    }

    class PropagationData {
        protected Solver solver;
        protected IStateInt[] indeg;
        protected IStateInt[] outdeg;
        protected int fstate;

        public PropagationData(AbstractSConstraint ct, IEnvironment environment) {
            this.initDegree(Regular.this.autom.getAutomateSize(), ct, environment);
        }

        public void initDegree(int nbNode, AbstractSConstraint ct, IEnvironment environment) {
            this.indeg = new IStateInt[nbNode];
            this.outdeg = new IStateInt[nbNode];
            this.fstate = nbNode - 1;
            for (int node = 0; node < nbNode; ++node) {
                this.indeg[node] = environment.makeInt(0);
                this.outdeg[node] = environment.makeInt(0);
            }
        }

        public void resetPropagationData(int nbNode) {
            for (int node = 0; node < nbNode; ++node) {
                this.indeg[node].set(0);
                this.outdeg[node].set(0);
            }
        }

        public boolean isAccurate(LightState st) {
            if (st.getIdx() == 0) {
                return this.outdeg[st.getIdx()].get() > 0;
            }
            if (st.getIdx() == this.fstate) {
                return this.indeg[st.getIdx()].get() > 0;
            }
            return this.indeg[st.getIdx()].get() > 0 && this.outdeg[st.getIdx()].get() > 0;
        }

        public int getIndeg(LightState st) {
            return this.indeg[st.getIdx()].get();
        }

        public void setIndeg(IStateInt indeg, LightState st) {
            this.indeg[st.getIdx()] = indeg;
        }

        public int getOutdeg(LightState st) {
            return this.outdeg[st.getIdx()].get();
        }

        public void setOutdeg(IStateInt outdeg, LightState st) {
            this.outdeg[st.getIdx()] = outdeg;
        }

        public void incrementIndeg(LightState st) {
            this.indeg[st.getIdx()].add(1);
        }

        public void decrementIndeg(LightState st) {
            this.indeg[st.getIdx()].add(-1);
        }

        public void incrementOutdeg(LightState st) {
            this.outdeg[st.getIdx()].add(1);
        }

        public void decrementOutdeg(LightState st) {
            this.outdeg[st.getIdx()].add(-1);
        }
    }
}

