/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff.ui;

import com.qarks.util.files.diff.Diff;
import com.qarks.util.files.diff.FileLine;
import com.qarks.util.files.diff.ui.LineCellRenderer;
import com.qarks.util.files.diff.ui.MergeButton;
import com.qarks.util.files.diff.ui.MergeContentPanel;
import com.qarks.util.files.diff.ui.MergeItem;
import com.qarks.util.files.diff.ui.ResourceKeyDiff;
import com.qarks.util.ui.resources.ResourceManager;
import com.qarks.util.ui.swing.JFontTextArea;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JViewport;

public class MergePanelItem
extends JPanel
implements MergeItem,
ActionListener {
    protected MergeButton useLeftText;
    protected MergeButton useRightText;
    protected String leftText;
    protected String rightText;
    protected JTextArea textArea;
    protected JViewport viewPort;
    private int lineCount;
    private JComponent leftTextComponent;
    private JComponent rightTextComponent;
    private int initialPreferredHeight = -1;
    private Type type;
    private Dimension beforeDim;

    public MergePanelItem(ArrayList<FileLine> arrayList, ArrayList<FileLine> arrayList2, int n, boolean bl, Type type, JComponent jComponent, JComponent jComponent2) {
        this.leftText = Diff.buildText(arrayList);
        this.rightText = Diff.buildText(arrayList2);
        this.lineCount = n;
        this.type = type;
        this.leftTextComponent = jComponent;
        this.rightTextComponent = jComponent2;
        this.textArea = new JFontTextArea();
        this.useLeftText = new MergeButton("");
        this.useRightText = new MergeButton("");
        String string = System.getProperty("line.separator");
        boolean bl2 = false;
        switch (type) {
            case CONFLICT: {
                this.useLeftText.setColor(LineCellRenderer.CONFLICT_COLOR);
                this.useRightText.setColor(LineCellRenderer.CONFLICT_COLOR);
                bl2 = true;
                break;
            }
            case WARNING_DELETE: {
                this.useLeftText.setColor(LineCellRenderer.WARNING_COLOR.brighter());
                this.useRightText.setColor(LineCellRenderer.WARNING_COLOR.brighter());
                bl2 = true;
                break;
            }
            case WARNING_ORDER: {
                n *= 2;
                this.useLeftText.setColor(LineCellRenderer.WARNING_COLOR);
                this.useRightText.setColor(LineCellRenderer.WARNING_COLOR);
                bl2 = true;
            }
        }
        this.useLeftText.setActive(bl2);
        this.useRightText.setActive(bl2);
        String string2 = "";
        switch (type) {
            case NO_CONFLICT: {
                string2 = bl ? this.leftText : this.rightText;
                break;
            }
            case CONFLICT: {
                this.useLeftText.setToolTipText(ResourceManager.getString((Object)ResourceKeyDiff.USE_LEFT));
                this.useRightText.setToolTipText(ResourceManager.getString((Object)ResourceKeyDiff.USE_RIGHT));
                string2 = this.leftText;
                break;
            }
            case WARNING_ORDER: {
                this.useLeftText.setToolTipText(ResourceManager.getString((Object)ResourceKeyDiff.INSERT_LEFT_FIRST));
                this.useRightText.setToolTipText(ResourceManager.getString((Object)ResourceKeyDiff.INSERT_RIGHT_FIRST));
                string2 = this.leftText + string + this.rightText;
                break;
            }
            case WARNING_DELETE: {
                if (bl) {
                    this.useLeftText.setToolTipText(ResourceManager.getString((Object)ResourceKeyDiff.KEEP_DELETED));
                    this.useRightText.setToolTipText(ResourceManager.getString((Object)ResourceKeyDiff.PUT_BACK_DELETED));
                } else {
                    this.useLeftText.setToolTipText(ResourceManager.getString((Object)ResourceKeyDiff.PUT_BACK_DELETED));
                    this.useRightText.setToolTipText(ResourceManager.getString((Object)ResourceKeyDiff.KEEP_DELETED));
                }
                string2 = bl ? this.leftText : this.rightText;
            }
        }
        this.textArea.setText(string2);
        this.textArea.setCaretPosition(0);
        this.useLeftText.setPreferredSize(new Dimension(10, 10));
        this.useRightText.setPreferredSize(new Dimension(10, 10));
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.useLeftText, "West");
        this.viewPort = new JViewport();
        this.viewPort.add(this.textArea);
        this.add((Component)this.viewPort, "Center");
        this.add((Component)this.useRightText, "East");
        this.useLeftText.addActionListener(this);
        this.useRightText.addActionListener(this);
        this.viewPort.setBackground(Color.white);
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                MergePanelItem.this.beforeDim = MergePanelItem.this.textArea.getPreferredSize();
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                Dimension dimension = MergePanelItem.this.textArea.getPreferredSize();
                if (((MergePanelItem)MergePanelItem.this).beforeDim.height != dimension.height) {
                    MergePanelItem.this.onComponentResized();
                }
            }
        });
    }

    public JViewport getViewPort() {
        return this.viewPort;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.onComponentResized();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = System.getProperty("line.separator");
        if (object == this.useLeftText) {
            switch (this.type) {
                case CONFLICT: 
                case WARNING_DELETE: 
                case NO_CONFLICT: {
                    String string2 = this.leftText;
                    this.textArea.setText(string2);
                    this.textArea.setCaretPosition(0);
                    break;
                }
                case WARNING_ORDER: {
                    String string3 = this.leftText + string + this.rightText;
                    this.textArea.setText(string3);
                    this.textArea.setCaretPosition(0);
                }
            }
        } else {
            switch (this.type) {
                case CONFLICT: 
                case WARNING_DELETE: 
                case NO_CONFLICT: {
                    String string4 = this.rightText;
                    this.textArea.setText(string4);
                    this.textArea.setCaretPosition(0);
                    break;
                }
                case WARNING_ORDER: {
                    String string5 = this.rightText + string + this.leftText;
                    this.textArea.setText(string5);
                    this.textArea.setCaretPosition(0);
                }
            }
        }
    }

    private void onComponentResized() {
        Dimension dimension = this.getPreferredSize();
        if (dimension.height >= this.initialPreferredHeight) {
            Container container;
            for (container = this; container != null; container = container.getParent()) {
                if (!(container instanceof MergeContentPanel)) continue;
                ((MergeContentPanel)container).setItemsBounds();
            }
            Dimension dimension2 = this.leftTextComponent.getPreferredSize();
            dimension2.height = dimension.height;
            this.leftTextComponent.setPreferredSize(dimension2);
            this.leftTextComponent.invalidate();
            for (container = this.leftTextComponent; container != null; container = container.getParent()) {
                if (!(container instanceof MergeContentPanel)) continue;
                ((MergeContentPanel)container).setItemsBounds();
            }
            dimension2 = this.rightTextComponent.getPreferredSize();
            dimension2.height = dimension.height;
            this.rightTextComponent.setPreferredSize(dimension2);
            this.rightTextComponent.invalidate();
            for (container = this.rightTextComponent; container != null; container = container.getParent()) {
                if (!(container instanceof MergeContentPanel)) continue;
                ((MergeContentPanel)container).setItemsBounds();
            }
        }
        this.invalidate();
    }

    @Override
    public void setViewPosition(int n) {
        Point point = this.viewPort.getViewPosition();
        this.viewPort.setViewPosition(new Point(n, point.y));
    }

    @Override
    public Dimension getPreferredSize() {
        Serializable serializable;
        if (this.initialPreferredHeight == -1) {
            serializable = this.textArea.getFont();
            FontMetrics fontMetrics = this.getFontMetrics((Font)serializable);
            int n = fontMetrics.getHeight();
            this.initialPreferredHeight = n * this.lineCount;
        }
        serializable = super.getPreferredSize();
        serializable.width = 100;
        serializable.height = Math.max(serializable.height, this.initialPreferredHeight);
        return serializable;
    }

    @Override
    public Dimension getRealPreferredSize() {
        return super.getPreferredSize();
    }

    @Override
    public String getContent() {
        return this.textArea.getText();
    }

    public static enum Type {
        CONFLICT,
        NO_CONFLICT,
        WARNING_ORDER,
        WARNING_DELETE;

    }
}

