/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.rule;

import eu.kliegr.ac1.data.Transaction;
import eu.kliegr.ac1.rule.RuleMultiItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Antecedent {
    private static final Logger LOGGER = Logger.getLogger(Antecedent.class.getName());
    private final ArrayList<RuleMultiItem> items;

    public Antecedent(ArrayList<RuleMultiItem> items) {
        this.items = items;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean succint) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        String sep = "";
        for (RuleMultiItem item : this.items) {
            sb.append(sep);
            sep = ",";
            sb.append(item.toString(true, false, succint));
        }
        sb.append("}");
        return sb.toString();
    }

    public Set<Transaction> getSupportingTransactions() throws NoSuchElementException {
        LOGGER.log(Level.FINE, "Computing supporting transaction for rule with {0} items and {1} values", new Object[]{this.getItems().size(), this.getItems().stream().mapToInt(x -> x.getAttributeValues().size()).sum()});
        if (this.getItems().isEmpty()) {
            return null;
        }
        Optional<Set> result = this.getItems().parallelStream().map(item -> item.getSupportingTransactions()).reduce((s, s1) -> {
            s.retainAll((Collection<?>)s1);
            return s;
        });
        return result.get();
    }

    public ArrayList<RuleMultiItem> getItems() {
        return this.items;
    }
}

