/*
 * Decompiled with CFR 0.152.
 */
package spreadsheet.xlsx.internal;

import java.util.Calendar;
import java.util.Date;
import spreadsheet.xlsx.XlsxDateSystem;

public enum DefaultDateSystem implements XlsxDateSystem
{
    X1900{
        private static final int INDEX_ORIGIN = 1;

        @Override
        public boolean isValidExcelDate(double value) {
            return value >= 1.0;
        }

        @Override
        public long getJavaDateInMillis(Calendar calendar, double date) {
            int datePart = (int)Math.floor(date);
            int timePart = (int)Math.round((date - (double)datePart) * 86400.0);
            calendar.clear();
            calendar.set(1900, 0, 1, 0, 0, 0);
            calendar.add(5, this.adjustLastDayOfFebruary1900(datePart) - 1);
            calendar.add(13, timePart);
            return calendar.getTimeInMillis();
        }

        @Override
        public Date getJavaDate(Calendar calendar, double date) {
            return new Date(this.getJavaDateInMillis(calendar, date));
        }

        private int adjustLastDayOfFebruary1900(int datePart) {
            return datePart < 61 ? datePart : datePart - 1;
        }
    }
    ,
    X1904{
        private static final int INDEX_ORIGIN = 0;

        @Override
        public boolean isValidExcelDate(double value) {
            return value >= 0.0;
        }

        @Override
        public long getJavaDateInMillis(Calendar calendar, double date) {
            int datePart = (int)Math.floor(date);
            int timePart = (int)Math.round((date - (double)datePart) * 86400.0);
            calendar.clear();
            calendar.set(1904, 0, 1, 0, 0, 0);
            calendar.add(5, datePart);
            calendar.add(13, timePart);
            return calendar.getTimeInMillis();
        }

        @Override
        public Date getJavaDate(Calendar calendar, double date) {
            return new Date(this.getJavaDateInMillis(calendar, date));
        }
    };

    private static final int NUMBER_OF_SECONDS_IN_DAY = 86400;
    public static final XlsxDateSystem.Factory FACTORY;

    static {
        FACTORY = date1904 -> date1904 ? X1904 : X1900;
    }
}

