/*
 * Decompiled with CFR 0.152.
 */
package pdftk.com.lowagie.text.pdf;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pdftk.com.lowagie.text.Document;
import pdftk.com.lowagie.text.DocumentException;
import pdftk.com.lowagie.text.ExceptionConverter;
import pdftk.com.lowagie.text.pdf.AcroFields;
import pdftk.com.lowagie.text.pdf.IntHashtable;
import pdftk.com.lowagie.text.pdf.PRIndirectReference;
import pdftk.com.lowagie.text.pdf.PdfArray;
import pdftk.com.lowagie.text.pdf.PdfDictionary;
import pdftk.com.lowagie.text.pdf.PdfDocument;
import pdftk.com.lowagie.text.pdf.PdfFormField;
import pdftk.com.lowagie.text.pdf.PdfIndirectReference;
import pdftk.com.lowagie.text.pdf.PdfName;
import pdftk.com.lowagie.text.pdf.PdfNumber;
import pdftk.com.lowagie.text.pdf.PdfObject;
import pdftk.com.lowagie.text.pdf.PdfReader;
import pdftk.com.lowagie.text.pdf.PdfString;
import pdftk.com.lowagie.text.pdf.PdfWriter;
import pdftk.com.lowagie.text.pdf.RandomAccessFileOrArray;
import pdftk.com.lowagie.text.pdf.SimpleBookmark;

class PdfCopyFieldsImp
extends PdfWriter {
    private static final PdfName iTextTag = new PdfName("_iTextTag_");
    private static final Integer zero = new Integer(0);
    ArrayList readers = new ArrayList();
    HashMap readers2intrefs = new HashMap();
    HashMap pages2intrefs = new HashMap();
    HashMap visited = new HashMap();
    ArrayList fields = new ArrayList();
    RandomAccessFileOrArray file;
    HashMap fieldTree = new HashMap();
    ArrayList pageRefs = new ArrayList();
    ArrayList pageDics = new ArrayList();
    PdfDictionary resources = new PdfDictionary();
    PdfDictionary form = null;
    protected List newBookmarks = null;
    boolean closing = false;
    Document nd = null;
    private HashMap tabOrder = null;
    private ArrayList calculationOrder = new ArrayList();
    private ArrayList calculationOrderRefs = null;
    protected static final HashMap widgetKeys = new HashMap();
    protected static final HashMap fieldKeys = new HashMap();

    PdfCopyFieldsImp(OutputStream os) throws DocumentException, IOException {
        this(os, '\u0000');
    }

    PdfCopyFieldsImp(OutputStream os, char pdfVersion) throws DocumentException, IOException {
        super(os);
        this.getPdfDocument().setWriter(this);
        if (pdfVersion != '\u0000') {
            super.setPdfVersion(pdfVersion);
        }
        this.nd = new Document();
        this.nd.addDocListener(this.getPdfDocument());
    }

    void propagate(PdfObject obj, PdfIndirectReference refo, boolean restricted) throws IOException {
        if (obj == null) {
            return;
        }
        if (obj instanceof PdfIndirectReference) {
            return;
        }
        switch (obj.type()) {
            case 6: 
            case 7: {
                PdfDictionary dic = (PdfDictionary)obj;
                for (PdfName key : dic.getKeys()) {
                    if (restricted && (key.equals(PdfName.PARENT) || key.equals(PdfName.KIDS))) continue;
                    PdfObject ob = dic.get(key);
                    if (ob != null && ob.isIndirect()) {
                        PRIndirectReference ind = (PRIndirectReference)ob;
                        if (this.setVisited(ind) || this.isPage(ind)) continue;
                        PdfIndirectReference ref = this.getNewReference(ind);
                        this.propagate(PdfReader.getPdfObjectRelease(ind), ref, restricted);
                        continue;
                    }
                    this.propagate(ob, null, restricted);
                }
                break;
            }
            case 5: {
                ArrayList list = ((PdfArray)obj).getArrayList();
                for (PdfObject ob : list) {
                    if (ob != null && ob.isIndirect()) {
                        PRIndirectReference ind = (PRIndirectReference)ob;
                        if (this.isVisited(ind) || this.isPage(ind)) continue;
                        PdfIndirectReference ref = this.getNewReference(ind);
                        this.propagate(PdfReader.getPdfObjectRelease(ind), ref, restricted);
                        continue;
                    }
                    this.propagate(ob, null, restricted);
                }
                break;
            }
            case 10: {
                throw new RuntimeException("Reference pointing to reference.");
            }
        }
    }

    private void adjustTabOrder(PdfArray annots, PdfIndirectReference ind, PdfNumber nn) {
        int v = nn.intValue();
        ArrayList<Integer> t = (ArrayList<Integer>)this.tabOrder.get(annots);
        if (t == null) {
            t = new ArrayList<Integer>();
            int size = annots.size() - 1;
            for (int k = 0; k < size; ++k) {
                t.add(zero);
            }
            t.add(new Integer(v));
            this.tabOrder.put(annots, t);
            annots.add(ind);
        } else {
            int size;
            for (int k = size = t.size() - 1; k >= 0; --k) {
                if ((Integer)t.get(k) > v) continue;
                t.add(k + 1, new Integer(v));
                annots.getArrayList().add(k + 1, ind);
                size = -2;
                break;
            }
            if (size != -2) {
                t.add(0, new Integer(v));
                annots.getArrayList().add(0, ind);
            }
        }
    }

    protected PdfArray branchForm(HashMap level, PdfIndirectReference parent, String fname) throws IOException {
        PdfArray arr = new PdfArray();
        for (String name : level.keySet()) {
            Object obj = level.get(name);
            PdfIndirectReference ind = this.getPdfIndirectReference();
            PdfDictionary dic = new PdfDictionary();
            if (parent != null) {
                dic.put(PdfName.PARENT, parent);
            }
            dic.put(PdfName.T, new PdfString(name, "UTF-16"));
            String fname2 = fname + "." + name;
            int coidx = this.calculationOrder.indexOf(fname2);
            if (coidx >= 0) {
                this.calculationOrderRefs.set(coidx, ind);
            }
            if (obj instanceof HashMap) {
                dic.put(PdfName.KIDS, this.branchForm((HashMap)obj, ind, fname2));
                arr.add(ind);
                this.addToBody((PdfObject)dic, ind);
                continue;
            }
            ArrayList list = (ArrayList)obj;
            dic.mergeDifferent((PdfDictionary)list.get(0));
            if (list.size() == 3) {
                dic.mergeDifferent((PdfDictionary)list.get(2));
                int page = (Integer)list.get(1);
                PdfDictionary pageDic = (PdfDictionary)this.pageDics.get(page - 1);
                PdfArray annots = (PdfArray)PdfReader.getPdfObject(pageDic.get(PdfName.ANNOTS));
                if (annots == null) {
                    annots = new PdfArray();
                    pageDic.put(PdfName.ANNOTS, annots);
                }
                PdfNumber nn = (PdfNumber)dic.get(iTextTag);
                dic.remove(iTextTag);
                this.adjustTabOrder(annots, ind, nn);
            } else {
                PdfArray kids = new PdfArray();
                for (int k = 1; k < list.size(); k += 2) {
                    int page = (Integer)list.get(k);
                    PdfDictionary pageDic = (PdfDictionary)this.pageDics.get(page - 1);
                    PdfArray annots = (PdfArray)PdfReader.getPdfObject(pageDic.get(PdfName.ANNOTS));
                    if (annots == null) {
                        annots = new PdfArray();
                        pageDic.put(PdfName.ANNOTS, annots);
                    }
                    PdfDictionary widget = new PdfDictionary();
                    widget.merge((PdfDictionary)list.get(k + 1));
                    widget.put(PdfName.PARENT, ind);
                    PdfNumber nn = (PdfNumber)widget.get(iTextTag);
                    widget.remove(iTextTag);
                    PdfIndirectReference wref = this.addToBody(widget).getIndirectReference();
                    this.adjustTabOrder(annots, wref, nn);
                    kids.add(wref);
                    this.propagate(widget, null, false);
                }
                dic.put(PdfName.KIDS, kids);
            }
            arr.add(ind);
            this.addToBody((PdfObject)dic, ind);
            this.propagate(dic, null, false);
        }
        return arr;
    }

    protected void createAcroForms() throws IOException {
        if (this.fieldTree.size() == 0) {
            return;
        }
        this.form = new PdfDictionary();
        this.form.put(PdfName.DR, this.resources);
        this.propagate(this.resources, null, false);
        this.form.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
        this.tabOrder = new HashMap();
        this.calculationOrderRefs = new ArrayList(this.calculationOrder);
        this.form.put(PdfName.FIELDS, this.branchForm(this.fieldTree, null, ""));
        PdfArray co = new PdfArray();
        for (int k = 0; k < this.calculationOrderRefs.size(); ++k) {
            Object obj = this.calculationOrderRefs.get(k);
            if (!(obj instanceof PdfIndirectReference)) continue;
            co.add((PdfIndirectReference)obj);
        }
        if (co.size() > 0) {
            this.form.put(PdfName.CO, co);
        }
    }

    @Override
    public void close() {
        if (this.closing) {
            super.close();
            return;
        }
        this.closing = true;
        try {
            this.closeIt();
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeIt() throws DocumentException, IOException {
        int page;
        PdfReader reader2;
        int r;
        for (int k = 0; k < this.readers.size(); ++k) {
            ((PdfReader)this.readers.get(k)).removeFields();
        }
        for (r = 0; r < this.readers.size(); ++r) {
            reader2 = (PdfReader)this.readers.get(r);
            for (page = 1; page <= reader2.getNumberOfPages(); ++page) {
                this.pageRefs.add(this.getNewReference(reader2.getPageOrigRef(page)));
                this.pageDics.add(reader2.getPageN(page));
            }
        }
        this.mergeFields();
        this.createAcroForms();
        for (r = 0; r < this.readers.size(); ++r) {
            reader2 = (PdfReader)this.readers.get(r);
            for (page = 1; page <= reader2.getNumberOfPages(); ++page) {
                PdfDictionary dic = reader2.getPageN(page);
                PdfIndirectReference pageRef = this.getNewReference(reader2.getPageOrigRef(page));
                PdfIndirectReference parent = this.getRoot().addPageRef(pageRef);
                dic.put(PdfName.PARENT, parent);
                this.propagate(dic, pageRef, false);
            }
        }
        for (PdfReader reader2 : this.readers2intrefs.keySet()) {
            try {
                this.file = reader2.getSafeFile();
                this.file.reOpen();
                IntHashtable t = (IntHashtable)this.readers2intrefs.get(reader2);
                int[] keys = t.toOrderedKeys();
                for (int k = 0; k < keys.length; ++k) {
                    PRIndirectReference ref = new PRIndirectReference(reader2, keys[k]);
                    this.addToBody(PdfReader.getPdfObjectRelease(ref), t.get(keys[k]));
                }
            }
            finally {
                try {
                    this.file.close();
                    reader2.close();
                }
                catch (Exception exception) {}
            }
        }
        this.getPdfDocument().close();
    }

    void addPageOffsetToField(HashMap fd, int pageOffset) {
        if (pageOffset == 0) {
            return;
        }
        Iterator it = fd.values().iterator();
        while (it.hasNext()) {
            ArrayList page = ((AcroFields.Item)it.next()).page;
            for (int k = 0; k < page.size(); ++k) {
                page.set(k, new Integer((Integer)page.get(k) + pageOffset));
            }
        }
    }

    void createWidgets(ArrayList list, AcroFields.Item item) {
        for (int k = 0; k < item.merged.size(); ++k) {
            list.add(item.page.get(k));
            PdfDictionary merged = (PdfDictionary)item.merged.get(k);
            PdfObject dr = merged.get(PdfName.DR);
            if (dr != null) {
                PdfFormField.mergeResources(this.resources, (PdfDictionary)PdfReader.getPdfObject(dr));
            }
            PdfDictionary widget = new PdfDictionary();
            for (PdfName key : merged.getKeys()) {
                if (!widgetKeys.containsKey(key)) continue;
                widget.put(key, merged.get(key));
            }
            widget.put(iTextTag, new PdfNumber((Integer)item.tabOrder.get(k) + 1));
            list.add(widget);
        }
    }

    void mergeField(String name, AcroFields.Item item) {
        Object obj;
        String s;
        HashMap map;
        block15: {
            map = this.fieldTree;
            StringTokenizer tk = new StringTokenizer(name, ".");
            if (!tk.hasMoreTokens()) {
                return;
            }
            while (true) {
                s = tk.nextToken();
                obj = map.get(s);
                if (!tk.hasMoreTokens()) break block15;
                if (obj == null) {
                    obj = new HashMap();
                    map.put(s, obj);
                    map = (HashMap)obj;
                    continue;
                }
                if (!(obj instanceof HashMap)) break;
                map = (HashMap)obj;
            }
            return;
        }
        if (obj instanceof HashMap) {
            return;
        }
        PdfDictionary merged = (PdfDictionary)item.merged.get(0);
        if (obj == null) {
            PdfDictionary field = new PdfDictionary();
            for (PdfName key : merged.getKeys()) {
                if (!fieldKeys.containsKey(key)) continue;
                field.put(key, merged.get(key));
            }
            ArrayList<PdfDictionary> list = new ArrayList<PdfDictionary>();
            list.add(field);
            this.createWidgets(list, item);
            map.put(s, list);
        } else {
            ArrayList list = (ArrayList)obj;
            PdfDictionary field = (PdfDictionary)list.get(0);
            PdfName type1 = (PdfName)field.get(PdfName.FT);
            PdfName type2 = (PdfName)merged.get(PdfName.FT);
            if (type1 == null || !type1.equals(type2)) {
                return;
            }
            int flag1 = 0;
            PdfObject f1 = field.get(PdfName.FF);
            if (f1 != null && f1.isNumber()) {
                flag1 = ((PdfNumber)f1).intValue();
            }
            int flag2 = 0;
            PdfObject f2 = merged.get(PdfName.FF);
            if (f2 != null && f2.isNumber()) {
                flag2 = ((PdfNumber)f2).intValue();
            }
            if (type1.equals(PdfName.BTN)) {
                if (((flag1 ^ flag2) & 0x10000) != 0) {
                    return;
                }
                if ((flag1 & 0x10000) == 0 && ((flag1 ^ flag2) & 0x8000) != 0) {
                    return;
                }
            } else if (type1.equals(PdfName.CH) && ((flag1 ^ flag2) & 0x20000) != 0) {
                return;
            }
            this.createWidgets(list, item);
        }
    }

    void mergeWithMaster(HashMap fd) {
        for (String name : fd.keySet()) {
            this.mergeField(name, (AcroFields.Item)fd.get(name));
        }
    }

    void mergeFields() {
        int pageOffset = 0;
        for (int k = 0; k < this.fields.size(); ++k) {
            HashMap fd = ((AcroFields)this.fields.get(k)).getFields();
            this.addPageOffsetToField(fd, pageOffset);
            this.mergeWithMaster(fd);
            pageOffset += ((PdfReader)this.readers.get(k)).getNumberOfPages();
        }
    }

    @Override
    public PdfIndirectReference getPageReference(int page) {
        return (PdfIndirectReference)this.pageRefs.get(page - 1);
    }

    @Override
    protected PdfDictionary getCatalog(PdfIndirectReference rootObj) throws DocumentException {
        try {
            PdfDocument.PdfCatalog cat = this.getPdfDocument().getCatalog(rootObj);
            if (this.form != null) {
                PdfIndirectReference ref = this.addToBody(this.form).getIndirectReference();
                cat.put(PdfName.ACROFORM, ref);
            }
            if (this.newBookmarks == null || this.newBookmarks.size() == 0) {
                return cat;
            }
            PdfDictionary top = new PdfDictionary();
            PdfIndirectReference topRef = this.getPdfIndirectReference();
            Object[] kids = SimpleBookmark.iterateOutlines(this, topRef, this.newBookmarks, false);
            top.put(PdfName.FIRST, (PdfIndirectReference)kids[0]);
            top.put(PdfName.LAST, (PdfIndirectReference)kids[1]);
            top.put(PdfName.COUNT, new PdfNumber((Integer)kids[2]));
            this.addToBody((PdfObject)top, topRef);
            cat.put(PdfName.OUTLINES, topRef);
            return cat;
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    protected PdfIndirectReference getNewReference(PRIndirectReference ref) {
        return new PdfIndirectReference(0, this.getNewObjectNumber(ref.getReader(), ref.getNumber(), 0));
    }

    @Override
    protected int getNewObjectNumber(PdfReader reader, int number, int generation) {
        IntHashtable refs = (IntHashtable)this.readers2intrefs.get(reader);
        int n = refs.get(number);
        if (n == 0) {
            n = this.getIndirectReferenceNumber();
            refs.put(number, n);
        }
        return n;
    }

    protected boolean isVisited(PdfReader reader, int number, int generation) {
        IntHashtable refs = (IntHashtable)this.readers2intrefs.get(reader);
        return refs.containsKey(number);
    }

    protected boolean isVisited(PRIndirectReference ref) {
        IntHashtable refs = (IntHashtable)this.visited.get(ref.getReader());
        return refs.containsKey(ref.getNumber());
    }

    protected boolean setVisited(PRIndirectReference ref) {
        IntHashtable refs = (IntHashtable)this.visited.get(ref.getReader());
        return refs.put(ref.getNumber(), 1) != 0;
    }

    protected boolean isPage(PRIndirectReference ref) {
        IntHashtable refs = (IntHashtable)this.pages2intrefs.get(ref.getReader());
        return refs.containsKey(ref.getNumber());
    }

    @Override
    RandomAccessFileOrArray getReaderFile(PdfReader reader) {
        return this.file;
    }

    public void setOutlines(List outlines) {
        this.newBookmarks = outlines;
    }

    public void openDoc() {
        if (!this.nd.isOpen()) {
            this.nd.open();
        }
    }

    static {
        Integer one = new Integer(1);
        widgetKeys.put(PdfName.SUBTYPE, one);
        widgetKeys.put(PdfName.CONTENTS, one);
        widgetKeys.put(PdfName.RECT, one);
        widgetKeys.put(PdfName.NM, one);
        widgetKeys.put(PdfName.M, one);
        widgetKeys.put(PdfName.F, one);
        widgetKeys.put(PdfName.BS, one);
        widgetKeys.put(PdfName.BORDER, one);
        widgetKeys.put(PdfName.AP, one);
        widgetKeys.put(PdfName.AS, one);
        widgetKeys.put(PdfName.C, one);
        widgetKeys.put(PdfName.A, one);
        widgetKeys.put(PdfName.STRUCTPARENT, one);
        widgetKeys.put(PdfName.OC, one);
        widgetKeys.put(PdfName.H, one);
        widgetKeys.put(PdfName.MK, one);
        widgetKeys.put(PdfName.DA, one);
        widgetKeys.put(PdfName.Q, one);
        fieldKeys.put(PdfName.AA, one);
        fieldKeys.put(PdfName.FT, one);
        fieldKeys.put(PdfName.TU, one);
        fieldKeys.put(PdfName.TM, one);
        fieldKeys.put(PdfName.FF, one);
        fieldKeys.put(PdfName.V, one);
        fieldKeys.put(PdfName.DV, one);
        fieldKeys.put(PdfName.DS, one);
        fieldKeys.put(PdfName.RV, one);
        fieldKeys.put(PdfName.OPT, one);
        fieldKeys.put(PdfName.MAXLEN, one);
        fieldKeys.put(PdfName.TI, one);
        fieldKeys.put(PdfName.I, one);
        fieldKeys.put(PdfName.LOCK, one);
        fieldKeys.put(PdfName.SV, one);
    }
}

