/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.epidemiology.casetocase.periodpriors;

import dr.evomodel.epidemiology.casetocase.periodpriors.AbstractPeriodPriorDistribution;
import dr.inference.loggers.LogColumn;
import dr.inference.model.Parameter;
import dr.math.distributions.NormalDistribution;
import dr.math.distributions.NormalGammaDistribution;
import dr.math.functionEval.GammaFunction;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.TDistributionImpl;

public class NormalPeriodPriorDistribution
extends AbstractPeriodPriorDistribution {
    public static final String NORMAL = "normalPeriodPriorDistribution";
    public static final String LOG = "log";
    public static final String ID = "id";
    public static final String MU = "mu";
    public static final String LAMBDA = "lambda";
    public static final String ALPHA = "alpha";
    public static final String BETA = "beta";
    private NormalGammaDistribution hyperprior;
    private Parameter posteriorMean;
    private Parameter posteriorBeta;
    private Parameter posteriorExpectedPrecision;
    double normalApproximationThreshold = 30.0;
    private ArrayList<Double> dataValues;
    private double[] currentParameters;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newBooleanRule("log", true), AttributeRule.newStringRule("id", false), AttributeRule.newDoubleRule("mu", false), AttributeRule.newDoubleRule("lambda", false), AttributeRule.newDoubleRule("alpha", false), AttributeRule.newDoubleRule("beta", false)};

        @Override
        public String getParserName() {
            return NormalPeriodPriorDistribution.NORMAL;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = (String)xMLObject.getAttribute(NormalPeriodPriorDistribution.ID);
            double d = xMLObject.getDoubleAttribute(NormalPeriodPriorDistribution.MU);
            double d2 = xMLObject.getDoubleAttribute(NormalPeriodPriorDistribution.LAMBDA);
            double d3 = xMLObject.getDoubleAttribute(NormalPeriodPriorDistribution.ALPHA);
            double d4 = xMLObject.getDoubleAttribute(NormalPeriodPriorDistribution.BETA);
            boolean bl = xMLObject.hasAttribute(NormalPeriodPriorDistribution.LOG) ? xMLObject.getBooleanAttribute(NormalPeriodPriorDistribution.LOG) : false;
            return new NormalPeriodPriorDistribution(string, bl, d, d2, d3, d4);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Calculates the probability of a set of doubles being drawn from the prior posterior distributionof a normal distribution of unknown mean and variance";
        }

        @Override
        public Class getReturnType() {
            return NormalPeriodPriorDistribution.class;
        }
    };

    public NormalPeriodPriorDistribution(String string, boolean bl, NormalGammaDistribution normalGammaDistribution) {
        super(string, bl);
        this.hyperprior = normalGammaDistribution;
        this.posteriorBeta = new Parameter.Default(1);
        this.posteriorMean = new Parameter.Default(1);
        this.posteriorExpectedPrecision = new Parameter.Default(1);
        this.addVariable(this.posteriorBeta);
        this.addVariable(this.posteriorMean);
        this.addVariable(this.posteriorExpectedPrecision);
    }

    public NormalPeriodPriorDistribution(String string, boolean bl, double d, double d2, double d3, double d4) {
        this(string, bl, new NormalGammaDistribution(d, d2, d3, d4));
        this.reset();
    }

    @Override
    public void reset() {
        this.dataValues = new ArrayList();
        this.currentParameters = this.hyperprior.getParameters();
        this.logL = 0.0;
    }

    @Override
    public double calculateLogPosteriorProbability(double d, double d2) {
        double d3 = this.calculateLogPosteriorPredictiveProbability(d);
        if (d2 != Double.NEGATIVE_INFINITY) {
            d3 -= this.calculateLogPosteriorPredictiveCDF(d2, true);
        }
        this.logL += d3;
        this.update(d);
        return d3;
    }

    @Override
    public double calculateLogPosteriorCDF(double d, boolean bl) {
        return this.calculateLogPosteriorPredictiveCDF(d, bl);
    }

    public double calculateLogPosteriorPredictiveProbability(double d) {
        double d2;
        double d3 = this.currentParameters[0];
        double d4 = Math.sqrt(this.currentParameters[3] * (this.currentParameters[1] + 1.0) / (this.currentParameters[2] * this.currentParameters[1]));
        double d5 = (d - d3) / d4;
        if (2.0 * this.currentParameters[2] <= this.normalApproximationThreshold) {
            TDistributionImpl tDistributionImpl = new TDistributionImpl(2.0 * this.currentParameters[2]);
            d2 = Math.log(tDistributionImpl.density(d5));
        } else {
            d2 = NormalDistribution.logPdf(d5, 0.0, 1.0);
        }
        return d2;
    }

    public double calculateLogPosteriorPredictiveCDF(double d, boolean bl) {
        double d2;
        double d3 = this.currentParameters[0];
        double d4 = Math.sqrt(this.currentParameters[3] * (this.currentParameters[1] + 1.0) / (this.currentParameters[2] * this.currentParameters[1]));
        double d5 = (d - d3) / d4;
        if (2.0 * this.currentParameters[2] <= this.normalApproximationThreshold) {
            TDistributionImpl tDistributionImpl = new TDistributionImpl(2.0 * this.currentParameters[2]);
            try {
                d2 = bl ? Math.log(tDistributionImpl.cumulativeProbability(-d5)) : Math.log(tDistributionImpl.cumulativeProbability(d5));
            }
            catch (MathException mathException) {
                throw new RuntimeException(mathException.toString());
            }
        } else {
            d2 = bl ? NormalDistribution.standardCDF(-d5, true) : NormalDistribution.standardCDF(d5, true);
        }
        return d2;
    }

    private void update(double d) {
        this.dataValues.add(d);
        double[] dArray = this.hyperprior.getParameters();
        double d2 = dArray[1];
        double d3 = this.currentParameters[0];
        double d4 = this.currentParameters[1];
        double d5 = this.currentParameters[2];
        double d6 = this.currentParameters[3];
        double d7 = this.dataValues.size();
        double d8 = (d - d3) / (d2 + d7) + d3;
        double d9 = d4 + 1.0;
        double d10 = d5 + 0.5;
        double d11 = d6 + d4 * Math.pow(d - d3, 2.0) / (2.0 * (d4 + 1.0));
        this.posteriorMean.setParameterValue(0, d8);
        this.posteriorBeta.setParameterValue(0, d11);
        this.posteriorExpectedPrecision.setParameterValue(0, d10 / d11);
        this.currentParameters = new double[]{d8, d9, d10, d11};
    }

    @Override
    public double calculateLogLikelihood(double[] dArray) {
        int n = dArray.length;
        double[] dArray2 = this.hyperprior.getParameters();
        double d = dArray2[0];
        double d2 = dArray2[1];
        double d3 = dArray2[2];
        double d4 = dArray2[3];
        double d5 = d2 + (double)n;
        double d6 = d3 + (double)(n / 2);
        double d7 = 0.0;
        double[] dArray3 = dArray;
        int n2 = dArray3.length;
        for (int i = 0; i < n2; ++i) {
            Double d8 = dArray3[i];
            d7 += d8.doubleValue();
        }
        double d9 = d7 / (double)n;
        double d10 = 0.0;
        double[] dArray4 = dArray;
        int n3 = dArray4.length;
        for (int i = 0; i < n3; ++i) {
            Double d11 = dArray4[i];
            d10 += Math.pow(d11 - d9, 2.0);
        }
        this.posteriorMean.setParameterValue(0, (d2 * d + d7) / (d2 + (double)n));
        double d12 = d4 + 0.5 * d10 + d2 * (double)n * Math.pow(d9 - d, 2.0) / (2.0 * (d2 + (double)n));
        this.posteriorBeta.setParameterValue(0, d12);
        this.posteriorExpectedPrecision.setParameterValue(0, d6 / d12);
        this.logL = GammaFunction.logGamma(d6) - GammaFunction.logGamma(d3) + d3 * Math.log(d4) - d6 * Math.log(d12) + 0.5 * Math.log(d2) - 0.5 * Math.log(d5) - (double)(n / 2) * Math.log(Math.PI * 2);
        return this.logL;
    }

    @Override
    public LogColumn[] getColumns() {
        ArrayList<LogColumn> arrayList = new ArrayList<LogColumn>(Arrays.asList(super.getColumns()));
        arrayList.add(new LogColumn.Abstract(this.getModelName() + "_posteriorMean"){

            @Override
            protected String getFormattedValue() {
                return String.valueOf(NormalPeriodPriorDistribution.this.posteriorMean.getParameterValue(0));
            }
        });
        arrayList.add(new LogColumn.Abstract(this.getModelName() + "_posteriorBeta"){

            @Override
            protected String getFormattedValue() {
                return String.valueOf(NormalPeriodPriorDistribution.this.posteriorBeta.getParameterValue(0));
            }
        });
        arrayList.add(new LogColumn.Abstract(this.getModelName() + "_posteriorExpectedPrecision"){

            @Override
            protected String getFormattedValue() {
                return String.valueOf(NormalPeriodPriorDistribution.this.posteriorExpectedPrecision.getParameterValue(0));
            }
        });
        return arrayList.toArray(new LogColumn[arrayList.size()]);
    }
}

