/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;

public class DeltaMixOperator
extends AbstractAdaptableOperator {
    private Parameter parameter = null;
    private final int[] parameterWeights;
    private double delta = 0.2;

    public DeltaMixOperator(Parameter parameter, double d) {
        super(AdaptationMode.ADAPTATION_ON);
        this.parameter = parameter;
        this.delta = d;
        this.setWeight(1.0);
        this.parameterWeights = new int[parameter.getDimension()];
        for (int i = 0; i < this.parameterWeights.length; ++i) {
            this.parameterWeights[i] = 1;
        }
    }

    public DeltaMixOperator(Parameter parameter, int[] nArray, double d, double d2, AdaptationMode adaptationMode) {
        super(adaptationMode);
        this.parameter = parameter;
        this.delta = d;
        this.setWeight(d2);
        this.parameterWeights = nArray;
    }

    @Override
    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public final double doOperation() {
        int n;
        int n2 = this.parameter.getDimension();
        int n3 = n = MathUtils.nextInt(n2);
        while (n == n3) {
            n3 = MathUtils.nextInt(n2);
        }
        double d = this.parameter.getParameterValue(n);
        double d2 = this.parameter.getParameterValue(n3);
        double d3 = MathUtils.nextDouble() * this.delta * d;
        d2 = this.parameterWeights[n] != this.parameterWeights[n3] ? (d2 += d3 * (double)this.parameterWeights[n] / (double)this.parameterWeights[n3]) : (d2 += d3);
        this.parameter.setParameterValue(n, d -= d3);
        this.parameter.setParameterValue(n3, d2);
        return Math.log(d2 / (d + d3));
    }

    @Override
    public final String getOperatorName() {
        return this.parameter.getParameterName();
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.delta) - Math.log(1.0 - this.delta);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.delta = 1.0 / (1.0 + Math.exp(-d));
    }

    @Override
    public double getRawParameter() {
        return this.delta;
    }

    @Override
    public String getAdaptableParameterName() {
        return "delta";
    }

    public String toString() {
        return this.getOperatorName() + "(windowsize=" + this.delta + ")";
    }
}

