/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.operators.MCMCOperator;
import dr.inference.operators.OperatorSchedule;
import dr.math.MathUtils;
import java.util.List;
import java.util.Vector;

public class CombinedOperatorSchedule
implements OperatorSchedule {
    List<OperatorSchedule> operatorSchedules = new Vector<OperatorSchedule>();

    public void addOperatorSchedule(OperatorSchedule operatorSchedule) {
        this.operatorSchedules.add(operatorSchedule);
    }

    public int getScheduleCount() {
        return this.operatorSchedules.size();
    }

    @Override
    public int getNextOperatorIndex() {
        int n = MathUtils.nextInt(this.operatorSchedules.size());
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += this.operatorSchedules.get(i).getOperatorCount();
        }
        return n2 + this.operatorSchedules.get(n).getNextOperatorIndex();
    }

    public void reset() {
        for (OperatorSchedule operatorSchedule : this.operatorSchedules) {
            for (int i = 0; i < operatorSchedule.getOperatorCount(); ++i) {
                operatorSchedule.getOperator(i).reset();
            }
        }
    }

    @Override
    public int getOperatorCount() {
        int n = 0;
        for (OperatorSchedule operatorSchedule : this.operatorSchedules) {
            n += operatorSchedule.getOperatorCount();
        }
        return n;
    }

    @Override
    public MCMCOperator getOperator(int n) {
        for (OperatorSchedule operatorSchedule : this.operatorSchedules) {
            int n2 = operatorSchedule.getOperatorCount();
            if (n < n2) {
                return operatorSchedule.getOperator(n);
            }
            n -= n2;
        }
        return null;
    }

    @Override
    public void addOperator(MCMCOperator mCMCOperator) {
        System.err.println("ERROR: addOperator() should not be called on CombinedOperatorSchedule, use individual operator schedules to add operators. This call will have no affect!");
    }

    @Override
    public void addOperators(List<MCMCOperator> list) {
        System.err.println("ERROR: addOperators() should not be called on CombinedOperatorSchedule, use individual operator schedules to add operators. This call will have no affect!");
    }

    @Override
    public void operatorsHasBeenUpdated() {
        for (OperatorSchedule operatorSchedule : this.operatorSchedules) {
            operatorSchedule.operatorsHasBeenUpdated();
        }
    }

    @Override
    public OperatorSchedule.OptimizationTransform getOptimizationTransform() {
        if (this.operatorSchedules.size() > 0) {
            return this.operatorSchedules.get(0).getOptimizationTransform();
        }
        return null;
    }

    @Override
    public long getMinimumAcceptAndRejectCount() {
        long l = Long.MAX_VALUE;
        for (OperatorSchedule operatorSchedule : this.operatorSchedules) {
            if (operatorSchedule.getMinimumAcceptAndRejectCount() >= l) continue;
            l = operatorSchedule.getMinimumAcceptAndRejectCount();
        }
        return l;
    }
}

