/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.math.GammaFunction;
import dr.math.distributions.MultivariateDistribution;
import dr.math.distributions.WishartStatistics;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.math.matrixAlgebra.Matrix;

public class InverseWishartDistribution
implements MultivariateDistribution,
WishartStatistics {
    public static final String TYPE = "InverseWishart";
    private double df;
    private int dim;
    private double[][] scaleMatrix;
    private Matrix S;
    private double logNormalizationConstant;

    public InverseWishartDistribution(double d, double[][] dArray) {
        this.df = d;
        this.scaleMatrix = dArray;
        this.dim = dArray.length;
        this.S = new Matrix(dArray);
        this.computeNormalizationConstant();
    }

    private void computeNormalizationConstant() {
        this.logNormalizationConstant = 0.0;
        try {
            this.logNormalizationConstant = this.df / 2.0 * Math.log(new Matrix(this.scaleMatrix).determinant());
        }
        catch (IllegalDimension illegalDimension) {
            illegalDimension.printStackTrace();
        }
        this.logNormalizationConstant -= this.df * (double)this.dim / 2.0 * Math.log(2.0);
        this.logNormalizationConstant -= (double)(this.dim * (this.dim - 1)) / 4.0 * Math.log(Math.PI);
        for (int i = 1; i <= this.dim; ++i) {
            this.logNormalizationConstant -= GammaFunction.lnGamma((this.df + 1.0 - (double)i) / 2.0);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public double[][] getScaleMatrix() {
        return this.scaleMatrix;
    }

    @Override
    public double[] getMean() {
        return null;
    }

    @Override
    public double getDF() {
        return this.df;
    }

    public double[][] scaleMatrix() {
        return this.scaleMatrix;
    }

    @Override
    public double logPdf(double[] dArray) {
        Matrix matrix = new Matrix(dArray, this.dim, this.dim);
        double d = 0.0;
        try {
            d = Math.log(matrix.determinant());
            d *= -0.5;
            d *= this.df + (double)this.dim + 1.0;
            Matrix matrix2 = this.S.product(matrix.inverse());
            for (int i = 0; i < this.dim; ++i) {
                d -= 0.5 * matrix2.component(i, i);
            }
        }
        catch (IllegalDimension illegalDimension) {
            illegalDimension.printStackTrace();
        }
        return d += this.logNormalizationConstant;
    }
}

