## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(PeruAPIs)
library(ggplot2)
library(dplyr)

## ----peru-gdp,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----


peru_gdp <- head(get_peru_gdp())

print(peru_gdp)


## ----peru-life-expectancy,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----

peru_life_expectancy <- head(get_peru_life_expectancy())

print(peru_life_expectancy)


## ----peru-population,echo = TRUE,message = FALSE,warning = FALSE,results = 'markup'----

peru_population <- head(get_peru_population())

print(peru_population)


## ----peruapis-plot, message=FALSE, warning=FALSE, fig.width=8, fig.height=5----

# Example of scatter plot: Relationship between Blank Votes and HDI
peru_blank_votes_df %>%
  ggplot(aes(x = votes, y = HDI)) +
  geom_point(color = "steelblue", alpha = 0.7) +
  geom_smooth(method = "lm", se = TRUE, color = "darkred", linetype = "dashed") +
  labs(
    title = "Relationship between Blank Votes and Human Development Index (HDI) in Peru",
    x = "Proportion of Blank Votes",
    y = "Human Development Index (HDI)"
  ) +
  theme_minimal()




