/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.simprocs;

import umontreal.iro.lecuyer.simevents.eventlist.EventList;
import umontreal.iro.lecuyer.simprocs.InterpretedThread;
import umontreal.iro.lecuyer.simprocs.ProcessSimulator;
import umontreal.iro.lecuyer.simprocs.ResumeEvent;
import umontreal.iro.lecuyer.simprocs.SimProcess;

public class DSOLProcessSimulator
extends ProcessSimulator {
    public void init() {
        super.init();
    }

    public void init(EventList eventList) {
        super.init(eventList);
    }

    public ResumeEvent createControlEvent(SimProcess simProcess) {
        return new ResumeEvent(this, new InterpretedThread(simProcess));
    }

    public void delay(SimProcess simProcess, double d) {
        if (simProcess.scheduledEvent() == null) {
            throw new IllegalStateException("Calling delay() for a dead process");
        }
        if (this.currentProcess != simProcess) {
            throw new IllegalStateException("Calling delay() for a process not in EXECUTING state");
        }
        if (d < 0.0) {
            throw new IllegalArgumentException("Calling delay() with negative delay");
        }
        simProcess.scheduledEvent().schedule(d);
        simProcess.suspend();
    }

    public void suspend(SimProcess simProcess) {
        if (simProcess.scheduledEvent() == null) {
            throw new IllegalStateException("Calling suspend() for a dead process");
        }
        if (this.currentProcess == simProcess) {
            ((ResumeEvent)simProcess.scheduledEvent()).target().suspend();
            return;
        }
        if (simProcess.scheduledEvent().time() >= 0.0) {
            simProcess.scheduledEvent().cancel();
            simProcess.scheduledEvent().setTime(-10.0);
            return;
        }
        if (simProcess.scheduledEvent().time() == -20.0) {
            throw new IllegalStateException("Calling suspend() for a process in INITIAL state");
        }
        throw new IllegalStateException("Calling suspend() for a suspended process");
    }

    public void kill(SimProcess simProcess) {
        if (simProcess.scheduledEvent() == null) {
            throw new IllegalStateException("Calling kill() on a DEAD process");
        }
        if (this.currentProcess == simProcess) {
            simProcess.setScheduledEvent(null);
            InterpretedThread interpretedThread = ((ResumeEvent)simProcess.scheduledEvent()).target();
            ((ResumeEvent)simProcess.scheduledEvent()).setTarget(null);
            interpretedThread.suspend();
            return;
        }
        if (simProcess.scheduledEvent().time() >= 0.0) {
            simProcess.scheduledEvent().cancel();
        }
        simProcess.setScheduledEvent(null);
        ((ResumeEvent)simProcess.scheduledEvent()).setTarget(null);
    }

    public void killAll() {
    }
}

