*-------------------------------------------------------------------------*
*                                                                          
*                     SPSS SETUP FILE FOR ICPSR 04347
*          CURRENT POPULATION SURVEY, 2004: CELL PHONE SUPPLEMENT
*                             (DATASET 0001: )
* 
*
*  SPSS setup sections are provided for the ASCII version of this data
*  collection.  These sections are listed below:
*
*  DATA LIST:  assigns the name, type, decimal specification (if any),
*  and specifies the beginning and ending column locations for each
*  variable in the data file. Users must replace the "data-filename"
*  in the DATA LIST statement with a filename specifying the directory
*  on the user's computer system in which the downloaded and unzipped
*  data file is physically located (e.g., "c:\temp\04347-0001-data.txt").
*
*  VARIABLE LABELS:  assigns descriptive labels to all variables.
*  Labels and variable names may be identical for some data files.
*
*  MISSING VALUES: declares user-defined missing values. Not all
*  variables in this data set necessarily have user-defined missing
*  values. These values can be treated specially in data transformations,
*  statistical calculations, and case selection.
*
*  VALUE LABELS: assigns descriptive labels to codes found in the data
*  file.  Not all codes necessarily have assigned value labels.
*
*  NOTE:  Users should modify this setup file to suit their specific 
*  needs. The MISSING VALUES section has been commented out (i.e., '*').
*  To include the MISSING VALUES section in the final SPSS setup, remove 
*  the comment indicators from the desired section.
*
*  CREATING A PERMANENT SPSS DATA FILE: If users wish to create and save
*  an SPSS data file for further analysis using SPSS for Windows, the
*  necessary "SAVE OUTFILE" command is provided in the last line of
*  this file.  To activate the command, users must delete the leading
*  asterisk (*) and replace "spss-filename" with a filename specifying
*  the location on the user's computer system to which the new data file
*  will be saved (e.g., SAVE OUTFILE="c:\spsswin\data\da04347-0001.sav").
*
*-------------------------------------------------------------------------.

* SPSS FILE HANDLE AND DATA LIST COMMANDS.

FILE HANDLE DATA / NAME="data-filename" LRECL=608.
DATA LIST FILE=DATA /
         HRHHID 1-15 (A)           HRYEAR4 16-19
          HURESPLI 20-21           HUFINAL 22-24          HUSPNISH 25-26
          HETENURE 27-28          HEHOUSUT 29-30          HETELHHD 31-32
          HETELAVL 33-34          HEPHONEO 35-36          HUFAMINC 37-38
          HRINTSTA 39-40          HRNUMHOU 41-42           HRHTYPE 43-44
          HUINTTYP 45-46          HUPRSCNT 47-48          HRLONGLK 49-50
      HRSAMPLE 51-54 (A)      HRSERSUF 55-56 (A)           HUHHNUM 57-58
             HUBUS 59-60           HUBUSL1 61-62           HUBUSL2 63-64
           HUBUSL3 65-66           HUBUSL4 67-68             GEREG 69-70
           GESTCEN 71-72          GESTFIPS 73-74           PUPELIG 75-76
             PERRP 77-78          PEPARENT 79-80             PEAGE 81-82
                PTAGE 83          PEMARITL 84-85          PESPOUSE 86-87
             PESEX 88-89          PUAFEVER 90-91          PEAFWHEN 92-93
           PEAFNOW 94-95           PEEDUCA 96-97          PRDTRACE 98-99
         PRDTHSP 100-101        PUCHINHH 102-103        PURELFLG 104-105
        PULINENO 106-107        PRFAMNUM 108-109        PRFAMREL 110-111
        PRFAMTYP 112-113        PEHSPNON 114-115        PRMARSTA 116-117
        PRPERTYP 118-119        PENATVTY 120-122        PEMNTVTY 123-125
        PEFNTVTY 126-128        PRCITSHP 129-130        PRCITFLG 131-132
        PRINUSYR 133-134        PUSLFPRX 135-136           PEMLR 137-138
            PUWK 139-140          PUBUS1 141-142        PUBUS2OT 143-144
        PUBUSCK1 145-146        PUBUSCK2 147-148        PUBUSCK3 149-150
        PUBUSCK4 151-152         PURETOT 153-154           PUDIS 155-156
          PERET1 157-158          PUDIS1 159-160          PUDIS2 161-162
         PUABSOT 163-164           PULAY 165-166        PEABSRSN 167-168
        PEABSPDO 169-170          PEMJOT 171-172         PEMJNUM 173-174
        PEHRUSL1 175-176        PEHRUSL2 177-178        PEHRFTPT 179-180
        PEHRUSLT 181-183        PEHRWANT 184-185        PEHRRSN1 186-187
        PEHRRSN2 188-189        PEHRRSN3 190-191        PUHROFF1 192-193
        PUHROFF2 194-195         PUHROT1 196-197         PUHROT2 198-199
        PEHRACT1 200-201        PEHRACT2 202-203        PEHRACTT 204-206
         PEHRAVL 207-208         PUHRCK1 209-210         PUHRCK2 211-212
         PUHRCK3 213-214         PUHRCK4 215-216         PUHRCK5 217-218
         PUHRCK6 219-220         PUHRCK7 221-222        PUHRCK12 223-224
         PULAYDT 225-226         PULAY6M 227-228        PELAYAVL 229-230
        PULAYAVR 231-232         PELAYLK 233-234        PELAYDUR 235-237
        PELAYFTO 238-239        PULAYCK1 240-241        PULAYCK2 242-243
        PULAYCK3 244-245            PULK 246-247          PELKM1 248-249
          PULKM2 250-251          PULKM3 252-253          PULKM4 254-255
          PULKM5 256-257          PULKM6 258-259         PULKDK1 260-261
         PULKDK2 262-263         PULKDK3 264-265         PULKDK4 266-267
         PULKDK5 268-269         PULKDK6 270-271         PULKPS1 272-273
         PULKPS2 274-275         PULKPS3 276-277         PULKPS4 278-279
         PULKPS5 280-281         PULKPS6 282-283         PELKAVL 284-285
         PULKAVR 286-287        PELKLL1O 288-289        PELKLL2O 290-291
         PELKLWO 292-293         PELKDUR 294-296         PELKFTO 297-298
        PEDWWNTO 299-300         PEDWRSN 301-302         PEDWLKO 303-304
          PEDWWK 305-306         PEDW4WK 307-308        PEDWLKWK 309-310
         PEDWAVL 311-312         PEDWAVR 313-314         PUDWCK1 315-316
         PUDWCK2 317-318         PUDWCK3 319-320         PUDWCK4 321-322
         PUDWCK5 323-324        PRABSREA 325-326         PRCIVLF 327-328
          PRDISC 329-330        PREMPHRS 331-332        PREMPNOT 333-334
         PREXPLF 335-336          PRFTLF 337-338         PRHRUSL 339-340
        PRJOBSEA 341-342         PRPTHRS 343-344         PRPTREA 345-346
        PRUNEDUR 347-349        PRUNTYPE 350-351         PRWKSCH 352-353
        PRWKSTAT 354-355        PRWNTJOB 356-357         PUIODP1 358-359
         PUIODP2 360-361         PUIODP3 362-363        PEIO1COW 364-365
        PUIO1MFG 366-367         PUIOCK1 368-369         PUIOCK2 370-371
         PUIOCK3 372-373         PRIOELG 374-375          PRAGNA 376-377
          PRCOW1 378-379         PRCOWPG 380-381        PRDTCOW1 382-383
        PRDTIND1 384-385        PRDTOCC1 386-387           PREMP 388-389
        PRMJIND1 390-391        PRMJOCC1 392-393        PRMJOCGR 394-395
        PRNAGPWS 396-397         PRNAGWS 398-399          PRSJMJ 400-401
        PESCHENR 402-403         PESCHFT 404-405        PESCHLVL 406-407
        PRNLFSCH 408-409          PRCHLD 410-411        PRNMCHLD 412-413
        HXTENURE 414-415        HXHOUSUT 416-417        HXTELHHD 418-419
        HXTELAVL 420-421        HXPHONEO 422-423        PXINUSYR 424-425
           PXRRP 426-427        PXPARENT 428-429           PXAGE 430-431
        PXMARITL 432-433        PXSPOUSE 434-435           PXSEX 436-437
        PXAFWHEN 438-439         PXAFNOW 440-441         PXEDUCA 442-443
         PXRACE1 444-445        PXNATVTY 446-447        PXMNTVTY 448-449
        PXFNTVTY 450-451        PXHSPNON 452-453           PXMLR 454-455
          PXRET1 456-457        PXABSRSN 458-459        PXABSPDO 460-461
          PXMJOT 462-463         PXMJNUM 464-465        PXHRUSL1 466-467
        PXHRUSL2 468-469        PXHRFTPT 470-471        PXHRUSLT 472-473
        PXHRWANT 474-475        PXHRRSN1 476-477        PXHRRSN2 478-479
        PXHRACT1 480-481        PXHRACT2 482-483        PXHRACTT 484-485
        PXHRRSN3 486-487         PXHRAVL 488-489        PXLAYAVL 490-491
         PXLAYLK 492-493        PXLAYDUR 494-495        PXLAYFTO 496-497
          PXLKM1 498-499         PXLKAVL 500-501        PXLKLL1O 502-503
        PXLKLL2O 504-505         PXLKLWO 506-507         PXLKDUR 508-509
         PXLKFTO 510-511        PXDWWNTO 512-513         PXDWRSN 514-515
         PXDWLKO 516-517          PXDWWK 518-519         PXDW4WK 520-521
        PXDWLKWK 522-523         PXDWAVL 524-525         PXDWAVR 526-527
        PXIO1COW 528-529        PXIO1ICD 530-531        PXIO1OCD 532-533
        PXSCHENR 534-535         PXSCHFT 536-537        PXSCHLVL 538-539
    OCCURNUM 540-541 (A)        PEDIPGED 542-543        PEHGCOMP 544-545
           PECYC 546-547        PEGRPROF 548-549        PEGR6COR 550-551
         PEMS123 552-553        PXDIPGED 554-555        PXHGCOMP 556-557
           PXCYC 558-559        PXGRPROF 560-561        PXGR6COR 562-563
         PXMS123 564-565        PEIO1ICD 566-569        PEIO1OCD 570-573
        PRIMIND1 574-575          HEPORT 576-577            HEQ1 578-579
           HEQ1A 580-581           HEQ1B 582-583            HEQ2 584-585
           HEQ2A 586-587           HEQ2B 588-589           HEQ2C 590-591
           HEQ2D 592-593           HEQ2E 594-595            HEQ3 596-597
            HRSUPINT 598        HWSUPWGT 599-608
   .

* SPSS VARIABLE LABELS COMMAND.

VARIABLE LABELS
   HRHHID    'HRHHID' /
   HRYEAR4   'HRYEAR4' /
   HURESPLI  'HURESPLI' /
   HUFINAL   'HUFINAL' /
   HUSPNISH  'HUSPNISH' /
   HETENURE  'HETENURE' /
   HEHOUSUT  'HEHOUSUT' /
   HETELHHD  'HETELHHD' /
   HETELAVL  'HETELAVL' /
   HEPHONEO  'HEPHONEO' /
   HUFAMINC  'HUFAMINC' /
   HRINTSTA  'HRINTSTA' /
   HRNUMHOU  'HRNUMHOU' /
   HRHTYPE   'HRHTYPE' /
   HUINTTYP  'HUINTTYP' /
   HUPRSCNT  'HUPRSCNT' /
   HRLONGLK  'HRLONGLK' /
   HRSAMPLE  'HRSAMPLE' /
   HRSERSUF  'HRSERSUF' /
   HUHHNUM   'HUHHNUM' /
   HUBUS     'HUBUS' /
   HUBUSL1   'HUBUSL1' /
   HUBUSL2   'HUBUSL2' /
   HUBUSL3   'HUBUSL3' /
   HUBUSL4   'HUBUSL4' /
   GEREG     'GEREG' /
   GESTCEN   'GESTCEN' /
   GESTFIPS  'GESTFIPS' /
   PUPELIG   'PUPELIG' /
   PERRP     'PERRP' /
   PEPARENT  'PEPARENT' /
   PEAGE     'PEAGE' /
   PTAGE     'PTAGE' /
   PEMARITL  'PEMARITL' /
   PESPOUSE  'PESPOUSE' /
   PESEX     'PESEX' /
   PUAFEVER  'PUAFEVER' /
   PEAFWHEN  'PEAFWHEN' /
   PEAFNOW   'PEAFNOW' /
   PEEDUCA   'PEEDUCA' /
   PRDTRACE  'PRDTRACE' /
   PRDTHSP   'PRDTHSP' /
   PUCHINHH  'PUCHINHH' /
   PURELFLG  'PURELFLG' /
   PULINENO  'PULINENO' /
   PRFAMNUM  'PRFAMNUM' /
   PRFAMREL  'PRFAMREL' /
   PRFAMTYP  'PRFAMTYP' /
   PEHSPNON  'PEHSPNON' /
   PRMARSTA  'PRMARSTA' /
   PRPERTYP  'PRPERTYP' /
   PENATVTY  'PENATVTY' /
   PEMNTVTY  'PEMNTVTY' /
   PEFNTVTY  'PEFNTVTY' /
   PRCITSHP  'PRCITSHP' /
   PRCITFLG  'PRCITFLG' /
   PRINUSYR  'PRINUSYR' /
   PUSLFPRX  'PUSLFPRX' /
   PEMLR     'PEMLR' /
   PUWK      'PUWK' /
   PUBUS1    'PUBUS1' /
   PUBUS2OT  'PUBUS2OT' /
   PUBUSCK1  'PUBUSCK1' /
   PUBUSCK2  'PUBUSCK2' /
   PUBUSCK3  'PUBUSCK3' /
   PUBUSCK4  'PUBUSCK4' /
   PURETOT   'PURETOT' /
   PUDIS     'PUDIS' /
   PERET1    'PERET1' /
   PUDIS1    'PUDIS1' /
   PUDIS2    'PUDIS2' /
   PUABSOT   'PUABSOT' /
   PULAY     'PULAY' /
   PEABSRSN  'PEABSRSN' /
   PEABSPDO  'PEABSPDO' /
   PEMJOT    'PEMJOT' /
   PEMJNUM   'PEMJNUM' /
   PEHRUSL1  'PEHRUSL1' /
   PEHRUSL2  'PEHRUSL2' /
   PEHRFTPT  'PEHRFTPT' /
   PEHRUSLT  'PEHRUSLT' /
   PEHRWANT  'PEHRWANT' /
   PEHRRSN1  'PEHRRSN1' /
   PEHRRSN2  'PEHRRSN2' /
   PEHRRSN3  'PEHRRSN3' /
   PUHROFF1  'PUHROFF1' /
   PUHROFF2  'PUHROFF2' /
   PUHROT1   'PUHROT1' /
   PUHROT2   'PUHROT2' /
   PEHRACT1  'PEHRACT1' /
   PEHRACT2  'PEHRACT2' /
   PEHRACTT  'PEHRACTT' /
   PEHRAVL   'PEHRAVL' /
   PUHRCK1   'PUHRCK1' /
   PUHRCK2   'PUHRCK2' /
   PUHRCK3   'PUHRCK3' /
   PUHRCK4   'PUHRCK4' /
   PUHRCK5   'PUHRCK5' /
   PUHRCK6   'PUHRCK6' /
   PUHRCK7   'PUHRCK7' /
   PUHRCK12  'PUHRCK12' /
   PULAYDT   'PULAYDT' /
   PULAY6M   'PULAY6M' /
   PELAYAVL  'PELAYAVL' /
   PULAYAVR  'PULAYAVR' /
   PELAYLK   'PELAYLK' /
   PELAYDUR  'PELAYDUR' /
   PELAYFTO  'PELAYFTO' /
   PULAYCK1  'PULAYCK1' /
   PULAYCK2  'PULAYCK2' /
   PULAYCK3  'PULAYCK3' /
   PULK      'PULK' /
   PELKM1    'PELKM1' /
   PULKM2    'PULKM2' /
   PULKM3    'PULKM3' /
   PULKM4    'PULKM4' /
   PULKM5    'PULKM5' /
   PULKM6    'PULKM6' /
   PULKDK1   'PULKDK1' /
   PULKDK2   'PULKDK2' /
   PULKDK3   'PULKDK3' /
   PULKDK4   'PULKDK4' /
   PULKDK5   'PULKDK5' /
   PULKDK6   'PULKDK6' /
   PULKPS1   'PULKPS1' /
   PULKPS2   'PULKPS2' /
   PULKPS3   'PULKPS3' /
   PULKPS4   'PULKPS4' /
   PULKPS5   'PULKPS5' /
   PULKPS6   'PULKPS6' /
   PELKAVL   'PELKAVL' /
   PULKAVR   'PULKAVR' /
   PELKLL1O  'PELKLL1O' /
   PELKLL2O  'PELKLL2O' /
   PELKLWO   'PELKLWO' /
   PELKDUR   'PELKDUR' /
   PELKFTO   'PELKFTO' /
   PEDWWNTO  'PEDWWNTO' /
   PEDWRSN   'PEDWRSN' /
   PEDWLKO   'PEDWLKO' /
   PEDWWK    'PEDWWK' /
   PEDW4WK   'PEDW4WK' /
   PEDWLKWK  'PEDWLKWK' /
   PEDWAVL   'PEDWAVL' /
   PEDWAVR   'PEDWAVR' /
   PUDWCK1   'PUDWCK1' /
   PUDWCK2   'PUDWCK2' /
   PUDWCK3   'PUDWCK3' /
   PUDWCK4   'PUDWCK4' /
   PUDWCK5   'PUDWCK5' /
   PRABSREA  'PRABSREA' /
   PRCIVLF   'PRCIVLF' /
   PRDISC    'PRDISC' /
   PREMPHRS  'PREMPHRS' /
   PREMPNOT  'PREMPNOT' /
   PREXPLF   'PREXPLF' /
   PRFTLF    'PRFTLF' /
   PRHRUSL   'PRHRUSL' /
   PRJOBSEA  'PRJOBSEA' /
   PRPTHRS   'PRPTHRS' /
   PRPTREA   'PRPTREA' /
   PRUNEDUR  'PRUNEDUR' /
   PRUNTYPE  'PRUNTYPE' /
   PRWKSCH   'PRWKSCH' /
   PRWKSTAT  'PRWKSTAT' /
   PRWNTJOB  'PRWNTJOB' /
   PUIODP1   'PUIODP1' /
   PUIODP2   'PUIODP2' /
   PUIODP3   'PUIODP3' /
   PEIO1COW  'PEIO1COW' /
   PUIO1MFG  'PUIO1MFG' /
   PUIOCK1   'PUIOCK1' /
   PUIOCK2   'PUIOCK2' /
   PUIOCK3   'PUIOCK3' /
   PRIOELG   'PRIOELG' /
   PRAGNA    'PRAGNA' /
   PRCOW1    'PRCOW1' /
   PRCOWPG   'PRCOWPG' /
   PRDTCOW1  'PRDTCOW1' /
   PRDTIND1  'PRDTIND1' /
   PRDTOCC1  'PRDTOCC1' /
   PREMP     'PREMP' /
   PRMJIND1  'PRMJIND1' /
   PRMJOCC1  'PRMJOCC1' /
   PRMJOCGR  'PRMJOCGR' /
   PRNAGPWS  'PRNAGPWS' /
   PRNAGWS   'PRNAGWS' /
   PRSJMJ    'PRSJMJ' /
   PESCHENR  'PESCHENR' /
   PESCHFT   'PESCHFT' /
   PESCHLVL  'PESCHLVL' /
   PRNLFSCH  'PRNLFSCH' /
   PRCHLD    'PRCHLD' /
   PRNMCHLD  'PRNMCHLD' /
   HXTENURE  'HXTENURE' /
   HXHOUSUT  'HXHOUSUT' /
   HXTELHHD  'HXTELHHD' /
   HXTELAVL  'HXTELAVL' /
   HXPHONEO  'HXPHONEO' /
   PXINUSYR  'PXINUSYR' /
   PXRRP     'PXRRP' /
   PXPARENT  'PXPARENT' /
   PXAGE     'PXAGE' /
   PXMARITL  'PXMARITL' /
   PXSPOUSE  'PXSPOUSE' /
   PXSEX     'PXSEX' /
   PXAFWHEN  'PXAFWHEN' /
   PXAFNOW   'PXAFNOW' /
   PXEDUCA   'PXEDUCA' /
   PXRACE1   'PXRACE1' /
   PXNATVTY  'PXNATVTY' /
   PXMNTVTY  'PXMNTVTY' /
   PXFNTVTY  'PXFNTVTY' /
   PXHSPNON  'PXHSPNON' /
   PXMLR     'PXMLR' /
   PXRET1    'PXRET1' /
   PXABSRSN  'PXABSRSN' /
   PXABSPDO  'PXABSPDO' /
   PXMJOT    'PXMJOT' /
   PXMJNUM   'PXMJNUM' /
   PXHRUSL1  'PXHRUSL1' /
   PXHRUSL2  'PXHRUSL2' /
   PXHRFTPT  'PXHRFTPT' /
   PXHRUSLT  'PXHRUSLT' /
   PXHRWANT  'PXHRWANT' /
   PXHRRSN1  'PXHRRSN1' /
   PXHRRSN2  'PXHRRSN2' /
   PXHRACT1  'PXHRACT1' /
   PXHRACT2  'PXHRACT2' /
   PXHRACTT  'PXHRACTT' /
   PXHRRSN3  'PXHRRSN3' /
   PXHRAVL   'PXHRAVL' /
   PXLAYAVL  'PXLAYAVL' /
   PXLAYLK   'PXLAYLK' /
   PXLAYDUR  'PXLAYDUR' /
   PXLAYFTO  'PXLAYFTO' /
   PXLKM1    'PXLKM1' /
   PXLKAVL   'PXLKAVL' /
   PXLKLL1O  'PXLKLL1O' /
   PXLKLL2O  'PXLKLL2O' /
   PXLKLWO   'PXLKLWO' /
   PXLKDUR   'PXLKDUR' /
   PXLKFTO   'PXLKFTO' /
   PXDWWNTO  'PXDWWNTO' /
   PXDWRSN   'PXDWRSN' /
   PXDWLKO   'PXDWLKO' /
   PXDWWK    'PXDWWK' /
   PXDW4WK   'PXDW4WK' /
   PXDWLKWK  'PXDWLKWK' /
   PXDWAVL   'PXDWAVL' /
   PXDWAVR   'PXDWAVR' /
   PXIO1COW  'PXIO1COW' /
   PXIO1ICD  'PXIO1ICD' /
   PXIO1OCD  'PXIO1OCD' /
   PXSCHENR  'PXSCHENR' /
   PXSCHFT   'PXSCHFT' /
   PXSCHLVL  'PXSCHLVL' /
   OCCURNUM  'OCCURNUM' /
   PEDIPGED  'PEDIPGED' /
   PEHGCOMP  'PEHGCOMP' /
   PECYC     'PECYC' /
   PEGRPROF  'PEGRPROF' /
   PEGR6COR  'PEGR6COR' /
   PEMS123   'PEMS123' /
   PXDIPGED  'PXDIPGED' /
   PXHGCOMP  'PXHGCOMP' /
   PXCYC     'PXCYC' /
   PXGRPROF  'PXGRPROF' /
   PXGR6COR  'PXGR6COR' /
   PXMS123   'PXMS123' /
   PEIO1ICD  'PEIO1ICD' /
   PEIO1OCD  'PEIO1OCD' /
   PRIMIND1  'PRIMIND1' /
   HEPORT    'HEPORT' /
   HEQ1      'HEQ1' /
   HEQ1A     'HEQ1A' /
   HEQ1B     'HEQ1B' /
   HEQ2      'HEQ2' /
   HEQ2A     'HEQ2A' /
   HEQ2B     'HEQ2B' /
   HEQ2C     'HEQ2C' /
   HEQ2D     'HEQ2D' /
   HEQ2E     'HEQ2E' /
   HEQ3      'HEQ3' /
   HRSUPINT  'HRSUPINT' /
   HWSUPWGT  'HWSUPWGT' /
   .


* SPSS VALUE LABELS COMMAND.

VALUE LABELS
   HURESPLI  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   HUFINAL   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             0 'NEW INTERVIEW - NOT CONTACTED'
             1 'FULLY COMPLETE CATI INTERVIEW'
             2 'PARTIALLY COMPLETED CATI INTERVIEW'
             4 'PARTIAL CATI -NO COMPLETE AT CLOSEOUT'
             5 'LABOR FORCE COMPLETE, SUPPLEMENT INCOMPLETE - CATI'
             24 'HH OCCUPIED ENTIRELY BY ARMED FORCES MEMBERS'
             115 'PARTIAL INTERVIEW WITH CALLBACK PLANNED - CATI'
             200 'NEW INTERVIEW - CONTACTED' 201 'CAPI COMPLETE'
             202 'CALLBACK NEEDED' 203 'SUFFICIENT PARTIAL - PRECLOSEOUT'
             204 'SUFFICIENT PARTIAL - AT CLOSEOUT'
             205 'LABOR FORCE COMPLETE, - SUPPL. INCOMPLETE - CAPI'
             210 'CAPI COMPLETE REINTERVIEW' 216 'NO ONE HOME'
             217 'TEMPORARILY ABSENT' 218 'REFUSED'
             219 'OTHER OCCUPIED - SPECIFY'
             224 'ARMED FORCES OCCUPIED OR UNDER AGE 14'
             225 'TEMP. OCCUPIED W/PERSONS WITH URE' 226 'VACANT REGULAR'
             227 'VACANT - STORAGE OF HHLD FURNITURE'
             228 'UNFIT, TO BE DEMOLISHED'
             229 'UNDER CONSTRUCTION, NOT READY'
             230 'CONVERTED TO TEMP BUSINESS OR STORAGE'
             231 'UNOCCUPIED TENT OR TRAILER SITE'
             232 'PERMIT GRANTED - CONSTRUCTION NOT STARTED'
             233 'OTHER - SPECIFY' 240 'DEMOLISHED'
             241 'HOUSE OR TRAILER MOVED' 242 'OUTSIDE SEGMENT'
             243 'CONVERTED TO PERM. BUSINESS OR STORAGE' 244 'MERGED'
             245 'CONDEMNED' 246 'BUILT AFTER APRIL 1, 1980'
             247 'UNUSED SERIAL NO./LISTING SHEET LINE' 248 'OTHER - SPECIFY'
             /
   HUSPNISH  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'SPANISH ONLY LANGUAGE SPOKEN' /
   HETENURE  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'OWNED OR BEING BOUGHT BY A HH MEMBER' 2 'RENTED FOR CASH'
             3 'OCCUPIED WITHOUT PAYMENT OF CASH RENT' /
   HEHOUSUT  0 'OTHER UNIT' 1 'HOUSE, APARTMENT, FLAT'
             2 'HU IN NONTRANSIENT HOTEL, MOTEL, ETC.'
             3 'HU PERMANENT IN TRANSIENT HOTEL, MOTEL'
             4 'HU IN ROOMING HOUSE'
             5 'MOBILE HOME OR TRAILER W/NO PERM. ROOM ADDED'
             6 'MOBILE HOME OR TRAILER W/1 OR MORE PERM. ROOMS ADDED'
             7 'HU NOT SPECIFIED ABOVE'
             8 'QUARTERS NOT HU IN ROOMING OR BRDING HS'
             9 'UNIT NOT PERM. IN TRANSIENT HOTL, MOTL'
             10 'UNOCCUPIED TENT SITE OR TRLR SITE'
             11 'STUDENT QUARTERS IN COLLEGE DORM'
             12 'OTHER UNIT NOT SPECIFIED ABOVE' /
   HETELHHD  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   HETELAVL  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   HEPHONEO  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             0 'UNKNOWN' 1 'YES' 2 'NO' /
   HUFAMINC  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'LESS THAN $5,000' 2 '5,000 TO 7,499' 3 '7,500 TO 9,999'
             4 '10,000 TO 12,499' 5 '12,500 TO 14,999' 6 '15,000 TO 19,999'
             7 '20,000 TO 24,999' 8 '25,000 TO 29,999' 9 '30,000 TO 34,999'
             10 '35,000 TO 39,999' 11 '40,000 TO 49,999'
             12 '50,000 TO 59,999' 13 '60,000 TO 74,999' 14 '75,000 OR MORE'
             15 '15: UNDOCUMENTED CODE' 16 '16: UNDOCUMENTED CODE' /
   HRINTSTA  1 'INTERVIEW' 2 'TYPE A NON-INTERVIEW' 3 'TYPE B NON-INTERVIEW'
             4 'TYPE C NON-INTERVIEW' /
   HRHTYPE   0 'NON-INTERVIEW HOUSEHOLD'
             1 'HUSBAND/WIFE PRIMARY FAMILY (NEITHER AF)'
             2 'HUSB/WIFE PRIM. FAMILY (EITHER/BOTH AF)'
             3 'UNMARRIED CIVILIAN MALE-PRIM. FAM HHLDER'
             4 'UNMARRIED CIV. FEMALE-PRIM FAM HHLDER'
             5 'PRIMARY FAMILY HHLDER-RP IN AF, UNMAR.'
             6 'CIVILIAN MALE PRIMARY INDIVIDUAL'
             7 'CIVILIAN FEMALE PRIMARY INDIVIDUAL'
             8 'PRIMARY INDIVIDUAL HHLD-RP IN AF'
             9 'GROUP QUARTERS WITH FAMILY'
             10 'GROUP QUARTERS WITHOUT FAMILY' /
   HUINTTYP  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             0 'NONINTERVIEW/INDETERMINATE' 1 'PERSONAL' 2 'TELEPHONE' /
   HUPRSCNT  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   HRLONGLK  0 'MIS 1 OR REPLACEMENT HH (NO LINK)' 2 'MIS 2-4 OR MIS 6-8'
             3 'MIS 5' /
   HUHHNUM   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   HUBUS     -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   HUBUSL1   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   HUBUSL2   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   HUBUSL3   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   HUBUSL4   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   GEREG     1 'NORTHEAST' 2 'MIDWEST (FORMERLY NORTH CENTRAL)' 3 'SOUTH'
             4 'WEST' /
   GESTCEN   11 'ME' 12 'NH' 13 'VT' 14 'MA' 15 'RI' 16 'CT' 21 'NY' 22 'NJ'
             23 'PA' 31 'OH' 32 'IN' 33 'IL' 34 'MI' 35 'WI' 41 'MN' 42 'IA'
             43 'MO' 44 'ND' 45 'SD' 46 'NE' 47 'KS' 51 'DE' 52 'MD' 53 'DC'
             54 'VA' 55 'WV' 56 'NC' 57 'SC' 58 'GA' 59 'FL' 61 'KY' 62 'TN'
             63 'AL' 64 'MS' 71 'AR' 72 'LA' 73 'OK' 74 'TX' 81 'MT' 82 'ID'
             83 'WY' 84 'CO' 85 'NM' 86 'AZ' 87 'UT' 88 'NV' 91 'WA' 92 'OR'
             93 'CA' 94 'AK' 95 'HI' /
   GESTFIPS  1 'AL' 2 'AK' 4 'AZ' 5 'AR' 6 'CA' 8 'CO' 9 'CT' 10 'DE' 11 'DC'
             12 'FL' 13 'GA' 15 'HI' 16 'ID' 17 'IL' 18 'IN' 19 'IA' 20 'KS'
             21 'KY' 22 'LA' 23 'ME' 24 'MD' 25 'MA' 26 'MI' 27 'MN' 28 'MS'
             29 'MO' 30 'MT' 31 'NE' 32 'NV' 33 'NH' 34 'NJ' 35 'NM' 36 'NY'
             37 'NC' 38 'ND' 39 'OH' 40 'OK' 41 'OR' 42 'PA' 44 'RI' 45 'SC'
             46 'SD' 47 'TN' 48 'TX' 49 'UT' 50 'VT' 51 'VA' 53 'WA' 54 'WV'
             55 'WI' 56 'WY' /
   PUPELIG   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'ELIGIBLE FOR INTERVIEW' 2 'LABOR FORCE FULLY COMPLETE'
             3 'MISSING LABOR FORCE DATA FOR PERSON' 4 '(NOT USED)'
             5 'ASSIGNED IF AGE IS BLANK' 6 'ARMED FORCES MEMBER'
             7 'UNDER 15 YEARS OLD' 8 'NOT A HH MEMBER' 9 'DELETED'
             10 'DECEASED' 11 'END OF LIST' 12 'AFTER END OF LIST' /
   PERRP     -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'REFERENCE PERSON W/RELS.' 2 'REFERENCE PERSON W/O RELS.'
             3 'SPOUSE' 4 'CHILD' 5 'GRANDCHILD' 6 'PARENT'
             7 'BROTHER/SISTER' 8 'OTHER REL. OR REF. PERSON'
             9 'FOSTER CHILD' 10 'NONREL. OF REF. PERSON W/RELS.'
             11 'NOT USED' 12 'NONREL. OF REF. PERSON W/O RELS.'
             13 'UNMARRIED PARTNER W/RELS.'
             14 'UNMARRIED PARTNER W/OUT RELS.'
             15 'HOUSEMATE/ROOMMATE W/RELS.'
             16 'HOUSEMATE/ROOMMATE W/OUT RELS.' 17 'ROOMER/BOARDER W/RELS.'
             18 'ROOMER/BOARDER W/OUT RELS.' /
   PEPARENT  -1 'NO PARENT' /
   PEAGE     -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   PTAGE     0 'NO TOP CODE' 1 'TOP CODED VALUE FOR AGE' /
   PEMARITL  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'MARRIED - SPOUSE PRESENT' 2 'MARRIED - SPOUSE ABSENT'
             3 'WIDOWED' 4 'DIVORCED' 5 'SEPARATED' 6 'NEVER MARRIED' /
   PESPOUSE  -1 'NO SPOUSE' /
   PESEX     -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'MALE' 2 'FEMALE' /
   PUAFEVER  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PEAFWHEN  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'VIETNAM ERA (8/64-4/75)' 2 'KOREAN WAR (6/50-1/55)'
             3 'WORLD WAR II (9/40-7/47)' 4 'WORLD WAR I (4/17-11/18)'
             5 'OTHER SERVICE (ALL OTHER PERIODS)' 6 'NONVETERAN' /
   PEAFNOW   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PEEDUCA   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             31 'LESS THAN 1ST GRADE' 32 '1ST, 2ND, 3RD OR 4TH GRADE'
             33 '5TH OR 6TH GRADE' 34 '7TH OR 8TH GRADE' 35 '9TH GRADE'
             36 '10TH GRADE' 37 '11TH GRADE' 38 '12TH GRADE NO DIPLOMA'
             39 'HIGH SCHOOL GRAD-DIPLOMA OR EQUIV (GED)'
             40 'SOME COLLEGE BUT NO DEGREE'
             41 'ASSOCIATE DEGREE-OCCUPATIONAL/ VOCATIONAL'
             42 'ASSOCIATE DEGREE-ACADEMIC PROGRAM'
             43 'BACHELOR''S DEGREE (EX: BA, AB, BS)'
             44 'MASTER''S DEGREE (EX: MA, MS, MEng, MEd, MSW)'
             45 'PROFESSIONAL SCHOOL DEG (EX: MD,DDS, DVM)'
             46 'DOCTORATE DEGREE (EX: PhD, EdD)' /
   PRDTRACE  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'WHITE ONLY' 2 'BLACK ONLY'
             3 'AMERICAN INDIAN, ALASKAN NATIVE ONLY' 4 'ASIAN ONLY'
             5 'HAWAIIAN/PACIFIC ISLANDER ONLY' 6 'WHITE-BLACK' 7 'WHITE-AI'
             8 'WHITE-ASIAN' 9 'WHITE-HAWAIIAN' 10 'BLACK-AI'
             11 'BLACK-ASIAN' 12 'BLACK-HP' 13 'AI-ASIAN' 14 'ASIAN-HP'
             15 'W-B-AI' 16 'W-B-A' 17 'W-AI-A' 18 'W-A-HP' 19 'W-B-AI-A'
             20 '2 OR 3 RACES' 21 '4 OR 5 RACES' /
   PRDTHSP   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'MEXICAN' 2 'PUERTO RICAN' 3 'CUBAN'
             4 'CENTRAL/SOUTH AMERICAN' 5 'OTHER SPANISH' /
   PUCHINHH  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'PERSON ADDED' 2 'PERSON ADDED - URE' 3 'PERSON UNDELETED'
             4 'PERSON DIED' 5 'DELETED FOR REASON OTHER THAN DEATH'
             6 'PERSON JOINED ARMED FORCES' 7 'PERSON NO LONGER IN AF'
             9 'CHANGE IN DEMOGRAPHIC INFORMATION' /
   PURELFLG  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             0 'NOT OWNER OR RELATED TO OWNER'
             1 'OWNER OF BUS OR RELATED TO OWNER OF BUS' /
   PULINENO  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   PRFAMNUM  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             0 'NOT A FAMILY MEMBER' 1 'PRIMARY FAMILY MEMBER ONLY'
             2 'SUBFAMILY NO. 2 MEMBER' 3 'SUBFAMILY NO. 3 MEMBER'
             4 'SUBFAMILY NO. 4 MEMBER' 5 'SUBFAMILY NO. 5 MEMBER'
             6 'SUBFAMILY NO. 6 MEMBER' 7 'SUBFAMILY NO. 7 MEMBER'
             8 'SUBFAMILY NO. 8 MEMBER' 9 'SUBFAMILY NO. 9 MEMBER'
             10 'SUBFAMILY NO. 10 MEMBER' 11 'SUBFAMILY NO. 11 MEMBER'
             12 'SUBFAMILY NO. 12 MEMBER' 13 'SUBFAMILY NO. 13 MEMBER'
             14 'SUBFAMILY NO. 14 MEMBER' 15 'SUBFAMILY NO. 15 MEMBER'
             16 'SUBFAMILY NO. 16 MEMBER' 17 'SUBFAMILY NO. 17 MEMBER'
             18 'SUBFAMILY NO. 18 MEMBER' 19 'SUBFAMILY NO. 19 MEMBER' /
   PRFAMREL  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             0 'NOT A FAMILY MEMBER' 1 'REFERENCE PERSON' 2 'SPOUSE'
             3 'CHILD' 4 'OTHER RELATIVE (PRIMARY FAMILY & UNREL)' /
   PRFAMTYP  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'PRIMARY FAMILY' 2 'PRIMARY INDIVIDUAL' 3 'RELATED SUBFAMILY'
             4 'UNRELATED SUBFAMILY' 5 'SECONDARY INDIVIDUAL' /
   PEHSPNON  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'HISPANIC' 2 'NON-HIPSANIC' /
   PRMARSTA  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'MARRIED, CIVILIAN SPOUSE PRESENT'
             2 'MARRIED, ARMED FORCES SPOUSE PRESENT'
             3 'MARRIED, SPOUSE ABSENT (EXC. SEPARATED)' 4 'WIDOWED'
             5 'DIVORCED' 6 'SEPARATED' 7 'NEVER MARRIED' /
   PRPERTYP  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CHILD HOUSEHOLD MEMBER' 2 'ADULT CIVILIAN HOUSEHOLD MEMBER'
             3 'ADULT ARMED FORCES HOUSEHOLD MEMBER' /
   PENATVTY  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             57 'UNITED STATES' 72 'PUERTO RICO' 96 'U.S. OUTLYING AREA'
             555 'ABROAD, COUNTRY NOT KNOWN' /
   PEMNTVTY  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             57 'UNITED STATES' 72 'PUERTO RICO' 96 'U.S. OUTLYING AREA'
             555 'ABROAD, COUNTRY NOT KNOWN' /
   PEFNTVTY  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             57 'UNITED STATES' 72 'PUERTO RICO' 96 'U.S. OUTLYING AREA'
             555 'ABROAD, COUNTRY NOT KNOWN' /
   PRCITSHP  1 'NATIVE, BORN IN THE UNITED STATES'
             2 'NATIVE, BORN IN PUERTO RICO OR U.S. OUTLYING AREA'
             3 'NATIVE, BORN ABROAD OF AMERICAN PARENT OR PARENTS'
             4 'FOREIGN BORN, U.S. CITIZEN BY NATURALIZATION'
             5 'FOREIGN BORN, NOT A CITIZEN OF THE UNITED STATES' /
   PRCITFLG  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PRINUSYR  -1 'NOT IN UNIVERSE (BORN IN U.S.)' 0 'NOT FOREIGN BORN'
             1 'BEFORE 1950' 2 '1950-1959' 3 '1960-1964' 4 '1965-1969'
             5 '1970-1974' 6 '1975-1979' 7 '1980-1981' 8 '1982-1983'
             9 '1984-1985' 10 '1986-1987' 11 '1988-1989' 12 '1990-1991'
             13 '1992-1993' 14 '1994-1995' 15 '1996-1997' 16 '1998-1999'
             17 '2000-2001' 18 '2002-2003' 19 '2004-2007' /
   PUSLFPRX  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'SELF' 2 'PROXY' 3 'BOTH SELF AND PROXY' /
   PEMLR     -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'EMPLOYED-AT WORK' 2 'EMPLOYED-ABSENT'
             3 'UNEMPLOYED-ON LAYOFF' 4 'UNEMPLOYED-LOOKING'
             5 'NOT IN LABOR FORCE-RETIRED' 6 'NOT IN LABOR FORCE-DISABLED'
             7 'NOT IN LABOR FORCE-OTHER' /
   PUWK      -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' 3 'RETIRED' 4 'DISABLED' 5 'UNABLE TO WORK' /
   PUBUS1    -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PUBUS2OT  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PUBUSCK1  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'GOTO PUBUS1' 2 'GOTO PURETCK1' /
   PUBUSCK2  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'GOTO PUHRUSL1' 2 'GOTO PUBUS2' /
   PUBUSCK3  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'GOTO PUABSRSN' 2 'GOTO PULAY' /
   PUBUSCK4  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'GOTO PUHRUSL1' 2 'GOTO PUABSPD' /
   PURETOT   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' 3 'WAS NOT RETIRED LAST MONTH' /
   PUDIS     -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' 3 'DID NOT HAVE DISABILITY LAST MONTH' /
   PERET1    -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' 3 'HAS A JOB' /
   PUDIS1    -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PUDIS2    -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PUABSOT   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' 3 'RETIRED' 4 'DISABLED' 5 'UNABLE TO WORK' /
   PULAY     -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' 3 'RETIRED' 4 'DISABLED' 5 'UNABLE TO WORK' /
   PEABSRSN  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'ON LAYOFF' 2 'SLACK WORK/BUSINESS CONDITIONS'
             3 'WAITING FOR A NEW JOB TO BEGIN' 4 'VACATION/PERSONAL DAYS'
             5 'OWN ILLNESS/INJURY/MEDICAL PROBLEMS' 6 'CHILD CARE PROBLEMS'
             7 'OTHER FAMILY/PERSONAL OBLIGATION'
             8 'MATERNITY/PATERNITY LEAVE' 9 'LABOR DISPUTE'
             10 'WEATHER AFFECTED JOB' 11 'SCHOOL/TRAINING'
             12 'CIVIC/MILITARY DUTY' 13 'DOES NOT WORK IN THE BUSINESS'
             14 'OTHER (SPECIFY)' /
   PEABSPDO  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PEMJOT    -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PEMJNUM   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             2 '2 JOBS' 3 '3 JOBS' 4 '4 OR MORE JOBS' /
   PEHRUSL1  -4 'HOURS VARY' -3 'REFUSED' -2 'DON''T KNOW'
             -1 'BLANK OR NOT IN UNIVERSE' /
   PEHRUSL2  -4 'HOURS VARY' -3 'REFUSED' -2 'DON''T KNOW'
             -1 'BLANK OR NOT IN UNIVERSE' /
   PEHRFTPT  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' 3 'HOURS VARY' /
   PEHRUSLT  -4 'VARIES' -3 'REFUSED' -2 'DON''T KNOW'
             -1 'BLANK OR NOT IN UNIVERSE' /
   PEHRWANT  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' 3 'REGULAR HOURS ARE FULL-TIME' /
   PEHRRSN1  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'SLACK WORK/BUSINESS CONDITIONS'
             2 'COULD ONLY FIND PART-TIME WORK' 3 'SEASONAL WORK'
             4 'CHILD CARE PROBLEMS' 5 'OTHER FAMILY/PERSONAL OBLIGATIONS'
             6 'HEALTH/MEDICAL LIMITATIONS' 7 'SCHOOL/TRAINING'
             8 'RETIRED/SOCIAL SECURITY LIMIT ON EARNINGS'
             9 'FULL-TIME WORKWEEK IS LESS THAN 35 HRS' 10 'OTHER - SPECIFY'
             /
   PEHRRSN2  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CHILD CARE PROBLEMS' 2 'OTHER FAMILY/PERSONAL OBLIGATIONS'
             3 'HEALTH/MEDICAL LIMITATIONS' 4 'SCHOOL/TRAINING'
             5 'RETIRED/SOCIAL SECURITY LIMIT ON EARNINGS'
             6 'FULL-TIME WORKWEEK LESS THAN 35 HOURS' 7 'OTHER - SPECIFY' /
   PEHRRSN3  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'SLACK WORK/BUSINESS CONDITIONS' 2 'SEASONAL WORK'
             3 'JOB STARTED OR ENDED DURING WEEK' 4 'VACATION/PERSONAL DAY'
             5 'OWN ILLNESS/INJURY/MEDICAL APPOINTMENT'
             6 'HOLIDAY (LEGAL OR RELIGIOUS)' 7 'CHILD CARE PROBLEMS'
             8 'OTHER FAMILY/PERSONAL OBLIGATIONS' 9 'LABOR DISPUTE'
             10 'WEATHER AFFECTED JOB' 11 'SCHOOL/TRAINING'
             12 'CIVIC/MILITARY DUTY' 13 'OTHER REASON' /
   PUHROFF1  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PUHROFF2  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   PUHROT1   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PUHROT2   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   PEHRACT1  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   PEHRACT2  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   PEHRACTT  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   PEHRAVL   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PUHRCK1   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'GOTO PUHRUSL2' 2 'GOTO PUHRUSLT' /
   PUHRCK2   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
 1 'IF ENTRY OF 1 IN MJ AND ENTRY OF D, R OR V IN HRUSL1 AND ENTRY OF D, R, V OR 0-34 IN HRUSL2 GOTO HRFTPT'
 2 'IF ENTRY OF 1 IN MJ AND ENTRY OF D, R OR V IN HRUSL2 AND ENTRY OF D, R V OR 0-34 IN HRUSL1 GOTO HRFTPT'
 3 'IF ENTRY OF 2, D OR R IN MJ AND ENTRY OF D, R OR V IN HRUSL1 GOTO HRFTPT'
  4 'IF ENTRY OF 1 IN BUS1 AND ENTRY OF D, R OR V IN HRUSL1 THEN GOTO HRFTPT'
             5 'ALL OTHERS GOTO HRCK3-C' /
   PUHRCK3   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
 1 'IF ENTRY OF 1 IN ABSOT OR (ENTRY OR 2 IN ABSOT AND ENTRY OF 1 IN BUS AND CURRENT R_P EQUALS BUSLST) THEN GOTO HRCK8'
             2 'IF ENTRY OF 3 IN RET1 GOTO HRCK8'
             3 'IF ENTRY IN HRUSLT IS 0-34 HOURS GO TO HRCK4-C'
             4 'IF ENTRY IN HRUSLT IS 35+ GOTO HROFF1'
             5 'ALL OTHERS GOTO HRCK4-C' 6 'GOTO PUHRCK4' /
   PUHRCK4   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'IF ENTRY OF 1, D, R OR V IN HRFTPT THEN GOTO HRACT1'
             2 'IF ENTRY OF 2, D OR R IN BUS2 THEN GOTO HROFF1'
             3 'IF HRUSLT IS 0-34 THEN GOTO HRWANT'
             4 'IF ENTRY OF 2 IN HRFTPT THEN GOTO HRWANT'
             5 'ALL OTHERS GOTO HRACT1' /
   PUHRCK5   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'IF ENTRY OF 1 IN MJOT GOTO HRACT2'
             2 'ALL OTHERS GOTO HRCK6-C' /
   PUHRCK6   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
      1 'IF HRACT1 AND HRACT2 EQ 0 AND ENTRY OF 2, D, R IN BUS2 THEN GOTO LK'
          2 'IF HRACT1 AND HRACT2 EQ 0 THEN STORE 1 IN ABSOT AND GOTO ABSRSN'
             3 'ALL OTHERS GOTO HRACTT-C' /
   PUHRCK7   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
 1 '(IF ENTRY OF 2, D OR R IN BUS2) AND (HRACT1 LESS THAN 15 OR D) GOTO HRCK8'
           2 '(IF ENTRY OF 2, D OR R IN BUS2) AND (HRACT1 IS 15+) GOTO HRCK8'
 3 '(IF HRUSLT IS 35+ OR IF ENTRY OF 1 IN HRFTPT) AND (HRACTT < 35) AND ENTRY IN HRACT1 OR HRACT2 ISN''T D OR R THEN GOTO HRR'
 4 'IF ENTRY OF 1 IN HRWANT AND HRACTT < 35 AND (ENTRY OF 1, 2, 3 IN HRRSN1) GOTO HRAVL'
             5 'ALL OTHERS GOTO HRCK8' /
   PUHRCK12  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
    1 'IF ENTRY OF 2, D OR R IN BUS2 AND HRACTT IS LESS THAN 15 OR D GOTO LK'
             2 'ALL OTHERS GOTO IOCK1' /
   PULAYDT   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PULAY6M   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PELAYAVL  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PULAYAVR  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'OWN TEMPORARY ILLNESS' 2 'GOING TO SCHOOL' 3 'OTHER' /
   PELAYLK   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PELAYDUR  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   PELAYFTO  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PULAYCK1  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'GOTO PULAYCK3' 2 'GOTO PULAYFT' 3 'GOTO PULAYDR' /
   PULAYCK2  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'GOTO PULAYDR3' 2 'GOTO PULAYFT' /
   PULAYCK3  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'MISCK = 5 GOTO IO1INT'
             2 'I-ICR = 1 OR I-OCR = 1, GOTO IO1INT'
             3 'ALL OTHERS GOTO SCHCK' /
   PULK      -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' 3 'RETIRED' 4 'DISABLED' 5 'UNABLE TO WORK' /
   PELKM1    -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CONTACTED EMPLOYER DIRECTLY/ INTERVIEW'
             2 'CONTACTED PUBLIC EMPLOYMENT AGENCY'
             3 'CONTACTED PRIVATE EMPLOYMENT AGENCY'
             4 'CONTACTED FRIENDS OR RELATIVES'
             5 'CONTACTED SCHOOL/UNIVERSITY EMPL CENTER'
             6 'SENT OUT RESUMES/FILLED OUT APPLICATION'
             7 'CHECKED UNION/PROFESSIONAL\ REGISTERS'
             8 'PLACED OR ANSWERED ADS' 9 'OTHER ACTIVE' 10 'LOOKED AT ADS'
             11 'ATTENDED JOB TRAINING PROGRAMS/COURSES' 12 'NOTHING'
             13 'OTHER PASSIVE' /
   PULKM2    -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CONTACTED EMPLOYER DIRECTLY/ INTERVIEW'
             2 'CONTACTED PUBLIC EMPLOYMEN AGENCY'
             3 'CONTACTED PRIVATE EMPLOYMENT AGENCY'
             4 'CONTACTED FRIENDS OR RELATIVES'
             5 'CONTACTED SCHOOL/UNIVERSITY EM CENTER'
             6 'SENT OUT RESUMES/FILLED OUT APPLICATION'
             7 'CHECKED UNION/PROFESSIONAL REGISTERS'
             8 'PLACED OR ANSWERED ADS' 9 'OTHER ACTIVE' 10 'LOOKED AT ADS'
             11 'ATTENDED JOB TRAINING PROGRAMS/COURSES' 12 'NOTHING'
             13 'OTHER PASSIVE' /
   PULKM3    -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CONTACTED EMPLOYER DIRECTLY/ INTERVIEW'
             2 'CONTACTED PUBLIC EMPLOYMENT AGENCY'
             3 'CONTACTED PRIVATE EMPLOYMENT AGENCY'
             4 'CONTACTED FRIENDS OR RELATIVES'
             5 'CONTACTED SCHOOL/UNIVERSITY EMPL CENTER'
             6 'SENT OUT RESUMES/FILLED OUT APPLICATION'
             7 'CHECKED UNION/PROFESSIONAL REGISTERS'
             8 'PLACED OR ANSWERED ADS' 9 'OTHER ACTIVE' 10 'LOOKED AT ADS'
             11 'ATTENDED JOB TRAINING PROGRAMS/COURSES' 12 'NOTHING'
             13 'OTHER PASSIVE' /
   PULKM4    -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CONTACTED EMPLOYER DIRECTLY/ INTERVIEW'
             2 'CONTACTED PUBLIC EMPLOYMENT AGENCY'
             3 'CONTACTED PRIVATE EMPLOYMENT AGENCY'
             4 'CONTACTED FRIENDS OR RELATIVES'
             5 'CONTACTED SCHOOL/UNIVERSITY EMPL CENTER'
             6 'SENT OUT RESUMES/FILLED OUT APPLICATION'
             7 'CHECKED UNION/PROFESSIONAL REGISTERS'
             8 'PLACED OR ANSWERED ADS' 9 'OTHER ACTIVE' 10 'LOOKED AT ADS'
             11 'ATTENDED JOB TRAINING PROGRAMS/COURSES' 12 'NOTHING'
             13 'OTHER PASSIVE' /
   PULKM5    -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CONTACTED EMPLOYER DIRECTLY/ INTERVIEW'
             2 'CONTACTED PUBLIC EMPLOYMENT AGENCY'
             3 'CONTACTED PRIVATE EMPLOYMENT AGENCY'
             4 'CONTACTED FRIENDS OR RELATIVES'
             5 'CONTACTED SCHOOL/UNIVERSITY EMPL CENTER'
             6 'SENT OUT RESUMES/FILLED OUT APPLICATION'
             7 'CHECKED UNION/PROFESSIONAL REGISTERS'
             8 'PLACED OR ANSWERED ADS' 9 'OTHER ACTIVE' 10 'LOOKED AT ADS'
             11 'ATTENDED JOB TRAINING PROGRAMS/COURSES' 12 'NOTHING'
             13 'OTHER PASSIVE' /
   PULKM6    -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CONTACTED EMPLOYER DIRECTLY/ INTERVIEW'
             2 'CONTACTED PUBLIC EMPLOYMENT AGENCY'
             3 'CONTACTED PRIVATE EMPLOYMENT AGENCY'
             4 'CONTACTED FRIENDS OR RELATIVES'
             5 'CONTACTED SCHOOL/UNIVERSITY EMPL CENTER'
             6 'SENT OUT RESUMES/FILLED OUT APPLICATION'
             7 'CHECKED UNION/PROFESSIONAL REGISTERS'
             8 'PLACED OR ANSWERED ADS' 9 'OTHER ACTIVE' 10 'LOOKED AT ADS'
             11 'ATTENDED JOB TRAINING PROGRAMS/COURSES' 12 'NOTHING'
             13 'OTHER PASSIVE' /
   PULKDK1   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CONTACTED EMPLOYER DIRECTLY/ INTERVIEW'
             2 'CONTACTED PUBLIC EMPLOYMENT AGENCY'
             3 'CONTACTED PRIVATE EMPLOYMENT AGENCY'
             4 'CONTACTED FRIENDS OR RELATIVES CENTER'
             6 'SENT OUT RESUMES/FILLED OUT APPLICATION'
             7 'CHECKED UNION/PROFESSIONAL REGISTERS'
             8 'PLACED OR ANSWERED ADS' 9 'OTHER ACTIVE' 10 'LOOKED AT ADS'
             11 'ATTENDED JOB TRAINING PROGRAM COURSES' 12 'NOTHING'
             13 'OTHER PASSIVE' /
   PULKDK2   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CONTACTED EMPLOYER DIRECTLY/ INTERVIEW'
             2 'CONTACTED PUBLIC EMPLOYMENT AGENCY'
             3 'CONTACTED PRIVATE EMPLOYMENT AGENCY'
             4 'CONTACTED FRIENDS OR RELATIVES'
             5 'CONTACTED SCHOOL/UNIVERSITY EMPL CENTER APPLICATION'
             7 'CHECKED UNION/PROFESSIONAL REGISTERS'
             8 'PLACED OR ANSWERED ADS' 9 'OTHER ACTIVE' 10 'LOOKED AT ADS'
             11 'ATTENDED JOB TRAINING PROGRAMS/COURSES' 12 'NOTHING'
             13 'OTHER PASSIVE' /
   PULKDK3   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CONTACTED EMPLOYER DIRECTLY/ INTERVIEW AGENCY'
             3 'CONTACTED PRIVATE EMPLOYME AGENCY'
             4 'CONTACTED FRIENDS OR RELATIVES'
             5 'CONTACTED SCHOOL/UNIVERSITY EMPL CENTER'
             6 'SENT OUT RESUMES/FILLED OUT APPLICATION'
             7 'CHECKED UNION/PROFESSIONAL REGISTERS'
             8 'PLACED OR ANSWERED ADS' 9 'OTHER ACTIVE' 10 'LOOKED AT ADS'
             11 'ATTENDED JOB TRAINING PROGRAMS/COURSES' 12 'NOTHING'
             13 'OTHER PASSIVE' /
   PULKDK4   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CONTACTED EMPLOYER DIRECTLY INTERVIEW'
             2 'CONTACTED PUBLIC EMPLOYMENT AGENCY'
             3 'CONTACTED PRIVATE EMPLOYMENT AGENCY'
             4 'CONTACTED FRIENDS OR RELATIVES'
             5 'CONTACTED SCHOOL/UNIVERSITY EMPL CENTER'
             6 'SENT OUT RESUMES/FILLED OUT APPLICATION'
             7 'CHECKED UNION/PROFESSIONAL REGISTERS'
             8 'PLACED OR ANSWERED ADS' 9 'OTHER ACTIVE' 10 'LOOKED AT ADS'
             11 'ATTENDED JOB TRAINING PROGRAMS/COURSES' 12 'NOTHING'
             13 'OTHER PASSIVE' /
   PULKDK5   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CONTACTED EMPLOYER DIRECTLY/ INTERVIEW'
             2 'CONTACTED PUBLIC EMPLOYMENT AGENCY'
             3 'CONTACTED PRIVATE EMPLOYMENT AGENCY'
             4 'CONTACTED FRIENDS OR RELATIVES'
             5 'CONTACTED SCHOOL/UNIVERSITY EM CENTER'
             6 'SENT OUT RESUMES/FILLED OUT APPLICATION'
             7 'CHECKED UNION/PROFESSIONAL REGISTERS'
             8 'PLACED OR ANSWERED ADS' 9 'OTHER ACTIVE' 10 'LOOKED AT ADS'
             11 'ATTENDED JOB TRAINING PROGRAMS/COURSES' 12 'NOTHING'
             13 'OTHER PASSIVE' /
   PULKDK6   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CONTACTED EMPLOYER DIRECTLY/ INTERVIEW'
             2 'CONTACTED PUBLIC EMPLOYMENT AGENCY'
             3 'CONTACTED PRIVATE EMPLOYMENT AGENCY'
             4 'CONTACTED FRIENDS OR RELATIVES'
             5 'CONTACTED SCHOOL/UNIVERSITY EMPL CENTER'
             6 'SENT OUT RESUMES/FILLED OUT APPLICATION REGISTERS'
             8 'PLACED OR ANSWERED ADS' 9 'OTHER ACTIVE' 10 'LOOKED AT ADS'
             11 'ATTENDED JOB TRAINING PROGRAMS COURSES' 12 'NOTHING'
             13 'OTHER PASSIVE' /
   PULKPS1   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CONTACTED EMPLOYER DIRECTLY/ INTERVIEW'
             2 'CONTACTED PUBLIC EMPLOYMENT AGENCY'
             3 'CONTACTED PRIVATE EMPLOYMENT AGENCY'
             4 'CONTACTED FRIENDS OR RELATIVES'
             5 'CONTACTED SCHOOL/UNIVERSITY EMPL CENTER'
             6 'SENT OUT RESUMES/FILLED OUT APPLICATION'
             7 'CHECKED UNION/PROFESSIONAL REGISTERS'
             8 'PLACED OR ANSWERED ADS' 9 'OTHER ACTIVE' 10 'LOOKED AT ADS'
             11 'ATTENDED JOB TRAINING PROGRAMS/COURSES' 12 'NOTHING'
             13 'OTHER PASSIVE' /
   PULKPS2   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CONTACTED EMPLOYER DIRECTLY/ INTERVIEW'
             2 'CONTACTED PUBLIC EMPLOYMENT AGENCY'
             3 'CONTACTED PRIVATE EMPLOYMENT AGENCY'
             4 'CONTACTED FRIENDS OR RELATIVES'
             5 'CONTACTED SCHOOL/UNIVERSITY EMPL CENTER'
             6 'SENT OUT RESUMES/FILLED OUT APPLICATION'
             7 'CHECKED UNION/PROFESSIONAL REGISTERS'
             8 'PLACED OR ANSWERED ADS' 9 'OTHER ACTIVE' 10 'LOOKED AT ADS'
             11 'ATTENDED JOB TRAINING PROGRAMS/COURSES' 12 'NOTHING'
             13 'OTHER PASSIVE' /
   PULKPS3   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CONTACTED EMPLOYER DIRECTLY/ INTERVIEW'
             2 'CONTACTED PUBLIC EMPLOYMENT AGENCY'
             3 'CONTACTED PRIVATE EMPLOYMENT AGENCY'
             4 'CONTACTED FRIENDS OR RELATIVES'
             5 'CONTACTED SCHOOL/UNIVERSITY EMPL CENTER'
             6 'SENT OUT RESUMES/FILLED OUT APPLICATION'
             7 'CHECKED UNION/PROFESSIONAL REGISTERS'
             8 'PLACED OR ANSWERED ADS' 9 'OTHER ACTIVE' 10 'LOOKED AT ADS'
             11 'ATTENDED JOB TRAINING PROGRAMS/COURSES' 12 'NOTHING'
             13 'OTHER PASSIVE' /
   PULKPS4   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CONTACTED EMPLOYER DIRECTLY/ INTERVIEW'
             2 'CONTACTED PUBLIC EMPLOYMEN AGENCY'
             3 'CONTACTED PRIVATE EMPLOYMENT AGENCY'
             4 'CONTACTED FRIENDS OR RELATIVES'
             5 'CONTACTED SCHOOL/UNIVERSITY EM CENTER'
             6 'SENT OUT RESUMES/FILLED OUT APPLICATION'
             7 'CHECKED UNION/PROFESSIONAL REGISTERS'
             8 'PLACED OR ANSWERED ADS' 9 'OTHER ACTIVE' 10 'LOOKED AT ADS'
             11 'ATTENDED JOB TRAINING PROGRAMS/COURSES' 12 'NOTHING'
             13 'OTHER PASSIVE' /
   PULKPS5   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CONTACTED EMPLOYER DIRECTLY/ INTERVIEW'
             2 'CONTACTED PUBLIC EMPLOYMENT AGENCY'
             3 'CONTACTED PRIVATE EMPLOYMENT AGENCY'
             4 'CONTACTED FRIENDS OR RELATIVES'
             5 'CONTACTED SCHOOL/UNIVERSITY EMPL CENTER'
             6 'SENT OUT RESUMES/FILLED OU APPLICATION REGISTERS'
             8 'PLACED OR ANSWERED ADS' 9 'OTHER ACTIVE' 10 'LOOKED AT ADS'
             11 'ATTENDED JOB TRAINING PROGRAMS COURSES' 12 'NOTHING'
             13 'OTHER PASSIVE' /
   PULKPS6   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'CONTACTED EMPLOYER DIRECTLY/ INTERVIEW'
             2 'CONTACTED PUBLIC EMPLOYMENT AGENCY'
             3 'CONTACTED PRIVATE EMPLOYMENT AGENCY'
             4 'CONTACTED FRIENDS OR RELATIVES'
             5 'CONTACTED SCHOOL/UNIVERSITY EMPL CENTER'
             6 'SENT OUT RESUMES/FILLED OUT APPLICATION'
             7 'CHECKED UNION/PROFESSIONAL REGISTERS'
             8 'PLACED OR ANSWERED ADS' 9 'OTHER ACTIVE' 10 'LOOKED AT ADS'
             11 'ATTENDED JOB TRAINING PROGRAMS/COURSES' 12 'NOTHING'
             13 'OTHER PASSIVE' /
   PELKAVL   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PULKAVR   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'WAITING FOR NEW JOB TO BEGIN' 2 'OWN TEMPORARY ILLNESS'
             3 'GOING TO SCHOOL' 4 'OTHER - SPECIFY' /
   PELKLL1O  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'WORKING' 2 'SCHOOL' 3 'LEFT MILITARY SERVICE'
             4 'SOMETHING ELSE' /
   PELKLL2O  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'LOST JOB' 2 'QUIT JOB' 3 'TEMPORARY JOB ENDED' /
   PELKLWO   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'WITHIN THE LAST 12 MONTHS' 2 'MORE THAN 12 MONTHS AGO'
             3 'NEVER WORKED' /
   PELKDUR   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   PELKFTO   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' 3 'DOESN''T MATTER' /
   PEDWWNTO  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES, OR MAYBE, IT DEPENDS' 2 'NO' 3 'RETIRED' 4 'DISABLED'
             5 'UNABLE' /
   PEDWRSN   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'BELIEVES NO WORK AVAILABLE IN AREA OF EXPERTISE'
             2 'COULDN''T FIND ANY WORK'
             3 'LACKS NECESSARY SCHOOLING/TRAINING'
             4 'EMPLOYERS THINK TOO YOUNG OR TOO OLD'
             5 'OTHER TYPES OF DISCRIMINATION' 6 'CAN''T ARRANGE CHILD CARE'
             7 'FAMILY RESPONSIBILITIES' 8 'IN SCHOOL OR OTHER TRAINING'
             9 'ILL-HEALTH, PHYSICAL DISABILITY' 10 'TRANSPORTATION PROBLEMS'
             11 'OTHER - SPECIFY' /
   PEDWLKO   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PEDWWK    -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PEDW4WK   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PEDWLKWK  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PEDWAVL   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PEDWAVR   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'OWN TEMPORARY ILLNESS' 2 'GOING TO SCHOOL' 3 'OTHER' /
   PUDWCK1   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'IF ENTRY OF 2 IN BUS2 GOTO PUSCHCK'
             2 'IF ENTRY OF 3 ON ABSRSN GOTO PUNLFCK1'
             3 'IF ENTRY OF 1 IN RET1, STORE 1 IN DWWNTO AND GOTO PUDWCK4'
             4 'ALL OTHERS GOTO PUDWWNT' /
   PUDWCK2   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'IF ENTRY IN DIS1 OR DIS2 GOTO PUJHCK1-C'
             2 'IF ENTRY OF 4 IN DWWNT GOTO PUDIS1'
             3 'IF ENTRY OF 5 IN DWWNT GOTO PUDIS2'
             4 'ALL OTHERS GOTO PUDWCK4' /
   PUDWCK3   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'IF AGERNG EQUALS 1-4 OR 9 GOTO PUDWCK4'
             2 'ALL OTHERS GOTO PUNLFCK2' /
   PUDWCK4   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
        1 'IF ENTRY OF 10 AND/OR 11 AND/OR 13 ONLY IN LKM1-LKM3 GOTO PUDWCK5'
      2 'IF ENTRY OF 10 AND/OR 11 AND/OR 13 ONLY IN LKDK1-LKDK3 GOTO PUDWCK5'
      3 'IF ENTRY OF 10 AND/OR 11 AND/OR 13 ONLY IN LKPS1-LKPS3 GOTO PUDWCK5'
             4 'ALL OTHERS GOTO PUDWRSN' /
   PUDWCK5   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'IF ENTRY OF 1 IN LK THEN STORE 1 IN DWLKO AND GOTO PUDWWK'
             2 'ALL OTHERS GOTO PUDWLK' /
   PRABSREA  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'FT PAID-VACATION' 2 'FT PAID-OWN ILLNESS'
             3 'FT PAID-CHILD CARE PROBLEMS'
             4 'FT PAID-OTHER FAMILY/PERSONAL OBLIG.'
             5 'FT PAID-MATERNITY/PATERNITY LEAVE' 6 'FT PAID-LABOR DISPUTE'
             7 'FT PAID-WEATHER AFFECTED JOB' 8 'FT PAID-SCHOOL/TRAINING'
             9 'FT PAID-CIVIC/MILITARY DUTY' 10 'FT PAID-OTHER'
             11 'FT UNPAID-VACATION' 12 'FT UNPAID-OWN ILLNESS'
             13 'FT UNPAID-CHILD CARE PROBLEMS'
             14 'FT UNPAID-OTHER FAM/PERSONAL OBLIGATION'
             15 'FT UNPAID-MATERNITY/PATERNITY LEAVE'
             16 'FT UNPAID-LABOR DISPUTE' 17 'FT UNPAID-WEATHER AFFECTED JOB'
             18 'FT UNPAID-SCHOOL/TRAINING'
             19 'FT UNPAID-CIVIC/MILITARY DUTY' 20 'FT UNPAID-OTHER'
             21 'PT PAID-VACATION' 22 'PT PAID-OWN ILLNESS'
             23 'PT PAID-CHILD CARE PROBLEMS'
             24 'PT PAID-OTHER FAMILY/PERSONAL OBLIG.'
             25 'PT PAID-MATERNITY/PATERNITY LEAVE'
             26 'PT PAID-LABOR DISPUTE' 27 'PT PAID-WEATHER AFFECTED JOB'
             28 'PT PAID-SCHOOL/TRAINING' 29 'PT PAID-CIVIC/MILITARY DUTY'
             30 'PT PAID-OTHER' 31 'PT UNPAID-VACATION'
             32 'PT UNPAID-OWN ILLNESS' 33 'PT UNPAID-CHILD CARE PROBLEMS'
             34 'PT UNPAID-OTHER FAM/PERSONAL OBLIGATION'
             35 'PT UNPAID-MATERNITY/PATERNITY LEAVE'
             36 'PT UNPAID-LABOR DISPUTE' 37 'PT UNPAID-WEATHER AFFECTED JOB'
             38 'PT UNPAID-SCHOOL/TRAINING'
             39 'PT UNPAID-CIVIC/MILITARY DUTY' 40 'PT UNPAID-OTHER' /
   PRCIVLF   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'IN CIVILIAN LABOR FORCE' 2 'NOT IN CIVILIAN LABOR FORCE' /
   PRDISC    -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'DISCOURAGED WORKER' 2 'CONDITIONALLY INTERESTED'
             3 'NOT AVAILABLE' /
   PREMPHRS  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             0 'UNEMPLOYED AND NILF' 1 'W/JOB, NOT AT WORK-ILLNESS'
             2 'W/JOB, NOT AT WORK-VACATION'
             3 'W/JOB, NOT AT WORK-WEATHER AFFECTED JOB'
             4 'W/JOB, NOT AT WORK-LABOR DISPUTE'
             5 'W/JOB, NOT AT WORK-CHILD CARE PROBLEMS'
             6 'W/JOB, NOT AT WORK-FAM/PERS OBLIGATION'
             7 'W/JOB, NOT AT WORK-MATERNITY/ PATERNITY'
             8 'W/JOB, NOT AT WORK-SCHOOL/ TRAINING'
             9 'W/JOB, NOT AT WORK-CIVI MILITARY DUTY'
             10 'W/JOB, NOT AT WORK-DOES NOT WORK IN BUS'
             11 'W/JOB, NOT AT WORK-OTHER' 12 'AT WORK- 1-4 HRS'
             13 'AT WORK- 5-14 HRS' 14 'AT WORK- 15-21 HRS'
             15 'AT WORK- 22-29 HRS' 16 'AT WORK- 30-34 HRS'
             17 'AT WORK- 35-39 HRS' 18 'AT WORK- 40 HRS'
             19 'AT WORK- 41-47 HRS' 20 'AT WORK- 48 HRS'
             21 'AT WORK- 49-59 HRS' 22 'AT WORK- 60 HRS OR MORE' /
   PREMPNOT  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'EMPLOYED' 2 'UNEMPLOYED'
             3 'NOT IN LABOR FORCE (NILF)- DISCOURAGED'
             4 'NOT IN LABOR FORCE (NILF)- OTHER' /
   PREXPLF   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'EMPLOYED' 2 'UNEMPLOYED' /
   PRFTLF    -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'FULL TIME LABOR FORCE' 2 'PART TIME LABOR FORCE' /
   PRHRUSL   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 '0-20 HRS' 2 '21-34 HRS' 3 '35-39 HRS' 4 '40 HRS'
             5 '41-49 HRS' 6 '50 OR MORE HRS' 7 'VARIES-FULL TIME'
             8 'VARIES-PART TIME' /
   PRJOBSEA  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'LOOKED LAST 4 WEEKS - NOT WORKED'
             2 'LOOKED LAST 4 WEEKS - WORKED'
             3 'LOOKED LAST 4 WEEKS - LAYOFF' 4 'UNAVAILABLE JOB SEEKERS'
             5 'NO RECENT JOB SEARCH' /
   PRPTHRS   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             0 'USUALY FT, PT FOR NONECONOMIC REASONS'
             1 'USU.FT, PT ECON REASONS; 1-4 HRS'
             2 'USU.FT, PT ECON REASONS; 5-14 HRS'
             3 'USU.FT, PT ECON REASONS; 15-29 HRS'
             4 'USU.FT, PT ECON REASONS; 30-34 HRS'
             5 'USU.PT, ECON REASONS; 1-4 HRS'
             6 'USU.PT, ECON REASONS; 5-14 HRS'
             7 'USU.PT, ECON REASONS; 15-29 HRS'
             8 'USU.PT, ECON REASONS; 30-34 HRS'
             9 'USU.PT, NON-ECON REASONS; 1-4 HRS'
             10 'USU.PT, NON-ECON REASONS; 5-14 HRS'
             11 'USU.PT, NON-ECON REASONS; 15- 29 HRS'
             12 'USU.PT, NON-ECON REASONS; 30- 34 HRS' /
   PRPTREA   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'USU. FT-SLACK WORK/BUSINESS CONDITIONS'
             2 'USU. FT-SEASONAL WORK'
             3 'USU. FT-JOB STARTED/ENDED DURING WEEK'
             4 'USU. FT-VACATION/PERSONAL DAY'
             5 'USU. FT-OWN ILLNESS/ INJURY/MEDICAL APPOINTMENT'
             6 'USU. FT-HOLIDAY (RELIGIOUS OR LEGAL)'
             7 'USU. FT-CHILD CARE PROBLEMS'
             8 'USU. FT-OTHER FAM/PERS OBLIGATIONS' 9 'USU. FT-LABOR DISPUTE'
             10 'USU. FT-WEATHER AFFECTED JOB' 11 'USU. FT-SCHOOL/TRAINING'
             12 'USU. FT-CIVIC/MILITARY DUTY' 13 'USU. FT-OTHER REASON'
             14 'USU. PT-SLACK WORK/BUSINESS CONDITIONS'
             15 'USU. PT-COULD ONLY FIND PT WORK' 16 'USU. PT-SEASONAL WORK'
             17 'USU. PT-CHILD CARE PROBLEMS'
             18 'USU. PT-OTHER FAM/PERS OBLIGATIONS'
             19 'USU. PT-HEALTH/MEDICAL LIMITATIONS'
             20 'USU. PT-SCHOOL/TRAINING'
             21 'USU. PT-RETIRED/S.S. LIMIT ON EARNINGS'
             22 'USU. PT-WORKWEEK <35 HOURS' 23 'USU. PT-OTHER REASON' /
   PRUNEDUR  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   PRUNTYPE  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'JOB LOSER/ON LAYOFF' 2 'OTHER JOB LOSER'
             3 'TEMPORARY JOB ENDED' 4 'JOB LEAVER' 5 'RE-ENTRANT'
             6 'NEW-ENTRANT' /
   PRWKSCH   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             0 'NOT IN LABOR FORCE' 1 'AT WORK' 2 'WITH JOB, NOT AT WORK'
             3 'UNEMPLOYED, SEEKS FT' 4 'UNEMPLOYED, SEEKS PT' /
   PRWKSTAT  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'NOT IN LABOR FORCE' 2 'FT HOURS (35+), USUALLY FT'
             3 'PT FOR ECONOMIC REASONS, USUALLY FT'
             4 'PT FOR NON-ECONOMIC REASONS, USUALLY FT'
             5 'NOT AT WORK, USUALLY FT'
             6 'PT HRS, USUALLY PT FOR ECONOMIC REASONS'
             7 'PT HRS, USUALLY PT FOR NON- ECONOMIC REASONS'
             8 'FT HOURS, USUALLY PT FOR ECONOMIC REASONS'
             9 'FT HOURS, USUALLY PT FOR NON-ECONOMIC'
             10 'NOT AT WORK, USUALLY PART-TIME' 11 'UNEMPLOYED FT'
             12 'UNEMPLOYED PT' /
   PRWNTJOB  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'WANT A JOB' 2 'OTHER NOT IN LABOR FORCE' /
   PUIODP1   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PUIODP2   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PUIODP3   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PEIO1COW  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'GOVERNMENT - FEDERAL' 2 'GOVERNMENT - STATE'
             3 'GOVERNMENT - LOCAL' 4 'PRIVATE, FOR PROFIT'
             5 'PRIVATE, NONPROFIT' 6 'SELF-EMPLOYED, INCORPORATED'
             7 'SELF-EMPLOYED, UNINCORPORATED' 8 'WITHOUT PAY' /
   PUIO1MFG  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'MANUFACTURING' 2 'RETAIL TRADE' 3 'WHOLESALE TRADE'
             4 'SOMETHING ELSE' /
   PUIOCK1   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
 1 'IF {MISCK EQ 1 OR 5) OR MISCK EQ 2-4, 6-8 AND I-MLR EQ 3-7) AND ENTRY OF 1 IN ABS} THEN GOTO PUIO1INT'
 2 'IF (MISCK EQ 1 OR 5) OR {(MISCK EQ 2-4, 6-8 AND I-MLR EQ 3-7) AND ( ENTRY OF 1 IN WK OR HRCK7-C IS BLANK, 1-3)}GOTO PUIO'
             3 'IF I-IO1NAM IS D, R OR BLANK THEN GOTO PUIO1INT'
             4 'ALL OTHERS GOTO PUIODP1' /
   PUIOCK2   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'IF I-IO1ICR EQ 1 THEN GOTO PUIO1IND'
             2 'IF I-IO1OCR EQ 1 THEN GOTO PUIO1OCC'
             3 'ALL OTHERS GOTO PUIODP2' /
   PUIOCK3   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'IF I-IO1OCC EQUALS D, R OR BLANK THEN GOTO PUIO1OCC'
             2 'IF I-IO1DT1 IS D, R OR BLANK THEN GOTO PUIO1OCC'
             3 'ALL OTHERS GOTO PUIODP3' /
   PRIOELG   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             0 'NOT ELIGIBLE FOR EDIT' 1 'ELIGIBLE FOR EDIT' /
   PRAGNA    -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'AGRICULTURAL' 2 'NON-AGRICULTURAL' /
   PRCOW1    -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'FEDERAL GOVT' 2 'STATE GOVT' 3 'LOCAL GOVT'
             4 'PRIVATE (INCL. SELF- EMPLOYED INCORP.)'
             5 'SELF-EMPLOYED, UNINCORP.' 6 'WITHOUT PAY' /
   PRCOWPG   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'PRIVATE' 2 'GOVERNMENT' /
   PRDTCOW1  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'AGRI., WAGE & SALARY, PRIVATE'
             2 'AGRI., WAGE & SALARY, GOVERNMENT' 3 'AGRI., SELF-EMPLOYED'
             4 'AGRI., UNPAID' 5 'NONAG, WS, PRIVATE, PRIVATE HHLDS'
             6 'NONAG, WS, PRIVATE, OTHER PRIVATE'
             7 'NONAG, WS, GOVT, FEDERAL' 8 'NONAG, WS, GOVT, STATE'
             9 'NONAG, WS, GOVT, LOCAL' 10 'NONAG, SELF-EMPLOYED'
             11 'NONAG, UNPAID' /
   PRDTIND1  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'AGRICULTURE'
             2 'FORESTRY, LOGGING, FISHING, HUNTING, AND TRAPPING' 3 'MINING'
             4 'CONSTRUCTION' 5 'NONMETALLIC MINERAL PRODUCT MANUFACTURING'
             6 'PRIMARY METALS AND FABRICATED METAL PRODUCTS'
             7 'MACHINERY MANUFACTURING'
             8 'COMPUTER AND ELECTRONIC PRODUCT MANUFACTURING'
             9 'ELECTRICAL EQUIPMENT, APPLIANCE MANUFACTURING'
             10 'TRANSPORTATION EQUIPMENT MANUFACTURING' 11 'WOOD PRODUCTS'
             12 'FURNITURE AND FIXTURES MANUFACTURING'
             13 'MISCELLANEOUS AND NOT SPECIFIED MANUFACTURING'
             14 'FOOD MANUFACTURING' 15 'BEVERAGE AND TOBACCO PRODUCTS'
             16 'TEXTILE, APPAREL, AND LEATHER MANUFACTURING'
             17 'PAPER AND PRINTING'
             18 'PETROLEUM AND COAL PRODUCTS MANUFACTURING'
             19 'CHEMICAL MANUFACTURING' 20 'PLASTICS AND RUBBER PRODUCTS'
             21 'WHOLESALE TRADE' 22 'RETAIL TRADE'
             23 'TRANSPORTATION AND WAREHOUSING' 24 'UTILITIES'
             25 'PUBLISHING INDUSTRIES (EXCEPT INTERNET)'
             26 'MOTION PICTURE AND SOUND RECORDING INDUSTRIES'
             27 'BROADCASTING (EXCEPT INTERNET)'
             28 'INTERNET PUBLISHING AND BROADCASTING'
             29 'TELECOMMUNICATIONS'
             30 'INTERNET SERVICE PROVIDERS AND DATA PROCESSING SERVICES'
             31 'OTHER INFORMATION SERVICES' 32 'FINANCE' 33 'INSURANCE'
             34 'REAL ESTATE' 35 'RENTAL AND LEASING SERVICES'
             36 'PROFESSIONAL AND TECHNICAL SERVICES'
             37 'MANAGEMENT OF COMPANIES AND ENTERPRISES'
             38 'ADMINISTRATIVE AND SUPPORT SERVICES'
             39 'WASTE MANAGEMENT AND REMEDIATION SERVICES'
             40 'EDUCATIONAL SERVICES' 41 'HOSPITALS'
             42 'HEALTH CARE SERVICES, EXCEPT HOSPITALS'
             43 'SOCIAL ASSISTANCE' 44 'ARTS, ENTERTAINMENT, AND RECREATION'
             45 'ACCOMMODATION' 46 'FOOD SERVICES AND DRINKING PLACES'
             47 'REPAIR AND MAINTENANCE' 48 'PERSONAL AND LAUNDRY SERVICES'
             49 'MEMBERSHIP ASSOCIATIONS AND ORGANIZATIONS'
             50 'PRIVATE HOUSEHOLDS' 51 'PUBLIC ADMINISTRATION'
             52 'ARMED FORCES' /
   PRDTOCC1  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'MANAGEMENT OCCUPATIONS'
             2 'BUSINESS AND FINANCIAL OPERATIONS OCCUPATIONS'
             3 'COMPUTER AND MATHEMATICAL SCIENCE OCCUPATIONS'
             4 'ARCHITECTURE AND ENGINEERING OCCUPATIONS'
             5 'LIFE, PHYSICAL, AND SOCIAL SCIENCE OCCUPATIONS'
             6 'COMMUNITY AND SOCIAL SERVICE OCCUPATIONS'
             7 'LEGAL OCCUPATIONS'
             8 'EDUCATION, TRAINING, AND LIBRARY OCCUPATIONS'
             9 'ARTS, DESIGN, ENTERTAINMENT, SPORTS, AND MEDIA OCCUPATIONS'
             10 'HEALTHCARE PRACTITIONER AND TECHNICAL OCCUPATIONS'
             11 'HEALTHCARE SUPPORT OCCUPATIONS'
             12 'PROTECTIVE SERVICE OCCUPATIONS'
             13 'FOOD PREPARATION AND SERVING RELATED OCCUPATIONS'
             14 'BUILDING AND GROUNDS CLEANING AND MAINTENANCE OCCUPATIONS'
             15 'PERSONAL CARE AND SERVICE OCCUPATIONS'
             16 'SALES AND RELATED OCCUPATIONS'
             17 'OFFICE AND ADMINISTRATIVE SUPPORT OCCUPATIONS'
             18 'FARMING, FISHING, AND FORESTRY OCCUPATIONS'
             19 'CONSTRUCTION AND EXTRACTION OCCUPATIONS'
             20 'INSTALLATION, MAINTENANCE, AND REPAIR OCCUPATIONS'
             21 'PRODUCTION OCCUPATIONS'
             22 'TRANSPORTATION AND MATERIAL MOVING OCCUPATIONS'
             23 'ARMED FORCES' /
   PREMP     -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'EMPLOYED PERSONS (EXC. FARM & PRIV HH)' /
   PRMJIND1  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'AGRICULTURE, FORESTRY, FISHING, AND HUNTING' 2 'MINING'
             3 'CONSTRUCTION' 4 'MANUFACTURING'
             5 'WHOLESALE AND RETAIL TRADE' 6 'TRANSPORTATION AND UTILITIES'
             7 'INFORMATION' 8 'FINANCIAL ACTIVITIES'
             9 'PROFESSIONAL AND BUSINESS SERVICES'
             10 'EDUCATIONAL AND HEALTH SERVICES'
             11 'LEISURE AND HOSPITALITY' 12 'OTHER SERVICES'
             13 'PUBLIC ADMINISTRATION' 14 'ARMED FORCES' /
   PRMJOCC1  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'MANAGEMENT, BUSINESS, AND FINANCIAL OCCUPATIONS'
             2 'PROFESSIONAL AND RELATED OCCUPATIONS' 3 'SERVICE OCCUPATIONS'
             4 'SALES AND RELATED OCCUPATIONS'
             5 'OFFICE AND ADMINISTRATIVE SUPPORT OCCUPATIONS'
             6 'FARMING, FISHING, AND FORESTRY OCCUPATIONS'
             7 'CONSTRUCTION AND EXTRACTION OCCUPATIONS'
             8 'INSTALLATION, MAINTENANCE, AND REPAIR OCCUPATIONS'
             9 'PRODUCTION OCCUPATIONS'
             10 'TRANSPORTATION AND MATERIAL MOVING OCCUPATIONS'
             11 'ARMED FORCES' /
   PRMJOCGR  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'MANAGEMENT, PROFESSIONAL, AND RELATED OCCUPATIONS'
             2 'SERVICE OCCUPATIONS' 3 'SALES AND OFFICE OCCUPATIONS'
             4 'FARMING, FISHING, AND FORESTRY OCCUPATIONS'
             5 'CONSTRUCTION, AND MAINTENANCE OCCUPATIONS'
             6 'PRODUCTION, TRANSPORTATION, AND MATERIAL MOVING OCCUPATIONS'
             7 'ARMED FORCES' /
   PRNAGPWS  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'NON-AG PRIV WAGE & SALARY' /
   PRNAGWS   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'NON-AG WAGE AND SALARY WORKERS' /
   PRSJMJ    -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'SINGLE JOBHOLDER' 2 'MULTIPLE JOBHOLDER' /
   PESCHENR  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'YES' 2 'NO' /
   PESCHFT   -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'FULL-TIME' 2 'PART-TIME' /
   PESCHLVL  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'HIGH SCHOOL' 2 'COLLEGE OR UNIVERSITY' /
   PRNLFSCH  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'IN SCHOOL' 2 'NOT IN SCHOOL' /
   PRCHLD    -3 'REFUSED' -2 'DON''T KNOW' -1 'NIU (NOT A PARENT)'
             0 'NO OWN CHILDREN UNDER 18 YEARS OF AGE'
             1 'ALL OWN CHILDREN 0- 2 YEARS OF AGE'
             2 'ALL OWN CHILDREN 3- 5 YEARS OF AGE'
             3 'ALL OWN CHILDREN 6-13 YEARS OF AGE'
             4 'ALL OWN CHILDREN 14-17 YEARS OF AGE'
             5 'OWN CHILDREN 0- 2 AND 3- 5 YEARS OF AGE (NONE 6-17)'
             6 'OWN CHILDREN 0- 2 AND 6-13 YEARS OF AGE (NONE 3- 5 OR 14-17)'
             7 'OWN CHILDREN 0- 2 AND 14-17 YEARS OF AGE (NONE 3-13)'
             8 'OWN CHILDREN 3- 5 AND 6-13 YEARS OF AGE (NONE 0- 2 OR 14-17)'
             9 'OWN CHILDREN 3- 5 AND 14-17 YEARS OF AGE (NONE 0- 2 OR 6-13)'
             10 'OWN CHILDREN 6-13 AND 14-17 YEARS OF AGE (NONE 0- 5)'
             11 'OWN CHILDREN 0- 2, 3- 5, AND 6-13 YEARS OF AGE (NONE 14-17)'
             12 'OWN CHILDREN 0- 2, 3- 5, AND 14-17 YEARS OF AGE (NONE 6-13)'
             13 'OWN CHILDREN 0- 2, 6-13, AND 14-17 YEARS OF AGE (NONE 3- 5)'
             14 'OWN CHILDREN 3- 5, 6-13, AND 14-17 YEARS OF AGE (NONE 0- 2)'
             15 'OWN CHILDREN FROM ALL AGE GROUPS' /
   PRNMCHLD  -1 'NIU (NOT A PARENT)' /
   HXTENURE  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   HXHOUSUT  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   HXTELHHD  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   HXTELAVL  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   HXPHONEO  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXINUSYR  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXRRP     -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXPARENT  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXAGE     -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXMARITL  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXSPOUSE  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXSEX     -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXAFWHEN  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXAFNOW   -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXEDUCA   -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXRACE1   -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXNATVTY  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXMNTVTY  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXFNTVTY  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXHSPNON  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXMLR     -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXRET1    -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXABSRSN  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXABSPDO  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXMJOT    -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXMJNUM   -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXHRUSL1  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXHRUSL2  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXHRFTPT  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXHRUSLT  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXHRWANT  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXHRRSN1  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXHRRSN2  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXHRACT1  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXHRACT2  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXHRACTT  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXHRRSN3  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXHRAVL   -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXLAYAVL  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXLAYLK   -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXLAYDUR  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXLAYFTO  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXLKM1    -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXLKAVL   -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXLKLL1O  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXLKLL2O  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXLKLWO   -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXLKDUR   -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXLKFTO   -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXDWWNTO  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXDWRSN   -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXDWLKO   -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXDWWK    -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXDW4WK   -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXDWLKWK  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXDWAVL   -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXDWAVR   -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXIO1COW  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXIO1ICD  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXIO1OCD  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXSCHENR  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXSCHFT   -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXSCHLVL  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PEDIPGED  -1 'NOT IN UNIVERSE' 1 'GRADUATION FROM HIGH SCHOOL'
             2 'GED OR OTHER EQUIVALENT' /
   PEHGCOMP  -1 'NOT IN UNIVERSE' 1 'LESS THAN 1ST GRADE'
             2 '1ST, 2ND, 3RD, OR 4TH GRADE' 3 '5TH OR 6TH GRADE'
             4 '7TH OR 8TH GRADE' 5 '9TH GRADE' 6 '10TH GRADE' 7 '11TH GRADE'
             8 '12TH GRADE (NO DIPLOMA)' /
   PECYC     -1 'NOT IN UNIVERSE'
             1 'LESS THAN 1 YEAR (INCLUDES 0 YEARS COMPLETED)'
             2 'THE FIRST OR FRESHMAN YEAR' 3 'THE SECOND OR SOPHOMORE YEAR'
             4 'THE THIRD OR JUNIOR YEAR' 5 'FOUR OR MORE YEARS' /
   PEGRPROF  -1 'NOT IN UNIVERSE' 1 'YES' 2 'NO' /
   PEGR6COR  -1 'NOT IN UNIVERSE' 1 'YES' 2 'NO' /
   PEMS123   -1 'NOT IN UNIVERSE' 1 '1 YEAR PROGRAM' 2 '2 YEAR PROGRAM'
             3 '3 YEAR PROGRAM' /
   PXDIPGED  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXHGCOMP  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXCYC     -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXGRPROF  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXGR6COR  -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PXMS123   -1 'NOT ALLOCATED' 0 'VALUE - NO CHANGE' 1 'BLANK - NO CHANGE'
             2 'DON''T KNOW - NO CHANGE' 3 'REFUSED - NO CHANGE'
             10 'VALUE TO VALUE' 11 'BLANK TO VALUE'
             12 'DON''T KNOW TO VALUE' 13 'REFUSED TO VALUE'
             20 'VALUE TO LONGITUDINAL VALUE'
             21 'BLANK TO LONGITUDINAL VALUE'
             22 'DON''T KNOW TO LONGITUDINAL VALUE'
             23 'REFUSED TO LONGITUDINAL VALUE'
             30 'VALUE TO ALLOCATED VALUE LONG.'
             31 'BLANK TO ALLOCATED VALUE LONG.'
             32 'DON''T KNOW TO ALLOCATED VALUE LONG.'
             33 'REFUSED TO ALLOCATED VALUE LONG.'
             40 'VALUE TO ALLOCATED VALUE' 41 'BLANK TO ALLOCATED VALUE'
             42 'DON''T KNOW TO ALLOCATED VALUE'
             43 'REFUSED TO ALLOCATED VALUE' 50 'VALUE TO BLANK'
             52 'DON''T KNOW TO BLANK' 53 'REFUSED TO BLANK' /
   PEIO1ICD  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   PEIO1OCD  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE' /
   PRIMIND1  -3 'REFUSED' -2 'DON''T KNOW' -1 'BLANK OR NOT IN UNIVERSE'
             1 'AGRICULTURE, FORESTRY, FISHING, and HUNTING' 2 'MINING'
             3 'CONSTRUCTION' 4 'MANUFACTURING - DURABLE GOODS'
             5 'MANUFACTURING - NON-DURABLE GOODS' 6 'WHOLESALE TRADE'
             7 'RETAIL TRADE' 8 'TRANSPORTATION AND WAREHOUSING'
             9 'UTILITIES' 10 'INFORMATION' 11 'FINANCE AND INSURANCE'
             12 'REAL ESTATE AND RENTAL AND LEASING'
             13 'PROFESSIONAL AND TECHNICAL SERVICES'
             14 'MANAGEMENT, ADMINISTRATIVE AND WASTE MANAGEMENT SERVICES'
             15 'EDUCATIONAL SERVICES' 16 'HEALTH CARE AND SOCIAL SERVICES'
             17 'ARTS, ENTERTAINMENT, AND RECREATION'
             18 'ACCOMMODATION AND FOOD SERVICES' 19 'PRIVATE HOUSEHOLDS'
             20 'OTHER SERVICES, EXCEPT PRIVATE HOUSEHOLDS'
             21 'PUBLIC ADMINISTRATION' 22 'ARMED FORCES' /
   HEPORT    -9 'No response' -3 'Refused' -2 'Don''t know'
             -1 'Blank or Not in Universe' 1 'Personal' 2 'Telephone' /
   HEQ1      -9 'No response' -3 'Refused' -2 'Don''t know'
             -1 'Blank or Not in Universe' /
   HEQ1A     -9 'No response' -3 'Refused' -2 'Don''t know'
             -1 'Blank or Not in Universe' /
   HEQ1B     -9 'No response' -3 'Refused' -2 'Don''t know'
             -1 'Blank or Not in Universe' 1 'Yes' 2 'No' /
   HEQ2      -9 'No response' -3 'Refused' -2 'Don''t know'
             -1 'Blank or Not in Universe' 1 'Yes' 2 'No' /
   HEQ2A     -9 'No response' -3 'Refused' -2 'Don''t know'
             -1 'Blank or Not in Universe' /
   HEQ2B     -9 'No response' -3 'Refused' -2 'Don''t know'
             -1 'Blank or Not in Universe' /
   HEQ2C     -9 'No response' -3 'Refused' -2 'Don''t know'
             -1 'Blank or Not in Universe' /
   HEQ2D     -9 'No response' -3 'Refused' -2 'Don''t know'
             -1 'Blank or Not in Universe' 1 'Yes' 2 'No' /
   HEQ2E     -9 'No response' -3 'Refused' -2 'Don''t know'
             -1 'Blank or Not in Universe' 1 'Yes' 2 'No' /
   HEQ3      -9 'No response' -3 'Refused' -2 'Don''t know'
             -1 'Blank or Not in Universe' 1 'All or almost all calls,'
             2 'More than half,' 3 'Less than half, or' 4 'Very few or none?'
             /
   HRSUPINT  1 'Interview' 2 'Noninterview' /
   .

EXECUTE.

* Create SPSS system file.

*SAVE OUTFILE="spss-filename.sav".
