/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.search.task.profile;

import choco.cp.common.util.preprocessor.detector.scheduling.DisjunctiveSModel;
import choco.cp.solver.constraints.global.scheduling.precedence.ITemporalSRelation;
import choco.cp.solver.search.task.OrderingValSelector;
import choco.cp.solver.search.task.profile.ProbabilisticProfile;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.constraints.ITemporalRelation;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.global.scheduling.IResource;
import choco.kernel.solver.search.integer.IntVarValPair;
import choco.kernel.solver.search.integer.VarValPairSelector;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.BitSet;
import java.util.Iterator;

public final class ProfileSelector
implements VarValPairSelector {
    private final Solver solver;
    private final OrderingValSelector precSelector;
    private DisjunctiveSModel disjSModel;
    private final ProbabilisticProfile profiles;
    public final IResource<?>[] rscL;

    public ProfileSelector(Solver solver, IResource<?>[] resources, DisjunctiveSModel disjSModel, OrderingValSelector precSelector) {
        this.solver = solver;
        this.disjSModel = disjSModel;
        this.precSelector = precSelector;
        this.profiles = new ProbabilisticProfile(solver, disjSModel);
        this.rscL = resources;
    }

    public ProfileSelector(Solver solver, DisjunctiveSModel disjSModel, OrderingValSelector precSelector) {
        this.solver = solver;
        this.disjSModel = disjSModel;
        this.precSelector = precSelector;
        this.profiles = new ProbabilisticProfile(solver, disjSModel);
        this.rscL = new IResource[solver.getModel().getNbConstraintByType(ConstraintType.DISJUNCTIVE)];
        Iterator<Constraint> iter = solver.getModel().getConstraintByType(ConstraintType.DISJUNCTIVE);
        int cpt = 0;
        while (iter.hasNext()) {
            this.rscL[cpt++] = (IResource)((Object)solver.getCstr(iter.next()));
        }
    }

    @Override
    public IntVarValPair selectVarValPair() throws ContradictionException {
        this.profiles.initializeEvents();
        this.profiles.computeMaximum(this.rscL);
        int c = this.profiles.getMaxProfileCoord();
        if (c >= 0) {
            BitSet involved = this.profiles.getInvolvedInMaxProf();
            ITemporalRelation sdisjunct = null;
            double maxContrib = Double.MIN_VALUE;
            int i = involved.nextSetBit(0);
            while (i >= 0) {
                TaskVar t1 = this.solver.getTaskVarQuick(i);
                assert (t1.getID() == i);
                double contrib1 = this.profiles.getIndividualContribution(t1, c);
                int j = involved.nextSetBit(i + 1);
                while (j >= 0) {
                    ITemporalSRelation disjunct;
                    TaskVar t2 = this.solver.getTaskVarQuick(j);
                    assert (t2.getID() == j);
                    double contrib = contrib1 + this.profiles.getIndividualContribution(t1, c);
                    if (contrib > maxContrib && this.disjSModel.containsEdge(t1, t2) && !(disjunct = this.disjSModel.getConstraint(t1, t2)).isFixed()) {
                        sdisjunct = disjunct;
                        maxContrib = contrib;
                    }
                    j = involved.nextSetBit(j + 1);
                }
                i = involved.nextSetBit(i + 1);
            }
            assert (sdisjunct != null);
            return new IntVarValPair((IntDomainVar)sdisjunct.getDirection(), this.precSelector.getBestVal((ITemporalSRelation)sdisjunct));
        }
        assert (this.disjSModel.isFixed());
        return null;
    }
}

