/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.detector.scheduling;

import choco.Choco;
import choco.cp.common.util.preprocessor.detector.scheduling.AbstractRscDetector;
import choco.cp.common.util.preprocessor.detector.scheduling.PPResource;
import choco.cp.model.CPModel;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;
import java.util.ArrayList;
import java.util.List;

public final class DisjFromCumulModelDetector
extends AbstractRscDetector {
    private List<TaskVariable> tasks;
    private List<IntegerVariable> usages;

    public DisjFromCumulModelDetector(CPModel model) {
        super(model, null);
    }

    @Override
    protected ConstraintType getType() {
        return ConstraintType.CUMULATIVE;
    }

    @Override
    protected void setUp() {
        super.setUp();
        this.tasks = new ArrayList<TaskVariable>();
        this.usages = new ArrayList<IntegerVariable>();
    }

    @Override
    protected void tearDown() {
        super.tearDown();
        this.tasks = null;
        this.usages = null;
    }

    private void addTask(PPResource rsc, int idx) {
        this.tasks.add(rsc.getTask(idx));
        if (idx >= rsc.getParameters().getNbRegularTasks()) {
            this.usages.add(rsc.getUsage(idx));
        }
    }

    private TaskVariable[] tasks() {
        return this.tasks.toArray(new TaskVariable[this.tasks.size()]);
    }

    private IntegerVariable[] usages() {
        return this.usages.toArray(new IntegerVariable[this.usages.size()]);
    }

    @Override
    protected void apply(PPResource ppr) {
        this.tasks.clear();
        this.usages.clear();
        int capa = ppr.getMaxCapa();
        boolean addExtraTask = capa % 2 == 0;
        int limit = capa / 2;
        int n = ppr.getParameters().getNbTasks();
        for (int i = 0; i < n; ++i) {
            int h = ppr.getMinHeight(i);
            if (h > limit) {
                this.addTask(ppr, i);
                continue;
            }
            if (addExtraTask && h == limit) {
                this.addTask(ppr, i);
                addExtraTask = false;
                continue;
            }
            if (h >= 0) continue;
            this.tasks.clear();
            this.usages.clear();
            return;
        }
        int nc = this.tasks.size();
        if (nc > 2) {
            if (this.usages.isEmpty()) {
                this.add(Choco.disjunctive(this.tasks(), "ppcp:no_detection"));
            } else {
                this.add(Choco.disjunctive(this.tasks(), this.usages(), "ppcp:no_detection"));
            }
            if (nc == ppr.getParameters().getNbTasks()) {
                this.delete(ppr.getConstraint());
            }
        }
    }
}

