/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.extension;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.extension.BinRelation;
import choco.kernel.solver.constraints.integer.extension.CspBinSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class AC2001BinSConstraint
extends CspBinSConstraint {
    protected IStateInt[] currentSupport0;
    protected IStateInt[] currentSupport1;
    protected int offset0;
    protected int offset1;

    public AC2001BinSConstraint(IntDomainVar x0, IntDomainVar x1, BinRelation relation, IEnvironment environment) {
        super(x0, x1, relation);
        int i;
        this.offset0 = x0.getInf();
        this.offset1 = x1.getInf();
        this.currentSupport0 = new IStateInt[x0.getSup() - x0.getInf() + 1];
        this.currentSupport1 = new IStateInt[x1.getSup() - x1.getInf() + 1];
        for (i = 0; i < this.currentSupport0.length; ++i) {
            this.currentSupport0[i] = environment.makeInt();
            this.currentSupport0[i].set(-1);
        }
        for (i = 0; i < this.currentSupport1.length; ++i) {
            this.currentSupport1[i] = environment.makeInt();
            this.currentSupport1[i].set(-1);
        }
    }

    @Override
    public final int getFilteredEventMask(int idx) {
        return 12;
    }

    public void reviseV1() throws ContradictionException {
        int left;
        DisposableIntIterator itv1 = this.v1.getDomain().getIterator();
        int right = left = Integer.MIN_VALUE;
        while (itv1.hasNext()) {
            int x = itv1.next();
            if (this.v0.canBeInstantiatedTo(this.currentSupport1[x - this.offset1].get())) continue;
            boolean found = false;
            int support = this.currentSupport1[x - this.offset1].get();
            int max1 = this.v0.getSup();
            while (!found && support < max1) {
                support = this.v0.getDomain().getNextValue(support);
                if (!this.relation.isConsistent(support, x)) continue;
                found = true;
            }
            if (found) {
                this.currentSupport1[x - this.offset1].set(support);
                continue;
            }
            if (x == right + 1) {
                right = x;
                continue;
            }
            this.v1.removeInterval(left, right, this, false);
            left = right = x;
        }
        this.v1.removeInterval(left, right, this, false);
        itv1.dispose();
    }

    public void reviseV0() throws ContradictionException {
        int left;
        DisposableIntIterator itv0 = this.v0.getDomain().getIterator();
        int right = left = Integer.MIN_VALUE;
        while (itv0.hasNext()) {
            int x = itv0.next();
            if (this.v1.canBeInstantiatedTo(this.currentSupport0[x - this.offset0].get())) continue;
            boolean found = false;
            int support = this.currentSupport0[x - this.offset0].get();
            int max2 = this.v1.getSup();
            while (!found && support < max2) {
                support = this.v1.getDomain().getNextValue(support);
                if (!this.relation.isConsistent(x, support)) continue;
                found = true;
            }
            if (found) {
                this.currentSupport0[x - this.offset0].set(support);
                continue;
            }
            if (x == right + 1) {
                right = x;
                continue;
            }
            this.v0.removeInterval(left, right, this, false);
            left = right = x;
        }
        this.v0.removeInterval(left, right, this, false);
        itv0.dispose();
    }

    @Override
    public void awake() throws ContradictionException {
        DisposableIntIterator itv1;
        int left;
        DisposableIntIterator itv0 = this.v0.getDomain().getIterator();
        int support = 0;
        boolean found = false;
        int right = left = Integer.MIN_VALUE;
        while (itv0.hasNext()) {
            itv1 = this.v1.getDomain().getIterator();
            int val0 = itv0.next();
            while (itv1.hasNext()) {
                int val1 = itv1.next();
                if (!this.relation.isConsistent(val0, val1)) continue;
                support = val1;
                found = true;
                break;
            }
            itv1.dispose();
            if (!found) {
                if (val0 == right + 1) {
                    right = val0;
                } else {
                    this.v0.removeInterval(left, right, this, false);
                    left = val0;
                    right = val0;
                }
            } else {
                this.currentSupport0[val0 - this.offset0].set(support);
            }
            found = false;
        }
        this.v0.removeInterval(left, right, this, false);
        itv0.dispose();
        found = false;
        left = Integer.MIN_VALUE;
        right = Integer.MIN_VALUE;
        itv1 = this.v1.getDomain().getIterator();
        while (itv1.hasNext()) {
            itv0 = this.v0.getDomain().getIterator();
            int val1 = itv1.next();
            while (itv0.hasNext()) {
                int val0 = itv0.next();
                if (!this.relation.isConsistent(val0, val1)) continue;
                support = val0;
                found = true;
                break;
            }
            itv0.dispose();
            if (!found) {
                if (val1 == right + 1) {
                    right = val1;
                } else {
                    this.v1.removeInterval(left, right, this, false);
                    left = val1;
                    right = val1;
                }
            } else {
                this.currentSupport1[val1 - this.offset1].set(support);
            }
            found = false;
        }
        this.v1.removeInterval(left, right, this, false);
        itv1.dispose();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.reviseV0();
        this.reviseV1();
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        if (idx == 0) {
            this.reviseV1();
        } else {
            this.reviseV0();
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx == 0) {
            this.reviseV1();
        } else {
            this.reviseV0();
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx == 0) {
            this.reviseV1();
        } else {
            this.reviseV0();
        }
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
        if (idx == 0) {
            this.reviseV1();
        } else {
            this.reviseV0();
        }
    }

    @Override
    public void awakeOnBounds(int varIndex) throws ContradictionException {
        if (varIndex == 0) {
            this.reviseV1();
        } else {
            this.reviseV0();
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (idx == 0) {
            int left;
            int value = this.v0.getVal();
            int right = left = Integer.MIN_VALUE;
            DisposableIntIterator itv1 = this.v1.getDomain().getIterator();
            while (itv1.hasNext()) {
                int val = itv1.next();
                if (this.relation.isConsistent(value, val)) continue;
                if (val == right + 1) {
                    right = val;
                    continue;
                }
                this.v1.removeInterval(left, right, this, false);
                left = val;
                right = val;
            }
            this.v1.removeInterval(left, right, this, false);
            itv1.dispose();
        } else {
            int left;
            int value = this.v1.getVal();
            int right = left = Integer.MIN_VALUE;
            DisposableIntIterator itv0 = this.v0.getDomain().getIterator();
            while (itv0.hasNext()) {
                int val = itv0.next();
                if (this.relation.isConsistent(val, value)) continue;
                if (val == right + 1) {
                    right = val;
                    continue;
                }
                this.v0.removeInterval(left, right, this, false);
                left = val;
                right = val;
            }
            this.v0.removeInterval(left, right, this, false);
            itv0.dispose();
        }
    }

    @Override
    public String pretty() {
        StringBuilder sb = new StringBuilder();
        sb.append("AC2001(").append(this.v0.pretty()).append(", ").append(this.v1.pretty()).append(", ").append(this.relation.getClass().getSimpleName()).append(")");
        return sb.toString();
    }
}

