/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.resources;

import com.qarks.util.PreferenceManagerImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class ResourceManager {
    private static ResourceManager instance = null;
    private Locale currentLocale;
    private List<String> bundleNames = new ArrayList<String>();
    private List<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
    private static final Locale defaultLocale = Locale.ENGLISH;
    public static final Locale[] supportedLocales = new Locale[]{defaultLocale};

    private ResourceManager() {
        try {
            this.init();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static Locale[] getSupportedLocales() {
        return supportedLocales;
    }

    public void init() throws IOException {
        String string = PreferenceManagerImpl.getInstance().getProperty("locale.current", defaultLocale.getDisplayName());
        for (int i = 0; this.currentLocale == null && i < supportedLocales.length; ++i) {
            Locale locale = supportedLocales[i];
            if (!locale.getDisplayName().equals(string)) continue;
            this.currentLocale = locale;
        }
        if (this.currentLocale == null) {
            this.currentLocale = defaultLocale;
        }
    }

    public static synchronized ResourceManager getInstance() {
        if (instance == null) {
            instance = new ResourceManager();
        }
        return instance;
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public void setCurrentLocale(Locale locale) throws IOException {
        PreferenceManagerImpl.getInstance().setProperty("locale.current", locale.getDisplayName());
        PreferenceManagerImpl.getInstance().flush();
        this.currentLocale = locale;
        this.bundles.clear();
        for (String string : this.bundleNames) {
            this.bundles.add(ResourceBundle.getBundle(string, this.currentLocale));
        }
    }

    public void addBundleName(String string) {
        if (!this.bundleNames.contains(string)) {
            this.bundleNames.add(string);
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, this.currentLocale);
            this.bundles.add(resourceBundle);
        }
    }

    public static String getString(Object object) {
        return ResourceManager.getInstance().getString(object.toString());
    }

    public String getString(String string) {
        String string2 = null;
        for (int i = 0; string2 == null && i < this.bundles.size(); ++i) {
            ResourceBundle resourceBundle = this.bundles.get(i);
            try {
                string2 = resourceBundle.getString(string);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static String getString(Object object, Object ... objectArray) {
        String string = ResourceManager.getString(object);
        try {
            string = String.format(string, objectArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string;
    }

    static {
        ResourceManager.getInstance().addBundleName("resources/util/properties/TextResources");
    }
}

