/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.structure;

import java.util.Arrays;
import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateBitSet;
import org.chocosolver.memory.structure.S64BitSet;

public class SparseBitSet
implements IStateBitSet {
    private final int blockSize;
    private final S64BitSet index;
    private IStateBitSet[] blocks;
    private final IEnvironment env;

    public SparseBitSet(IEnvironment env, int blockSize) {
        this.env = env;
        if (blockSize <= 0) {
            throw new IllegalArgumentException("Block size must be > 0. Got " + blockSize);
        }
        this.blockSize = blockSize;
        this.blocks = new IStateBitSet[0];
        this.index = new S64BitSet(env);
    }

    private static void requirePositiveIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Positive index expected. Got " + index);
        }
    }

    private static void validIndexRange(int from, int to) {
        SparseBitSet.requirePositiveIndex(from);
        SparseBitSet.requirePositiveIndex(to);
        if (from > to) {
            throw new IndexOutOfBoundsException("Invalid range: [" + from + ", " + to + ")");
        }
    }

    private int blockIndex(int bit) {
        return bit / this.blockSize;
    }

    private int absIndex(int blockIdx, int localIndex) {
        return blockIdx * this.blockSize + localIndex;
    }

    private int localIndex(int absIndex) {
        return absIndex % this.blockSize;
    }

    private void ensureIndexCapacity(int size) {
        if (size >= this.blocks.length) {
            this.blocks = Arrays.copyOf(this.blocks, size + 1);
        }
    }

    private IStateBitSet ensureBlock(int blockIndex) {
        if (this.blocks[blockIndex] == null) {
            this.blocks[blockIndex] = new S64BitSet(this.env, 64);
        }
        this.index.set(blockIndex);
        return this.blocks[blockIndex];
    }

    @Override
    public void set(int bit) {
        SparseBitSet.requirePositiveIndex(bit);
        int bIdx = this.blockIndex(bit);
        this.ensureIndexCapacity(bIdx);
        this.ensureBlock(bIdx).set(this.localIndex(bit));
    }

    @Override
    public void clear(int bit) {
        SparseBitSet.requirePositiveIndex(bit);
        int bIdx = this.blockIndex(bit);
        if (!this.index.get(bIdx)) {
            return;
        }
        this.blocks[bIdx].clear(this.localIndex(bit));
    }

    @Override
    public void set(int bit, boolean flag) {
        SparseBitSet.requirePositiveIndex(bit);
        if (flag) {
            this.set(bit);
        } else {
            this.clear(bit);
        }
    }

    @Override
    public boolean get(int bit) {
        SparseBitSet.requirePositiveIndex(bit);
        int bIdx = this.blockIndex(bit);
        if (!this.index.get(bIdx)) {
            return false;
        }
        return this.blocks[bIdx].get(this.localIndex(bit));
    }

    @Override
    public int size() {
        return this.index.size() * this.blockSize;
    }

    public long memorySize() {
        long size = this.index.size();
        int bIdx = this.index.nextSetBit(0);
        while (bIdx >= 0) {
            IStateBitSet bs = this.blocks[bIdx];
            assert (bs != null);
            size += (long)bs.size();
            bIdx = this.index.nextSetBit(bIdx + 1);
        }
        return size;
    }

    @Override
    public int cardinality() {
        int sum = 0;
        int bIdx = this.index.nextSetBit(0);
        while (bIdx >= 0) {
            IStateBitSet bs = this.blocks[bIdx];
            assert (bs != null);
            sum += bs.cardinality();
            bIdx = this.index.nextSetBit(bIdx + 1);
        }
        return sum;
    }

    @Override
    public void clear() {
        int bIdx = this.index.nextSetBit(0);
        while (bIdx >= 0) {
            this.blocks[bIdx].clear();
            bIdx = this.index.nextSetBit(bIdx + 1);
        }
        this.index.clear();
    }

    @Override
    public boolean isEmpty() {
        if (this.index.isEmpty()) {
            return true;
        }
        int bIdx = this.index.nextSetBit(0);
        while (bIdx >= 0) {
            if (!this.blocks[bIdx].isEmpty()) {
                return false;
            }
            bIdx = this.index.nextSetBit(bIdx + 1);
        }
        return true;
    }

    @Override
    public void clear(int from, int to) {
        SparseBitSet.validIndexRange(from, to);
        if (from == to) {
            return;
        }
        for (int bIdx = this.blockIndex(from); bIdx <= this.blockIndex(to); ++bIdx) {
            if (bIdx >= this.blocks.length) {
                return;
            }
            if (!this.index.get(bIdx)) continue;
            int st = bIdx == this.blockIndex(from) ? this.localIndex(from) : 0;
            int ed = bIdx == this.blockIndex(to) ? this.localIndex(to) : this.blockSize;
            this.ensureBlock(bIdx).clear(st, ed);
        }
    }

    @Override
    public void set(int from, int to) {
        SparseBitSet.validIndexRange(from, to);
        if (from == to) {
            return;
        }
        this.ensureIndexCapacity(this.blockIndex(to));
        int firstBlock = this.blockIndex(from);
        int lastBlock = this.blockIndex(to);
        for (int bIdx = firstBlock; bIdx <= lastBlock; ++bIdx) {
            int st = bIdx == firstBlock ? this.localIndex(from) : 0;
            int ed = bIdx == lastBlock ? this.localIndex(to) : this.blockSize;
            this.ensureBlock(bIdx).set(st, ed);
        }
    }

    @Override
    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int startingBlock = this.blockIndex(fromIndex);
        int bIdx = this.index.nextSetBit(startingBlock);
        while (bIdx >= 0) {
            int offset = bIdx > startingBlock ? 0 : this.localIndex(fromIndex);
            int bit = this.blocks[bIdx].nextSetBit(offset);
            if (bit >= 0) {
                return this.absIndex(bIdx, bit);
            }
            bIdx = this.index.nextSetBit(bIdx + 1);
        }
        return -1;
    }

    @Override
    public int prevSetBit(int fromIndex) {
        if (fromIndex < 0) {
            return -1;
        }
        int lastBlockIdx = this.blockIndex(fromIndex);
        int bIdx = this.index.prevSetBit(lastBlockIdx);
        while (bIdx >= 0) {
            int bit;
            int offset = this.localIndex(fromIndex);
            if (bIdx < lastBlockIdx) {
                offset = this.blockSize;
            }
            if ((bit = this.blocks[bIdx].prevSetBit(offset)) >= 0) {
                return this.absIndex(bIdx, bit);
            }
            bIdx = this.index.prevSetBit(bIdx - 1);
        }
        return -1;
    }

    @Override
    public int nextClearBit(int fromIndex) {
        int fromBlock;
        int curBlock;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (!this.index.get(curBlock = (fromBlock = this.blockIndex(fromIndex)))) {
            return fromIndex;
        }
        while (curBlock < this.blocks.length && this.index.get(curBlock)) {
            int localOff = curBlock > fromBlock ? 0 : this.localIndex(fromIndex);
            int nextClear = this.blocks[curBlock].nextClearBit(localOff);
            if (nextClear != this.blockSize) {
                return this.absIndex(curBlock, nextClear);
            }
            ++curBlock;
        }
        return this.absIndex(curBlock, 0);
    }

    @Override
    public int prevClearBit(int fromIndex) {
        int curBlock;
        if (fromIndex < 0) {
            return -1;
        }
        int fromBlock = this.blockIndex(fromIndex);
        if (fromBlock >= this.index.length()) {
            return fromIndex;
        }
        for (curBlock = fromBlock; curBlock >= 0 && this.index.get(curBlock); --curBlock) {
            int localOff = curBlock < fromBlock ? this.blockSize - 1 : this.localIndex(fromIndex);
            int prevClear = this.blocks[curBlock].prevClearBit(localOff);
            if (prevClear < 0) continue;
            return this.absIndex(curBlock, prevClear);
        }
        return this.absIndex(curBlock + 1, 0) - 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IStateBitSet)) {
            return false;
        }
        IStateBitSet that = (IStateBitSet)o;
        if (this.cardinality() != that.cardinality()) {
            return false;
        }
        int i = this.nextSetBit(0);
        while (i >= 0) {
            if (!that.get(i)) {
                return false;
            }
            i = this.nextSetBit(i + 1);
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        int i = this.nextSetBit(0);
        while (i >= 0) {
            hashCode = hashCode * 31 + i;
            i = this.nextSetBit(i + 1);
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            i = this.nextSetBit(i + 1);
            while (i >= 0) {
                b.append(", ").append(i);
                i = this.nextSetBit(i + 1);
            }
        }
        b.append('}');
        return b.toString();
    }
}

